/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMufflerMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class MufflerPartMachine
extends TieredPartMachine
implements IMufflerMachine,
IUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MufflerPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private final int recoveryChance;
    @Persisted
    private final ItemStackTransfer inventory;

    public MufflerPartMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier);
        this.recoveryChance = Math.max(1, tier * 10);
        this.inventory = new ItemStackTransfer((int)Math.pow(tier + 1, 2.0));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void recoverItemsTable(class_1799 ... recoveryItems) {
        int numRolls = Math.min(recoveryItems.length, this.inventory.getSlots());
        IntStream.range(0, numRolls).forEach(slot -> {
            if (this.calculateChance()) {
                ItemTransferHelper.insertItemStacked((IItemTransfer)this.inventory, (class_1799)recoveryItems[slot].method_7972(), (boolean)false);
            }
        });
    }

    private boolean calculateChance() {
        return this.recoveryChance >= 100 || this.recoveryChance >= GTValues.RNG.method_43048(100);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick() {
        super.clientTick();
        for (IMultiController controller : this.getControllers()) {
            IRecipeLogicMachine recipeLogicMachine;
            if (!(controller instanceof IRecipeLogicMachine) || !(recipeLogicMachine = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isWorking()) continue;
            this.emitPollutionParticles();
            break;
        }
    }

    @Override
    public ModularUI createUI(class_1657 entityPlayer) {
        int rowSize = (int)Math.sqrt(this.inventory.getSlots());
        int xOffset = rowSize == 10 ? 9 : 0;
        ModularUI modular = new ModularUI(176 + xOffset * 2, 18 + 18 * rowSize + 94, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(10, 5, this.getBlockState().method_26204().method_9539())).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.method_31548(), (IGuiTexture)GuiTextures.SLOT, 7 + xOffset, 18 + 18 * rowSize + 12, true));
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                modular.widget((Widget)new SlotWidget((IItemTransfer)this.inventory, index, 88 - rowSize * 9 + x * 18 + xOffset, 18 + y * 18, true, false).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            }
        }
        return modular;
    }

    public int getRecoveryChance() {
        return this.recoveryChance;
    }

    public ItemStackTransfer getInventory() {
        return this.inventory;
    }
}

