/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_3965;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class EnergyHatchPartMachine
extends TieredIOPartMachine
implements IExplosionMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(EnergyHatchPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableEnergyContainer energyContainer;
    protected TickableSubscription explosionSubs;
    @Nullable
    protected ISubscription energyListener;
    protected int amperage;

    public EnergyHatchPartMachine(IMachineBlockEntity holder, int tier, IO io, int amperage, Object ... args) {
        super(holder, tier, io);
        this.amperage = amperage;
        this.energyContainer = this.createEnergyContainer(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        NotifiableEnergyContainer container;
        if (this.io == IO.OUT) {
            container = NotifiableEnergyContainer.emitterContainer(this, GTValues.V[this.tier] * 64L * (long)this.amperage, GTValues.V[this.tier], this.amperage);
            container.setSideOutputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
            container.setCapabilityValidator(s -> s == null || s == this.getFrontFacing());
        } else {
            container = NotifiableEnergyContainer.receiverContainer(this, GTValues.V[this.tier] * 16L * (long)this.amperage, GTValues.V[this.tier], this.amperage);
            container.setSideInputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
            container.setCapabilityValidator(s -> s == null || s == this.getFrontFacing());
        }
        return container;
    }

    @Override
    public boolean shouldOpenUI(class_1657 player, class_1268 hand, class_3965 hit) {
        return false;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (ConfigHolder.INSTANCE.machines.doTerrainExplosion && this.shouldWeatherOrTerrainExplosion()) {
            this.energyListener = this.energyContainer.addChangedListener(this::updateExplosionSubscription);
            this.updateExplosionSubscription();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.energyListener != null) {
            this.energyListener.unsubscribe();
            this.energyListener = null;
        }
    }

    protected void updateExplosionSubscription() {
        if (ConfigHolder.INSTANCE.machines.doTerrainExplosion && this.shouldWeatherOrTerrainExplosion() && this.energyContainer.getEnergyStored() > 0L) {
            this.explosionSubs = this.subscribeServerTick(this.explosionSubs, this::checkExplosion);
        } else if (this.explosionSubs != null) {
            this.explosionSubs.unsubscribe();
            this.explosionSubs = null;
        }
    }

    protected void checkExplosion() {
        this.checkWeatherOrTerrainExplosion(this.tier, this.tier * 10);
        this.updateExplosionSubscription();
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public int getAmperage() {
        return this.amperage;
    }
}

