/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.trait.FluidDrillLogic;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class FluidDrillMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    private final int tier;

    public FluidDrillMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new FluidDrillLogic(this);
    }

    public int getEnergyTier() {
        return Math.min(this.tier + 1, Math.max(this.tier, this.getOverclockTier()));
    }

    @Override
    public void addDisplayText(List<class_2561> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            int energyContainer = this.getEnergyTier();
            long maxVoltage = GTValues.V[energyContainer];
            String voltageName = GTValues.VNF[energyContainer];
            textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{maxVoltage, voltageName}));
        }
    }

    public static int getDepletionChance(int tier) {
        if (tier == 2) {
            return 1;
        }
        if (tier == 3) {
            return 2;
        }
        if (tier == 4) {
            return 8;
        }
        return 1;
    }

    public static int getRigMultiplier(int tier) {
        if (tier == 2) {
            return 1;
        }
        if (tier == 3) {
            return 16;
        }
        if (tier == 4) {
            return 64;
        }
        return 1;
    }

    public static class_2248 getCasingState(int tier) {
        if (tier == 2) {
            return (class_2248)GTBlocks.CASING_STEEL_SOLID.get();
        }
        if (tier == 3) {
            return (class_2248)GTBlocks.CASING_TITANIUM_STABLE.get();
        }
        if (tier == 4) {
            return (class_2248)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get();
        }
        return (class_2248)GTBlocks.CASING_STEEL_SOLID.get();
    }

    public static class_2248 getFrameState(int tier) {
        if (tier == 2) {
            return (class_2248)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Steel)).get();
        }
        if (tier == 3) {
            return (class_2248)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Titanium)).get();
        }
        if (tier == 4) {
            return (class_2248)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.TungstenSteel)).get();
        }
        return (class_2248)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Steel)).get();
    }

    public static class_2960 getBaseTexture(int tier) {
        if (tier == 2) {
            return GTCEu.id("block/casings/solid/machine_casing_solid_steel");
        }
        if (tier == 3) {
            return GTCEu.id("block/casings/solid/machine_casing_stable_titanium");
        }
        if (tier == 4) {
            return GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel");
        }
        return GTCEu.id("block/casings/solid/machine_casing_solid_steel");
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

