/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HarvestCropsBehavior
implements IToolBehavior {
    public static final HarvestCropsBehavior INSTANCE = new HarvestCropsBehavior();

    protected HarvestCropsBehavior() {
    }

    @Override
    @NotNull
    public class_1269 onItemUse(class_1838 context) {
        Object blocks;
        if (context.method_8045().field_9236) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_1268 hand = context.method_20287();
        class_1799 stack = player.method_5998(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition == AoESymmetrical.none()) {
            blocks = ImmutableSet.of((Object)pos);
        } else {
            class_239 rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
            if (rayTraceResult == null) {
                return class_1269.field_5811;
            }
            if (rayTraceResult.method_17783() != class_239.class_240.field_1332) {
                return class_1269.field_5811;
            }
            if (!(rayTraceResult instanceof class_3965)) {
                return class_1269.field_5811;
            }
            class_3965 blockHitResult = (class_3965)rayTraceResult;
            if (blockHitResult.method_17780() == null) {
                return class_1269.field_5811;
            }
            blocks = ToolHelper.iterateAoE(stack, aoeDefinition, player.method_37908(), player, rayTraceResult, HarvestCropsBehavior::isBlockCrops);
            if (HarvestCropsBehavior.isBlockCrops(stack, context.method_8045(), player, blockHitResult.method_17777(), context)) {
                blocks.add(blockHitResult.method_17777());
            }
        }
        boolean harvested = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            class_2338 blockPos = (class_2338)iterator.next();
            if (!HarvestCropsBehavior.harvestBlockRoutine(stack, blockPos, player)) continue;
            harvested = true;
        }
        return harvested ? class_1269.field_5812 : class_1269.field_5811;
    }

    private static boolean isBlockCrops(class_1799 stack, class_1937 world, class_1657 player, class_2338 pos, @Nullable class_1838 context) {
        if (world.method_8320(pos.method_10084()).method_26215()) {
            class_2248 block = world.method_8320(pos).method_26204();
            return block instanceof class_2302;
        }
        return false;
    }

    private static boolean harvestBlockRoutine(class_1799 stack, class_2338 pos, class_1657 player) {
        class_2680 blockState = player.method_37908().method_8320(pos);
        class_2248 block = blockState.method_26204();
        class_2302 blockCrops = (class_2302)block;
        if (blockCrops.method_9825(blockState)) {
            class_2371 drops = class_2371.method_10211();
            drops.addAll((Collection)class_2248.method_9562((class_2680)blockState, (class_3218)((class_3218)player.method_37908()), (class_2338)pos, null));
            HarvestCropsBehavior.dropListOfItems(player.method_37908(), pos, (List<class_1799>)drops);
            player.method_37908().method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
            player.method_37908().method_8652(pos, blockCrops.method_9828(0), 3);
            if (!player.method_7337()) {
                ToolHelper.damageItem(stack, (class_1309)player);
            }
            return true;
        }
        return false;
    }

    private static void dropListOfItems(class_1937 world, class_2338 pos, List<class_1799> drops) {
        for (class_1799 stack : drops) {
            float f = 0.7f;
            double offX = (double)(GTValues.RNG.method_43057() * f) + (double)(1.0f - f) * 0.5;
            double offY = (double)(GTValues.RNG.method_43057() * f) + (double)(1.0f - f) * 0.5;
            double offZ = (double)(GTValues.RNG.method_43057() * f) + (double)(1.0f - f) * 0.5;
            class_1542 entityItem = new class_1542(world, (double)pos.method_10263() + offX, (double)pos.method_10264() + offY, (double)pos.method_10260() + offZ, stack);
            entityItem.method_6988();
            world.method_8649((class_1297)entityItem);
        }
    }

    @Override
    public void addInformation(@NotNull class_1799 stack, @Nullable class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gtceu.tool.behavior.crop_harvesting"));
    }
}

