/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDamageBehavior
implements IToolBehavior {
    private final List<Function<class_1309, Float>> shouldDoBonusList = new ArrayList<Function<class_1309, Float>>();
    private final String mobType;

    public EntityDamageBehavior(float bonus, Class<?> ... entities) {
        this(null, bonus, entities);
    }

    public EntityDamageBehavior(Map<Class<?>, Float> entities) {
        this(null, entities);
    }

    public EntityDamageBehavior(String mobType, float bonus, Class<?> ... entities) {
        this.mobType = mobType;
        for (Class<?> entity : entities) {
            this.shouldDoBonusList.add(e -> Float.valueOf(entity.isAssignableFrom(e.getClass()) ? bonus : 0.0f));
        }
    }

    public EntityDamageBehavior(String mobType, Map<Class<?>, Float> entities) {
        this.mobType = mobType;
        for (Map.Entry<Class<?>, Float> entry : entities.entrySet()) {
            Class<?> entity = entry.getKey();
            float bonus = entry.getValue().floatValue();
            this.shouldDoBonusList.add(e -> Float.valueOf(entity.isAssignableFrom(e.getClass()) ? bonus : 0.0f));
        }
    }

    @Override
    public void hitEntity(@NotNull class_1799 stack, @NotNull class_1309 target, @NotNull class_1309 attacker) {
        float damageBonus = this.shouldDoBonusList.stream().map(func -> (Float)func.apply(target)).filter(f -> f.floatValue() > 0.0f).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
        if (damageBonus != 0.0f) {
            class_1282 class_12822;
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                class_12822 = attacker.method_48923().method_48802(player);
            } else {
                class_12822 = attacker.method_48923().method_48812(attacker);
            }
            class_1282 source = class_12822;
            target.method_5643(source, damageBonus);
        }
    }

    @Override
    public void addInformation(@NotNull class_1799 stack, @Nullable class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
        if (this.mobType != null && !this.mobType.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.behavior.damage_boost", (Object[])new Object[]{class_2561.method_43471((String)("item.gtceu.tool.behavior.damage_boost_" + this.mobType))}));
        }
    }
}

