/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.RotorProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMaterialPartItem;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class TurbineRotorBehaviour
implements IMaterialPartItem,
ISubItemHandler {
    @Override
    public void fillItemCategory(ComponentItem item, class_1761 category, class_2371<class_1799> items) {
        TagPrefix.turbineBlade.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> {
            class_1799 rotorStack = new class_1799((class_1935)item);
            TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(rotorStack);
            if (behavior != null) {
                behavior.setPartMaterial(rotorStack, (Material)material);
                items.add((Object)rotorStack);
            }
        });
    }

    @Override
    public int getPartMaxDurability(class_1799 itemStack) {
        RotorProperty property = this.getPartMaterial(itemStack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : 800 * (int)Math.pow(property.getDurability(), 0.65);
    }

    public int getRotorEfficiency(class_1799 stack) {
        RotorProperty property = this.getPartMaterial(stack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : (int)(60.0f + property.getSpeed() * 8.0f) / 5 * 5;
    }

    public int getRotorDurabilityPercent(class_1799 itemStack) {
        return 100 - 100 * this.getPartDamage(itemStack) / this.getPartMaxDurability(itemStack);
    }

    public void applyRotorDamage(class_1799 itemStack, int damageApplied) {
        int rotorDurability = this.getPartMaxDurability(itemStack);
        int resultDamage = this.getPartDamage(itemStack) + damageApplied;
        if (resultDamage >= rotorDurability) {
            itemStack.method_7934(1);
        } else {
            this.setPartDamage(itemStack, resultDamage);
        }
    }

    public int getRotorPower(class_1799 stack) {
        RotorProperty property = this.getPartMaterial(stack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : (int)(40.0f + property.getDamage() * 30.0f);
    }

    @Override
    public void appendHoverText(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        IMaterialPartItem.super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"metaitem.tool.tooltip.rotor.efficiency", (Object[])new Object[]{this.getRotorEfficiency(stack)}));
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"metaitem.tool.tooltip.rotor.power", (Object[])new Object[]{this.getRotorPower(stack)}));
    }

    @javax.annotation.Nullable
    public static TurbineRotorBehaviour getBehaviour(@Nonnull class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof ComponentItem) {
            ComponentItem componentItem = (ComponentItem)class_17922;
            for (IItemComponent component : componentItem.getComponents()) {
                if (!(component instanceof TurbineRotorBehaviour)) continue;
                TurbineRotorBehaviour behaviour = (TurbineRotorBehaviour)component;
                return behaviour;
            }
        }
        return null;
    }
}

