/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.gui.widget.ProspectingMapWidget;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import org.jetbrains.annotations.Nullable;

public class ProspectorScannerBehavior
implements IItemUIFactory,
IInteractionItem,
IAddInformation {
    private final int radius;
    private final long cost;
    private final ProspectorMode<?>[] modes;

    public ProspectorScannerBehavior(int radius, long cost, ProspectorMode<?> ... modes) {
        this.radius = radius + 1;
        this.modes = (ProspectorMode[])Arrays.stream(modes).filter(Objects::nonNull).toArray(ProspectorMode[]::new);
        this.cost = cost;
    }

    @Nonnull
    public ProspectorMode<?> getMode(class_1799 stack) {
        if (stack == class_1799.field_8037) {
            return this.modes[0];
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return this.modes[0];
        }
        return this.modes[tag.method_10550("Mode") % this.modes.length];
    }

    public void setNextMode(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("Mode", (tag.method_10550("Mode") + 1) % this.modes.length);
    }

    public boolean drainEnergy(@Nonnull class_1799 stack, boolean simulate) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(this.cost, Integer.MAX_VALUE, true, false, simulate) >= this.cost;
    }

    @Override
    public class_1271<class_1799> use(class_1792 item, class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 heldItem = player.method_5998(usedHand);
        if (player.method_18276() && this.modes.length > 1) {
            if (!level.field_9236) {
                this.setNextMode(heldItem);
                ProspectorMode<?> mode = this.getMode(heldItem);
                player.method_43496((class_2561)class_2561.method_43471((String)mode.unlocalizedName));
            }
            return class_1271.method_22427((Object)heldItem);
        }
        if (!player.method_7337() && !this.drainEnergy(heldItem, true)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"behavior.prospector.not_enough_energy"));
            return class_1271.method_22427((Object)heldItem);
        }
        return IItemUIFactory.super.use(item, level, player, usedHand);
    }

    @Override
    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, class_1657 entityPlayer) {
        ProspectorMode<?> mode = this.getMode(entityPlayer.method_5998(class_1268.field_5808));
        ProspectingMapWidget map = new ProspectingMapWidget(4, 4, 324, 192, this.radius, mode, 1);
        return new ModularUI(332, 200, (IUIHolder)holder, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)map).widget((Widget)new SwitchWidget(-20, 4, 18, 18, (cd, pressed) -> map.setDarkMode((boolean)pressed)).setSupplier(map::isDarkMode).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.5, 1.0, 0.5).scale(0.8f)}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.0, 1.0, 0.5).scale(0.8f)})));
    }

    @Override
    public void appendHoverText(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"metaitem.prospector.tooltip.radius", (Object[])new Object[]{this.radius}));
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"metaitem.prospector.tooltip.modes"));
        for (ProspectorMode<?> mode : this.modes) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)" -").method_10852((class_2561)class_2561.method_43471((String)mode.unlocalizedName)).method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
        }
    }
}

