/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CoilWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import it.unimi.dsi.fastutil.longs.LongIntPair;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.class_156;
import net.minecraft.class_3545;

public class GTRecipeModifiers {
    public static final Function<OverclockingLogic, BiFunction<MetaMachine, GTRecipe, GTRecipe>> ELECTRIC_OVERCLOCK = class_156.method_34866(overclockingLogic -> (machine, recipe) -> {
        if (machine instanceof ITieredMachine) {
            ITieredMachine tieredMachine = (ITieredMachine)((Object)machine);
            if (RecipeHelper.getRecipeEUtTier(recipe) > tieredMachine.getTier()) {
                return null;
            }
        }
        if (machine instanceof IOverclockMachine) {
            IOverclockMachine overclockMachine = (IOverclockMachine)((Object)machine);
            return RecipeHelper.applyOverclock(overclockingLogic, recipe, overclockMachine.getOverclockVoltage());
        }
        return recipe;
    });
    public static final BiFunction<OverclockingLogic, Function<OverclockingLogic, BiFunction<MetaMachine, GTRecipe, GTRecipe>>, BiFunction<MetaMachine, GTRecipe, GTRecipe>> PARALLEL_HATCH = class_156.method_34865((overclockingLogic, function) -> (machine, recipe) -> {
        class_3545<GTRecipe, Integer> paralleledRecipe = GTRecipeModifiers.hatchParallel(machine, recipe, false);
        return (GTRecipe)((BiFunction)function.apply(overclockingLogic)).apply(machine, (GTRecipe)paralleledRecipe.method_15442());
    });

    public static class_3545<GTRecipe, Integer> fastParallel(MetaMachine machine, @Nonnull GTRecipe recipe, int maxParallel, boolean modifyDuration) {
        if (machine instanceof IRecipeCapabilityHolder) {
            IRecipeCapabilityHolder holder = (IRecipeCapabilityHolder)((Object)machine);
            while (maxParallel > 0) {
                GTRecipe copied = recipe.copy(ContentModifier.multiplier(maxParallel), modifyDuration);
                if (copied.matchRecipe(holder).isSuccess() && copied.matchTickRecipe(holder).isSuccess()) {
                    return new class_3545((Object)copied, (Object)maxParallel);
                }
                maxParallel /= 2;
            }
        }
        return new class_3545((Object)recipe, (Object)1);
    }

    public static class_3545<GTRecipe, Integer> accurateParallel(MetaMachine machine, @Nonnull GTRecipe recipe, int maxParallel, boolean modifyDuration) {
        if (maxParallel == 1) {
            return new class_3545((Object)recipe, (Object)1);
        }
        if (machine instanceof IRecipeCapabilityHolder) {
            IRecipeCapabilityHolder holder = (IRecipeCapabilityHolder)((Object)machine);
            class_3545 parallel = GTRecipeModifiers.tryParallel(holder, recipe, 1, maxParallel, modifyDuration);
            return parallel == null ? new class_3545((Object)recipe, (Object)1) : parallel;
        }
        return null;
    }

    private static class_3545<GTRecipe, Integer> tryParallel(IRecipeCapabilityHolder holder, GTRecipe original, int min, int max, boolean modifyDuration) {
        if (min > max) {
            return null;
        }
        int mid = (min + max) / 2;
        GTRecipe copied = original.copy(ContentModifier.multiplier(mid), modifyDuration);
        if (!copied.matchRecipe(holder).isSuccess() || !copied.matchTickRecipe(holder).isSuccess()) {
            return GTRecipeModifiers.tryParallel(holder, original, min, mid - 1, modifyDuration);
        }
        if (mid == max) {
            return new class_3545((Object)copied, (Object)mid);
        }
        class_3545 tryMore = GTRecipeModifiers.tryParallel(holder, original, mid + 1, max, modifyDuration);
        return tryMore != null ? tryMore : new class_3545((Object)copied, (Object)mid);
    }

    public static class_3545<GTRecipe, Integer> hatchParallel(MetaMachine machine, @Nonnull GTRecipe recipe, boolean modifyDuration) {
        IMultiController controller;
        if (machine instanceof IMultiController && (controller = (IMultiController)((Object)machine)).isFormed()) {
            Optional<IParallelHatch> optional = controller.getParts().stream().filter(IParallelHatch.class::isInstance).map(IParallelHatch.class::cast).findAny();
            if (optional.isPresent()) {
                IParallelHatch hatch = optional.get();
                return GTRecipeModifiers.accurateParallel(machine, recipe, hatch.getCurrentParallel(), modifyDuration);
            }
        }
        return new class_3545((Object)recipe, (Object)1);
    }

    public static GTRecipe crackerOverclock(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            return RecipeHelper.applyOverclock(new OverclockingLogic((recipe1, recipeEUt, maxVoltage, duration, amountOC) -> {
                LongIntPair pair = OverclockingLogic.NON_PERFECT_OVERCLOCK.getLogic().runOverclockingLogic(recipe, recipeEUt, maxVoltage, duration, amountOC);
                if (coilMachine.getCoilTier() > 0) {
                    double eu = (double)pair.firstLong() * (1.0 - (double)coilMachine.getCoilTier() * 0.1);
                    pair.first((long)Math.max(1.0, eu));
                }
                return pair;
            }), recipe, coilMachine.getMaxVoltage());
        }
        return null;
    }

    public static GTRecipe ebfOverclock(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            int blastFurnaceTemperature = coilMachine.getCoilType().getCoilTemperature() + 100 * Math.max(0, coilMachine.getTier() - 2);
            if (!recipe.data.method_10545("ebf_temp") || recipe.data.method_10550("ebf_temp") > blastFurnaceTemperature) {
                return null;
            }
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            return RecipeHelper.applyOverclock(new OverclockingLogic((recipe1, recipeEUt, maxVoltage, duration, amountOC) -> OverclockingLogic.heatingCoilOverclockingLogic(Math.abs(recipeEUt), maxVoltage, duration, amountOC, blastFurnaceTemperature, recipe.data.method_10545("ebf_temp") ? recipe.data.method_10550("ebf_temp") : 0)), recipe, coilMachine.getMaxVoltage());
        }
        return null;
    }

    public static GTRecipe pyrolyseOvenOverclock(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > coilMachine.getTier()) {
                return null;
            }
            return RecipeHelper.applyOverclock(new OverclockingLogic((recipe1, recipeEUt, maxVoltage, duration, amountOC) -> {
                LongIntPair pair = OverclockingLogic.NON_PERFECT_OVERCLOCK.getLogic().runOverclockingLogic(recipe1, recipeEUt, maxVoltage, duration, amountOC);
                if (coilMachine.getCoilTier() == 0) {
                    pair.second(pair.secondInt() * 5 / 4);
                } else {
                    pair.second(pair.secondInt() * 2 / (coilMachine.getCoilTier() + 1));
                }
                pair.second(Math.max(1, pair.secondInt()));
                return pair;
            }), recipe, coilMachine.getMaxVoltage());
        }
        return null;
    }

    public static GTRecipe multiSmelterOverclock(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)machine;
            long energyCost = Math.max(1L, (long)(16 / coilMachine.getCoilType().getEnergyDiscount()));
            int maxParallel = 32 * coilMachine.getCoilType().getLevel();
            int parallelLimit = Math.min(maxParallel, (int)(coilMachine.getMaxVoltage() / energyCost));
            class_3545<GTRecipe, Integer> result = GTRecipeModifiers.accurateParallel(machine, recipe, parallelLimit, false);
            recipe = result.method_15442() == recipe ? ((GTRecipe)result.method_15442()).copy() : (GTRecipe)result.method_15442();
            int parallelValue = (Integer)result.method_15441();
            recipe.duration = Math.max(1, 256 * parallelValue / maxParallel);
            long eut = (long)parallelValue * energyCost;
            recipe.tickInputs.put(EURecipeCapability.CAP, List.of(new Content(eut, 1.0f, 0.0f, null, null)));
            return recipe;
        }
        return null;
    }
}

