/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.events.MaterialCasingCollectionEvent;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.block.IFusionCasingType;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.block.RendererBlock;
import com.gregtechceu.gtceu.api.block.RendererGlassBlock;
import com.gregtechceu.gtceu.api.block.RendererMaterialBlock;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.LaserPipeBlockItem;
import com.gregtechceu.gtceu.api.item.MaterialBlockItem;
import com.gregtechceu.gtceu.api.item.MaterialPipeBlockItem;
import com.gregtechceu.gtceu.api.item.RendererBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeBlock;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.client.renderer.block.CTMModelRenderer;
import com.gregtechceu.gtceu.client.renderer.block.OreBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.block.TextureOverrideRenderer;
import com.gregtechceu.gtceu.common.block.BatteryBlock;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.block.CleanroomFilterType;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import com.gregtechceu.gtceu.common.block.FluidPipeBlock;
import com.gregtechceu.gtceu.common.block.FusionCasingBlock;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.block.LaserPipeBlock;
import com.gregtechceu.gtceu.common.block.MinerPipeBlock;
import com.gregtechceu.gtceu.common.block.RubberLogBlock;
import com.gregtechceu.gtceu.common.block.SurfaceRockBlock;
import com.gregtechceu.gtceu.common.data.GCyMBlocks;
import com.gregtechceu.gtceu.common.data.GTCompassNodes;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.gregtechceu.gtceu.common.data.GTConfiguredFeatures;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTModels;
import com.gregtechceu.gtceu.common.data.GTSoundTypes;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemPipeType;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeType;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1163;
import net.minecraft.class_192;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1926;
import net.minecraft.class_1935;
import net.minecraft.class_212;
import net.minecraft.class_219;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2473;
import net.minecraft.class_2498;
import net.minecraft.class_2647;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3620;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_85;

public class GTBlocks {
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<? extends MaterialBlock>> MATERIAL_BLOCKS_BUILDER = ImmutableTable.builder();
    private static ImmutableMap.Builder<Material, BlockEntry<SurfaceRockBlock>> SURFACE_ROCK_BLOCKS_BUILDER = ImmutableMap.builder();
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<CableBlock>> CABLE_BLOCKS_BUILDER = ImmutableTable.builder();
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<FluidPipeBlock>> FLUID_PIPE_BLOCKS_BUILDER = ImmutableTable.builder();
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<ItemPipeBlock>> ITEM_PIPE_BLOCKS_BUILDER = ImmutableTable.builder();
    public static Table<TagPrefix, Material, BlockEntry<? extends MaterialBlock>> MATERIAL_BLOCKS;
    public static Map<Material, BlockEntry<SurfaceRockBlock>> SURFACE_ROCK_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<CableBlock>> CABLE_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<FluidPipeBlock>> FLUID_PIPE_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<ItemPipeBlock>> ITEM_PIPE_BLOCKS;
    public static final BlockEntry<LaserPipeBlock>[] LASER_PIPES;
    public static final BlockEntry<LongDistancePipeBlock> LD_ITEM_PIPE;
    public static final BlockEntry<LongDistancePipeBlock> LD_FLUID_PIPE;
    public static final BlockEntry<class_2248> CASING_COKE_BRICKS;
    public static final BlockEntry<class_2248> CASING_PRIMITIVE_BRICKS;
    public static final BlockEntry<class_2248> CASING_BRONZE_BRICKS;
    public static final BlockEntry<class_2248> CASING_INVAR_HEATPROOF;
    public static final BlockEntry<class_2248> CASING_ALUMINIUM_FROSTPROOF;
    public static final BlockEntry<class_2248> CASING_STEEL_SOLID;
    public static final BlockEntry<class_2248> CASING_STAINLESS_CLEAN;
    public static final BlockEntry<class_2248> CASING_TITANIUM_STABLE;
    public static final BlockEntry<class_2248> CASING_TUNGSTENSTEEL_ROBUST;
    public static final BlockEntry<class_2248> CASING_PTFE_INERT;
    public static final BlockEntry<class_2248> CASING_HSSE_STURDY;
    public static final BlockEntry<class_2248> CASING_PALLADIUM_SUBSTATION;
    public static final BlockEntry<class_2248> CASING_TEMPERED_GLASS;
    public static final ImmutableMap<Material, BlockEntry<class_2248>> MATERIALS_TO_CASINGS;
    public static final BlockEntry<class_2248> CASING_GRATE;
    public static final BlockEntry<class_2248> CASING_ASSEMBLY_CONTROL;
    public static final BlockEntry<class_2248> CASING_LAMINATED_GLASS;
    public static final BlockEntry<ActiveBlock> CASING_ASSEMBLY_LINE;
    public static final BlockEntry<class_2248> CASING_BRONZE_GEARBOX;
    public static final BlockEntry<class_2248> CASING_STEEL_GEARBOX;
    public static final BlockEntry<class_2248> CASING_STAINLESS_STEEL_GEARBOX;
    public static final BlockEntry<class_2248> CASING_TITANIUM_GEARBOX;
    public static final BlockEntry<class_2248> CASING_TUNGSTENSTEEL_GEARBOX;
    public static final BlockEntry<class_2248> CASING_STEEL_TURBINE;
    public static final BlockEntry<class_2248> CASING_TITANIUM_TURBINE;
    public static final BlockEntry<class_2248> CASING_STAINLESS_TURBINE;
    public static final BlockEntry<class_2248> CASING_TUNGSTENSTEEL_TURBINE;
    public static final BlockEntry<class_2248> CASING_BRONZE_PIPE;
    public static final BlockEntry<class_2248> CASING_STEEL_PIPE;
    public static final BlockEntry<class_2248> CASING_TITANIUM_PIPE;
    public static final BlockEntry<class_2248> CASING_TUNGSTENSTEEL_PIPE;
    public static final BlockEntry<class_2248> CASING_POLYTETRAFLUOROETHYLENE_PIPE;
    public static final BlockEntry<MinerPipeBlock> MINER_PIPE;
    public static final BlockEntry<class_2248> CASING_PUMP_DECK;
    public static final BlockEntry<class_2248> MACHINE_CASING_ULV;
    public static final BlockEntry<class_2248> MACHINE_CASING_LV;
    public static final BlockEntry<class_2248> MACHINE_CASING_MV;
    public static final BlockEntry<class_2248> MACHINE_CASING_HV;
    public static final BlockEntry<class_2248> MACHINE_CASING_EV;
    public static final BlockEntry<class_2248> MACHINE_CASING_IV;
    public static final BlockEntry<class_2248> MACHINE_CASING_LuV;
    public static final BlockEntry<class_2248> MACHINE_CASING_ZPM;
    public static final BlockEntry<class_2248> MACHINE_CASING_UV;
    public static final BlockEntry<class_2248> MACHINE_CASING_UHV;
    public static final BlockEntry<class_2248> MACHINE_CASING_UEV;
    public static final BlockEntry<class_2248> MACHINE_CASING_UIV;
    public static final BlockEntry<class_2248> MACHINE_CASING_UXV;
    public static final BlockEntry<class_2248> MACHINE_CASING_OpV;
    public static final BlockEntry<class_2248> MACHINE_CASING_MAX;
    public static final BlockEntry<class_2248> HERMETIC_CASING_LV;
    public static final BlockEntry<class_2248> HERMETIC_CASING_MV;
    public static final BlockEntry<class_2248> HERMETIC_CASING_HV;
    public static final BlockEntry<class_2248> HERMETIC_CASING_EV;
    public static final BlockEntry<class_2248> HERMETIC_CASING_IV;
    public static final BlockEntry<class_2248> HERMETIC_CASING_LuV;
    public static final BlockEntry<class_2248> HERMETIC_CASING_ZPM;
    public static final BlockEntry<class_2248> HERMETIC_CASING_UV;
    public static final BlockEntry<class_2248> HERMETIC_CASING_UHV;
    public static final BlockEntry<class_2248> BRONZE_HULL;
    public static final BlockEntry<class_2248> BRONZE_BRICKS_HULL;
    public static final BlockEntry<class_2248> STEEL_HULL;
    public static final BlockEntry<class_2248> STEEL_BRICKS_HULL;
    public static final Map<ICoilType, Supplier<CoilBlock>> ALL_COILS;
    public static final BlockEntry<CoilBlock> COIL_CUPRONICKEL;
    public static final BlockEntry<CoilBlock> COIL_KANTHAL;
    public static final BlockEntry<CoilBlock> COIL_NICHROME;
    public static final BlockEntry<CoilBlock> COIL_TUNGSTENSTEEL;
    public static final BlockEntry<CoilBlock> COIL_HSSG;
    public static final BlockEntry<CoilBlock> COIL_NAQUADAH;
    public static final BlockEntry<CoilBlock> COIL_TRINIUM;
    public static final BlockEntry<CoilBlock> COIL_TRITANIUM;
    public static final Map<IBatteryData, Supplier<BatteryBlock>> PSS_BATTERIES;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_I;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_EV;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_IV;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_II;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_LuV;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_ZPM;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_III;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_UV;
    public static final BlockEntry<BatteryBlock> BATTERY_ULTIMATE_UHV;
    public static final BlockEntry<ActiveBlock> CASING_ENGINE_INTAKE;
    public static final BlockEntry<ActiveBlock> CASING_EXTREME_ENGINE_INTAKE;
    public static final Map<IFusionCasingType, Supplier<FusionCasingBlock>> ALL_FUSION_CASINGS;
    public static final BlockEntry<FusionCasingBlock> SUPERCONDUCTING_COIL;
    public static final BlockEntry<FusionCasingBlock> FUSION_COIL;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING_MK2;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING_MK3;
    public static final BlockEntry<class_2248> FUSION_GLASS;
    public static final Map<IFilterType, Supplier<class_2248>> ALL_FILTERS;
    public static final BlockEntry<class_2248> PLASTCRETE;
    public static final BlockEntry<class_2248> FILTER_CASING;
    public static final BlockEntry<class_2248> FILTER_CASING_STERILE;
    public static final BlockEntry<class_2248> CLEANROOM_GLASS;
    public static final Map<BoilerFireboxType, BlockEntry<ActiveBlock>> ALL_FIREBOXES;
    public static final BlockEntry<ActiveBlock> FIREBOX_BRONZE;
    public static final BlockEntry<ActiveBlock> FIREBOX_STEEL;
    public static final BlockEntry<ActiveBlock> FIREBOX_TITANIUM;
    public static final BlockEntry<ActiveBlock> FIREBOX_TUNGSTENSTEEL;
    public static final BlockEntry<class_2248> HIGH_POWER_CASING;
    public static final BlockEntry<class_2473> RUBBER_SAPLING;
    public static final BlockEntry<RubberLogBlock> RUBBER_LOG;
    public static final float[] RUBBER_LEAVES_DROPPING_CHANCE;
    public static final BlockEntry<class_2397> RUBBER_LEAVES;
    public static final BlockEntry<class_2248> RUBBER_PLANK;
    public static final BlockEntry<class_2248> TREATED_WOOD_PLANK;

    private static void generateMaterialBlocks() {
        GTCEu.LOGGER.info("Generating Compressed Blocks...");
        for (Material material : GTRegistries.MATERIALS) {
            if (!GTBlocks.allowMaterialBlock(material)) continue;
            GTBlocks.registerMaterialBlock(material);
        }
        GTCEu.LOGGER.info("Generating Compressed Blocks... Complete!");
    }

    private static boolean allowMaterialBlock(Material material) {
        return (material.hasProperty(PropertyKey.INGOT) || material.hasProperty(PropertyKey.GEM) || material.hasFlag(MaterialFlags.FORCE_GENERATE_BLOCK)) && !TagPrefix.block.isIgnored(material);
    }

    private static void registerMaterialBlock(Material material) {
        BlockEntry entry = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("%s_block".formatted(material.getName()), properties -> new MaterialBlock(properties.method_42327(), TagPrefix.block, material)).initialProperties(() -> class_2246.field_10085).transform(GTBlocks.unificationBlock(TagPrefix.block, material))).addLayer(() -> class_1921::method_23583).setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item(MaterialBlockItem::create).onRegister(MaterialBlockItem::onRegister)).model(NonNullBiConsumer.noop()).color(() -> MaterialBlockItem::tintColor).build()).register();
        MATERIAL_BLOCKS_BUILDER.put((Object)TagPrefix.block, (Object)material, (Object)entry);
    }

    private static void generateFrameBlocks() {
        GTCEu.LOGGER.info("Generating Frame Blocks...");
        for (Material material : GTRegistries.MATERIALS) {
            if (!GTBlocks.allowFrameBlock(material)) continue;
            GTBlocks.registerFrameBlock(material);
        }
        GTCEu.LOGGER.info("Generating Frame Blocks... Complete!");
    }

    private static boolean allowFrameBlock(Material material) {
        return material.hasProperty(PropertyKey.DUST) && material.hasFlag(MaterialFlags.GENERATE_FRAME);
    }

    private static void registerFrameBlock(Material material) {
        BlockEntry entry = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("%s_frame".formatted(material.getName()), properties -> new MaterialBlock((class_4970.class_2251)properties, TagPrefix.frameGt, material)).initialProperties(() -> class_2246.field_10085).properties(properties -> properties.method_22488().method_42327()).transform(GTBlocks.unificationBlock(TagPrefix.frameGt, material))).addLayer(() -> class_1921::method_23583).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item(MaterialBlockItem::create).onRegister(MaterialBlockItem::onRegister)).model(NonNullBiConsumer.noop()).color(() -> MaterialBlockItem::tintColor).build()).register();
        MATERIAL_BLOCKS_BUILDER.put((Object)TagPrefix.frameGt, (Object)material, (Object)entry);
    }

    private static void generateRawOreBlocks() {
        GTCEu.LOGGER.info("Generating Raw Ore Blocks...");
        for (Material material : GTRegistries.MATERIALS) {
            if (!GTBlocks.allowRawOreBlock(material)) continue;
            GTBlocks.registerRawOreBlock(material);
        }
        GTCEu.LOGGER.info("Generating Raw Ore Blocks... Complete!");
    }

    private static boolean allowRawOreBlock(Material material) {
        return !TagPrefix.rawOreBlock.isIgnored(material) && TagPrefix.rawOreBlock.generationCondition().test(material) && material.hasProperty(PropertyKey.ORE);
    }

    private static void registerRawOreBlock(Material material) {
        BlockEntry entry = ((BlockBuilder)((ItemBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("raw_%s_block".formatted(material.getName()), properties -> new MaterialBlock(properties.method_42327(), TagPrefix.rawOreBlock, material)).initialProperties(() -> class_2246.field_33508).transform(GTBlocks.unificationBlock(TagPrefix.rawOreBlock, material))).addLayer(() -> class_1921::method_23583).setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item(MaterialBlockItem::create).onRegister(MaterialBlockItem::onRegister)).model(NonNullBiConsumer.noop()).color(() -> MaterialBlockItem::tintColor).onRegister(GTBlocks.compassNodeExist(GTCompassSections.GENERATIONS, "raw_ore", GTCompassNodes.ORE))).build()).register();
        MATERIAL_BLOCKS_BUILDER.put((Object)TagPrefix.rawOreBlock, (Object)material, (Object)entry);
    }

    private static void generateOreBlocks() {
        GTCEu.LOGGER.info("Generating Ore Blocks...");
        for (Material material : GTRegistries.MATERIALS) {
            if (!GTBlocks.allowOreBlock(material)) continue;
            GTBlocks.registerOreBlock(material);
        }
        GTCEu.LOGGER.info("Generating Ore Blocks... Complete!");
    }

    private static boolean allowOreBlock(Material material) {
        return material.hasProperty(PropertyKey.ORE);
    }

    private static void registerOreBlock(Material material) {
        OreProperty oreProperty = material.getProperty(PropertyKey.ORE);
        for (Map.Entry<TagPrefix, TagPrefix.OreType> ore : TagPrefix.ORES.entrySet()) {
            if (ore.getKey().isIgnored(material)) continue;
            TagPrefix oreTag = ore.getKey();
            TagPrefix.OreType oreType = ore.getValue();
            BlockEntry entry = ((BlockBuilder)((ItemBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("%s%s_ore".formatted(oreTag != TagPrefix.ore ? FormattingUtil.toLowerCaseUnder(oreTag.name) + "_" : "", material.getName()), properties -> new RendererMaterialBlock((class_4970.class_2251)properties, oreTag, material, (IRenderer)(Platform.isClient() ? new OreBlockRenderer(oreType.stoneType(), (Supplier<class_2960>)Suppliers.memoize(() -> Objects.requireNonNull(oreTag.materialIconType()).getBlockTexturePath(material.getMaterialIconSet(), true)), (Supplier<class_2960>)Suppliers.memoize(() -> Objects.requireNonNull(oreTag.materialIconType()).getBlockTexturePath(material.getMaterialIconSet(), "layer2", true)), oreProperty.isEmissive()) : null))).initialProperties(() -> {
                if (oreType.stoneType().get().method_26215()) {
                    return class_2246.field_10340;
                }
                return oreType.stoneType().get().method_26204();
            }).properties(properties -> {
                if (oreType.color() != null) {
                    properties.method_31710(oreType.color());
                }
                if (oreType.sound() != null) {
                    properties.method_9626(oreType.sound());
                }
                return properties.method_42327();
            }).transform(GTBlocks.unificationBlock(oreTag, material))).addLayer(() -> class_1921::method_23583).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item(MaterialBlockItem::create).onRegister(MaterialBlockItem::onRegister)).model(NonNullBiConsumer.noop()).color(() -> MaterialBlockItem::tintColor).onRegister(GTBlocks.compassNodeExist(GTCompassSections.GENERATIONS, oreTag.name, GTCompassNodes.ORE))).build()).register();
            MATERIAL_BLOCKS_BUILDER.put((Object)oreTag, (Object)material, (Object)entry);
        }
    }

    private static void generateOreIndicators() {
        GTCEu.LOGGER.info("Generating Surface Rock Indicator Blocks...");
        for (Material material : GTRegistries.MATERIALS) {
            if (!GTBlocks.allowOreIndicator(material)) continue;
            GTBlocks.registerOreIndicator(material);
        }
        SURFACE_ROCK_BLOCKS = SURFACE_ROCK_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.info("Generating Surface Rock Indicator Blocks... Complete!");
    }

    private static boolean allowOreIndicator(Material material) {
        return material.hasProperty(PropertyKey.ORE);
    }

    private static void registerOreIndicator(Material material) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("%s_indicator".formatted(material.getName()), p -> new SurfaceRockBlock((class_4970.class_2251)p, material)).initialProperties(() -> class_2246.field_10255).properties(p -> p.method_42327().method_9632(0.25f)).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> class_1921::method_23579).color(() -> SurfaceRockBlock::tintedColor).register();
        SURFACE_ROCK_BLOCKS_BUILDER.put((Object)material, (Object)entry);
    }

    private static void generateCableBlocks() {
        GTCEu.LOGGER.info("Generating Cable/Wire Blocks...");
        for (Insulation insulation : Insulation.values()) {
            for (Material material : GTRegistries.MATERIALS) {
                if (!GTBlocks.allowCableBlock(material, insulation)) continue;
                GTBlocks.registerCableBlock(material, insulation);
            }
        }
        CABLE_BLOCKS = CABLE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.info("Generating Cable/Wire Blocks... Complete!");
    }

    private static boolean allowCableBlock(Material material, Insulation insulation) {
        return material.hasProperty(PropertyKey.WIRE) && !insulation.tagPrefix.isIgnored(material) && (!insulation.isCable || !material.getProperty(PropertyKey.WIRE).isSuperconductor());
    }

    private static void registerCableBlock(Material material, Insulation insulation) {
        BlockEntry entry = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("%s_%s".formatted(material.getName(), insulation.name), p -> new CableBlock((class_4970.class_2251)p, insulation, material)).initialProperties(() -> class_2246.field_10085).properties(p -> p.method_9624().method_22488().method_42327()).transform(GTBlocks.unificationBlock(insulation.tagPrefix, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> class_1921::method_23579).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).onRegister(GTBlocks.compassNodeExist(GTCompassSections.MATERIALS, "wire_and_cable", new CompassNode[0]))).build()).register();
        CABLE_BLOCKS_BUILDER.put((Object)insulation.tagPrefix, (Object)material, (Object)entry);
    }

    private static void generateFluidPipeBlocks() {
        GTCEu.LOGGER.info("Generating Fluid Pipe Blocks...");
        for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
            for (Material material : GTRegistries.MATERIALS) {
                if (!GTBlocks.allowFluidPipeBlock(material, fluidPipeType)) continue;
                GTBlocks.registerFluidPipeBlock(material, fluidPipeType);
            }
        }
        FLUID_PIPE_BLOCKS = FLUID_PIPE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.info("Generating Fluid Pipe Blocks... Complete!");
    }

    private static boolean allowFluidPipeBlock(Material material, FluidPipeType fluidPipeType) {
        return material.hasProperty(PropertyKey.FLUID_PIPE) && !fluidPipeType.tagPrefix.isIgnored(material);
    }

    private static void registerFluidPipeBlock(Material material, FluidPipeType fluidPipeType) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("%s_%s_fluid_pipe".formatted(material.getName(), fluidPipeType.name), p -> new FluidPipeBlock((class_4970.class_2251)p, fluidPipeType, material)).initialProperties(() -> class_2246.field_10085).properties(p -> {
            if (GTBlocks.doMetalPipe(material)) {
                p.method_9626(GTSoundTypes.METAL_PIPE);
            }
            return p.method_9624().method_22488().method_42327();
        }).transform(GTBlocks.unificationBlock(fluidPipeType.tagPrefix, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> class_1921::method_23579).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).build()).register();
        FLUID_PIPE_BLOCKS_BUILDER.put((Object)fluidPipeType.tagPrefix, (Object)material, (Object)entry);
    }

    private static void generateItemPipeBlocks() {
        GTCEu.LOGGER.info("Generating Item Pipe Blocks...");
        for (ItemPipeType itemPipeType : ItemPipeType.values()) {
            for (Material material : GTRegistries.MATERIALS) {
                if (!GTBlocks.allowItemPipeBlock(material, itemPipeType)) continue;
                GTBlocks.registerItemPipeBlock(material, itemPipeType);
            }
        }
        ITEM_PIPE_BLOCKS = ITEM_PIPE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.info("Generating Item Pipe Blocks... Complete!");
    }

    private static boolean allowItemPipeBlock(Material material, ItemPipeType itemPipeType) {
        return material.hasProperty(PropertyKey.ITEM_PIPE) && !itemPipeType.getTagPrefix().isIgnored(material);
    }

    private static void registerItemPipeBlock(Material material, ItemPipeType itemPipeType) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)GTRegistries.REGISTRATE.block("%s_%s_item_pipe".formatted(material.getName(), itemPipeType.name), p -> new ItemPipeBlock((class_4970.class_2251)p, itemPipeType, material)).initialProperties(() -> class_2246.field_10085).properties(p -> {
            if (GTBlocks.doMetalPipe(material)) {
                p.method_9626(GTSoundTypes.METAL_PIPE);
            }
            return p.method_9624().method_22488().method_42327();
        }).transform(GTBlocks.unificationBlock(itemPipeType.getTagPrefix(), material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> class_1921::method_23579).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).build()).register();
        ITEM_PIPE_BLOCKS_BUILDER.put((Object)itemPipeType.getTagPrefix(), (Object)material, (Object)entry);
    }

    private static void generateLaserPipeBlocks() {
        GTCEu.LOGGER.info("Generating Laser Pipe Blocks...");
        for (int i = 0; i < LaserPipeType.values().length; ++i) {
            GTBlocks.registerLaserPipeBlock(i);
        }
        GTCEu.LOGGER.info("Generating Laser Pipe Blocks... Complete!");
    }

    private static void registerLaserPipeBlock(int slot) {
        BlockEntry entry;
        LaserPipeType type = LaserPipeType.values()[slot];
        GTBlocks.LASER_PIPES[slot] = entry = ((BlockBuilder)GTRegistries.REGISTRATE.block("%s_laser_pipe".formatted(type.method_15434()), p -> new LaserPipeBlock((class_4970.class_2251)p, type)).initialProperties(() -> class_2246.field_10085).properties(p -> p.method_9624().method_22488().method_42327()).blockstate(NonNullBiConsumer.noop()).defaultLoot().tag(new class_6862[]{GTToolType.WIRE_CUTTER.harvestTags.get(0)}).addLayer(() -> class_1921::method_23579).color(() -> LaserPipeBlock::tintedColor).item(LaserPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> LaserPipeBlockItem::tintColor).build()).register();
    }

    private static BlockEntry<class_2248> createPipeCasingBlock(String name, class_2960 texture) {
        return GTBlocks.createPipeCasingBlock(name, texture, (NonNullSupplier<? extends class_2248>)((NonNullSupplier)() -> class_2246.field_10085));
    }

    private static BlockEntry<class_2248> createPipeCasingBlock(String name, class_2960 texture, NonNullSupplier<? extends class_2248> properties) {
        return ((BlockBuilder)GTRegistries.REGISTRATE.block("%s_pipe_casing".formatted(name.toLowerCase(Locale.ROOT)), p -> new RendererBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_all"), Map.of("all", texture)) : null))).lang("%s Pipe Casing".formatted(name)).initialProperties(properties).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    public static BlockEntry<class_2248> createCasingBlock(String name, class_2960 texture) {
        return GTBlocks.createCasingBlock(name, RendererBlock::new, texture, (NonNullSupplier<? extends class_2248>)((NonNullSupplier)() -> class_2246.field_10085), () -> class_1921::method_23579);
    }

    private static BlockEntry<class_2248> createGlassCasingBlock(String name, class_2960 texture, Supplier<Supplier<class_1921>> type) {
        return GTBlocks.createCasingBlock(name, RendererGlassBlock::new, texture, (NonNullSupplier<? extends class_2248>)((NonNullSupplier)() -> class_2246.field_10033), type);
    }

    public static BlockEntry<class_2248> createCasingBlock(String name, BiFunction<class_4970.class_2251, IRenderer, ? extends RendererBlock> blockSupplier, class_2960 texture, NonNullSupplier<? extends class_2248> properties, Supplier<Supplier<class_1921>> type) {
        return ((BlockBuilder)GTRegistries.REGISTRATE.block(name, p -> (class_2248)blockSupplier.apply((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_all"), Map.of("all", texture)) : null))).initialProperties(properties).addLayer(type).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<class_2248> createMachineCasingBlock(int tier) {
        String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
        BlockEntry entry = ((BlockBuilder)GTRegistries.REGISTRATE.block("%s_machine_casing".formatted(tierName), p -> new RendererBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(GTCEu.id("block/cube_bottom_top_tintindex"), Map.of("bottom", GTCEu.id("block/casings/voltage/%s/bottom".formatted(tierName)), "top", GTCEu.id("block/casings/voltage/%s/top".formatted(tierName)), "side", GTCEu.id("block/casings/voltage/%s/side".formatted(tierName)))) : null))).lang("%s Machine Casing".formatted(GTValues.VN[tier])).initialProperties(() -> class_2246.field_10085).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        if (!GTCEu.isHighTier() && tier > 9) {
            GTRegistries.REGISTRATE.setCreativeTab((RegistryEntry<?>)entry, null);
        }
        return entry;
    }

    private static BlockEntry<class_2248> createHermeticCasing(int tier) {
        String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
        BlockEntry entry = ((BlockBuilder)GTRegistries.REGISTRATE.block("%s_hermetic_casing".formatted(tierName), p -> new RendererBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(GTCEu.id("block/hermetic_casing"), Map.of("bot_bottom", GTCEu.id("block/casings/voltage/%s/bottom".formatted(tierName)), "bot_top", GTCEu.id("block/casings/voltage/%s/top".formatted(tierName)), "bot_side", GTCEu.id("block/casings/voltage/%s/side".formatted(tierName)), "top_side", GTCEu.id("block/casings/hermetic_casing/hermetic_casing_overlay"))) : null))).lang("Hermetic Casing %s".formatted(GTValues.LVT[tier])).initialProperties(() -> class_2246.field_10085).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        if (!GTCEu.isHighTier() && tier > 9) {
            GTRegistries.REGISTRATE.setCreativeTab((RegistryEntry<?>)entry, null);
        }
        return entry;
    }

    private static BlockEntry<class_2248> createSteamCasing(String name, String material) {
        return ((BlockBuilder)GTRegistries.REGISTRATE.block(name, p -> new RendererBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_bottom_top"), Map.of("bottom", GTCEu.id("block/casings/steam/%s/bottom".formatted(material)), "top", GTCEu.id("block/casings/steam/%s/top".formatted(material)), "side", GTCEu.id("block/casings/steam/%s/side".formatted(material)))) : null))).initialProperties(() -> class_2246.field_10085).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<CoilBlock> createCoilBlock(ICoilType coilType) {
        BlockEntry coilBlock = ((BlockBuilder)((ItemBuilder)GTRegistries.REGISTRATE.block("%s_coil_block".formatted(coilType.getName()), p -> new CoilBlock((class_4970.class_2251)p, coilType)).initialProperties(() -> class_2246.field_10085).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).onRegister(GTBlocks.compassNodeExist(GTCompassSections.BLOCKS, "coil_block", new CompassNode[0]))).build()).register();
        ALL_COILS.put(coilType, (Supplier<CoilBlock>)coilBlock);
        return coilBlock;
    }

    private static BlockEntry<BatteryBlock> createBatteryBlock(IBatteryData batteryData) {
        BlockEntry batteryBlock = ((BlockBuilder)((ItemBuilder)GTRegistries.REGISTRATE.block("%s_battery".formatted(batteryData.getBatteryName()), p -> new BatteryBlock((class_4970.class_2251)p, batteryData, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_bottom_top"), Map.of("bottom", GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/top"), "top", GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/top"), "side", GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/side"))) : null))).initialProperties(() -> class_2246.field_10085).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).onRegister(GTBlocks.compassNodeExist(GTCompassSections.BLOCKS, "pss_battery", new CompassNode[0]))).build()).register();
        PSS_BATTERIES.put(batteryData, (Supplier<BatteryBlock>)batteryBlock);
        return batteryBlock;
    }

    private static BlockEntry<FusionCasingBlock> createFusionCasing(IFusionCasingType casingType) {
        BlockEntry casingBlock = ((BlockBuilder)GTRegistries.REGISTRATE.block(casingType.method_15434(), p -> new FusionCasingBlock((class_4970.class_2251)p, casingType)).initialProperties(() -> class_2246.field_10085).properties(properties -> properties.method_9629(5.0f, 10.0f).method_9626(class_2498.field_11533)).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), CustomTags.TOOL_TIERS[casingType.getHarvestLevel()]}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        ALL_FUSION_CASINGS.put(casingType, (Supplier<FusionCasingBlock>)casingBlock);
        return casingBlock;
    }

    private static BlockEntry<class_2248> createCleanroomFilter(IFilterType filterType) {
        BlockEntry filterBlock = ((BlockBuilder)GTRegistries.REGISTRATE.block(filterType.method_15434(), p -> new RendererBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_all"), Map.of("all", GTCEu.id("block/casings/cleanroom/" + filterType))) : null))).initialProperties(() -> class_2246.field_10085).properties(properties -> properties.method_9629(2.0f, 8.0f).method_9626(class_2498.field_11533).method_26235((blockState, blockGetter, blockPos, entityType) -> false)).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), CustomTags.TOOL_TIERS[1]}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        ALL_FILTERS.put(filterType, (Supplier<class_2248>)filterBlock);
        return filterBlock;
    }

    private static BlockEntry<ActiveBlock> createActiveCasing(String name, String baseModelPath) {
        String finalName = "%s".formatted(name);
        return ((BlockBuilder)GTRegistries.REGISTRATE.block(finalName, p -> new ActiveBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new CTMModelRenderer(GTCEu.id(baseModelPath)) : null), (IRenderer)(Platform.isClient() ? new CTMModelRenderer(GTCEu.id("%s_active".formatted(baseModelPath))) : null))).initialProperties(() -> class_2246.field_10085).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<ActiveBlock> createFireboxCasing(BoilerFireboxType type) {
        BlockEntry block = ((BlockBuilder)GTRegistries.REGISTRATE.block("%s_casing".formatted(type.name()), p -> new ActiveBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_bottom_top"), Map.of("bottom", type.bottom(), "top", type.top(), "side", type.side())) : null), (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(GTCEu.id("block/fire_box_active"), Map.of("bottom", type.bottom(), "top", type.top(), "side", type.side())) : null))).initialProperties(() -> class_2246.field_10085).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33715}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        ALL_FIREBOXES.put(type, (BlockEntry<ActiveBlock>)block);
        return block;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_322 leavesBlockColor() {
        return (state, reader, pos, tintIndex) -> {
            if (reader != null && pos != null) {
                return class_1163.method_4966((class_1920)reader, (class_2338)pos);
            }
            return class_1926.method_8341();
        };
    }

    @Environment(value=EnvType.CLIENT)
    public static class_326 leavesItemColor() {
        return (stack, tintIndex) -> class_1926.method_8341();
    }

    public static <P, T extends class_2248, S2 extends BlockBuilder<T, P>> NonNullFunction<S2, S2> unificationBlock(@Nonnull TagPrefix tagPrefix, @Nonnull Material mat) {
        return builder -> {
            builder.onRegister(block -> {
                UnificationEntry entry = new UnificationEntry(tagPrefix, mat);
                GTItems.toUnify.put(entry, (class_1935)block);
                ChemicalHelper.registerUnificationItems(entry, new class_1935[]{block});
            });
            return builder;
        };
    }

    public static <T extends class_1935> NonNullConsumer<T> compassNode(CompassSection section, CompassNode ... preNodes) {
        return item -> CompassNode.getOrCreate(section, () -> ((class_1935)item).method_8389()).addPreNode(preNodes);
    }

    public static <T extends class_1935> NonNullConsumer<T> compassNodeExist(CompassSection section, String node, CompassNode ... preNodes) {
        return item -> CompassNode.getOrCreate(section, node).addPreNode(preNodes).addItem(() -> ((class_1935)item).method_8389());
    }

    public static void init() {
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_BLOCK);
        GTBlocks.generateMaterialBlocks();
        GTBlocks.generateFrameBlocks();
        GTBlocks.generateRawOreBlocks();
        GTBlocks.generateOreBlocks();
        GTBlocks.generateOreIndicators();
        MATERIAL_BLOCKS = MATERIAL_BLOCKS_BUILDER.build();
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_PIPE);
        GTBlocks.generateCableBlocks();
        GTBlocks.generateFluidPipeBlocks();
        GTBlocks.generateItemPipeBlocks();
        GTBlocks.generateLaserPipeBlocks();
        MATERIAL_BLOCKS_BUILDER = null;
        SURFACE_ROCK_BLOCKS_BUILDER = null;
        CABLE_BLOCKS_BUILDER = null;
        FLUID_PIPE_BLOCKS_BUILDER = null;
        ITEM_PIPE_BLOCKS_BUILDER = null;
        GCyMBlocks.init();
    }

    public static boolean doMetalPipe(Material material) {
        return GTValues.FOOLS.get() != false && material.hasProperty(PropertyKey.INGOT) && !material.hasProperty(PropertyKey.POLYMER) && !material.hasProperty(PropertyKey.WOOD);
    }

    static {
        LASER_PIPES = new BlockEntry[LaserPipeType.values().length];
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_PIPE);
        LD_ITEM_PIPE = GTRegistries.REGISTRATE.block("long_distance_item_pipeline", properties -> new LongDistancePipeBlock((class_4970.class_2251)properties, LDItemPipeType.INSTANCE)).initialProperties(() -> class_2246.field_10085).blockstate(GTModels::longDistanceItemPipeModel).simpleItem().register();
        LD_FLUID_PIPE = GTRegistries.REGISTRATE.block("long_distance_fluid_pipeline", properties -> new LongDistancePipeBlock((class_4970.class_2251)properties, LDFluidPipeType.INSTANCE)).initialProperties(() -> class_2246.field_10085).blockstate(GTModels::longDistanceFluidPipeModel).simpleItem().register();
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.DECORATION);
        CASING_COKE_BRICKS = GTBlocks.createCasingBlock("coke_oven_bricks", GTCEu.id("block/casings/solid/machine_coke_bricks"));
        CASING_PRIMITIVE_BRICKS = GTBlocks.createCasingBlock("firebricks", GTCEu.id("block/casings/solid/machine_primitive_bricks"));
        CASING_BRONZE_BRICKS = GTBlocks.createCasingBlock("steam_machine_casing", GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"));
        CASING_INVAR_HEATPROOF = GTBlocks.createCasingBlock("heatproof_machine_casing", GTCEu.id("block/casings/solid/machine_casing_heatproof"));
        CASING_ALUMINIUM_FROSTPROOF = GTBlocks.createCasingBlock("frostproof_machine_casing", GTCEu.id("block/casings/solid/machine_casing_frost_proof"));
        CASING_STEEL_SOLID = GTBlocks.createCasingBlock("solid_machine_casing", GTCEu.id("block/casings/solid/machine_casing_solid_steel"));
        CASING_STAINLESS_CLEAN = GTBlocks.createCasingBlock("clean_machine_casing", GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"));
        CASING_TITANIUM_STABLE = GTBlocks.createCasingBlock("stable_machine_casing", GTCEu.id("block/casings/solid/machine_casing_stable_titanium"));
        CASING_TUNGSTENSTEEL_ROBUST = GTBlocks.createCasingBlock("robust_machine_casing", GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"));
        CASING_PTFE_INERT = GTBlocks.createCasingBlock("inert_machine_casing", GTCEu.id("block/casings/solid/machine_casing_inert_ptfe"));
        CASING_HSSE_STURDY = GTBlocks.createCasingBlock("sturdy_machine_casing", GTCEu.id("block/casings/solid/machine_casing_sturdy_hsse"));
        CASING_PALLADIUM_SUBSTATION = GTBlocks.createCasingBlock("palladium_substation", GTCEu.id("block/casings/solid/machine_casing_palladium_substation"));
        CASING_TEMPERED_GLASS = GTBlocks.createGlassCasingBlock("tempered_glass", GTCEu.id("block/casings/transparent/tempered_glass"), () -> class_1921::method_23583);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)GTMaterials.Bronze, CASING_BRONZE_BRICKS);
        builder.put((Object)GTMaterials.Invar, CASING_INVAR_HEATPROOF);
        builder.put((Object)GTMaterials.Aluminium, CASING_ALUMINIUM_FROSTPROOF);
        builder.put((Object)GTMaterials.Steel, CASING_STEEL_SOLID);
        builder.put((Object)GTMaterials.StainlessSteel, CASING_STAINLESS_CLEAN);
        builder.put((Object)GTMaterials.Titanium, CASING_TITANIUM_STABLE);
        builder.put((Object)GTMaterials.TungstenSteel, CASING_TUNGSTENSTEEL_ROBUST);
        builder.put((Object)GTMaterials.Polytetrafluoroethylene, CASING_PTFE_INERT);
        builder.put((Object)GTMaterials.HSSE, CASING_HSSE_STURDY);
        builder.put((Object)GTMaterials.HSLASteel, GCyMBlocks.CASING_NONCONDUCTING);
        builder.put((Object)GTMaterials.IncoloyMA956, GCyMBlocks.CASING_VIBRATION_SAFE);
        builder.put((Object)GTMaterials.WatertightSteel, GCyMBlocks.CASING_WATERTIGHT);
        builder.put((Object)GTMaterials.Zeron100, GCyMBlocks.CASING_SECURE_MACERATION);
        builder.put((Object)GTMaterials.TungstenCarbide, GCyMBlocks.CASING_HIGH_TEMPERATURE_SMELTING);
        builder.put((Object)GTMaterials.TitaniumTungstenCarbide, GCyMBlocks.CASING_LASER_SAFE_ENGRAVING);
        builder.put((Object)GTMaterials.Stellite100, GCyMBlocks.CASING_LARGE_SCALE_ASSEMBLING);
        builder.put((Object)GTMaterials.HastelloyC276, GCyMBlocks.CASING_SHOCK_PROOF);
        MaterialCasingCollectionEvent event = new MaterialCasingCollectionEvent((ImmutableMap.Builder<Material, BlockEntry<class_2248>>)builder);
        AddonFinder.getAddons().forEach(addon -> addon.collectMaterialCasings(event));
        MATERIALS_TO_CASINGS = builder.build();
        CASING_GRATE = GTBlocks.createCasingBlock("assembly_line_grating", GTCEu.id("block/casings/pipe/machine_casing_grate"));
        CASING_ASSEMBLY_CONTROL = GTBlocks.createCasingBlock("assembly_line_casing", GTCEu.id("block/casings/mechanic/machine_casing_assembly_control"));
        CASING_LAMINATED_GLASS = GTBlocks.createGlassCasingBlock("laminated_glass", GTCEu.id("block/casings/transparent/laminated_glass"), () -> class_1921::method_23579);
        CASING_ASSEMBLY_LINE = GTBlocks.createActiveCasing("assembly_line_unit", "block/variant/assembly_line");
        CASING_BRONZE_GEARBOX = GTBlocks.createCasingBlock("bronze_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_bronze"));
        CASING_STEEL_GEARBOX = GTBlocks.createCasingBlock("steel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_steel"));
        CASING_STAINLESS_STEEL_GEARBOX = GTBlocks.createCasingBlock("stainless_steel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_stainless_steel"));
        CASING_TITANIUM_GEARBOX = GTBlocks.createCasingBlock("titanium_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_titanium"));
        CASING_TUNGSTENSTEEL_GEARBOX = GTBlocks.createCasingBlock("tungstensteel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_tungstensteel"));
        CASING_STEEL_TURBINE = GTBlocks.createCasingBlock("steel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_steel"));
        CASING_TITANIUM_TURBINE = GTBlocks.createCasingBlock("titanium_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_titanium"));
        CASING_STAINLESS_TURBINE = GTBlocks.createCasingBlock("stainless_steel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_stainless_steel"));
        CASING_TUNGSTENSTEEL_TURBINE = GTBlocks.createCasingBlock("tungstensteel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_tungstensteel"));
        CASING_BRONZE_PIPE = GTBlocks.createCasingBlock("bronze_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_bronze"));
        CASING_STEEL_PIPE = GTBlocks.createCasingBlock("steel_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_steel"));
        CASING_TITANIUM_PIPE = GTBlocks.createCasingBlock("titanium_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_titanium"));
        CASING_TUNGSTENSTEEL_PIPE = GTBlocks.createCasingBlock("tungstensteel_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_tungstensteel"));
        CASING_POLYTETRAFLUOROETHYLENE_PIPE = GTBlocks.createPipeCasingBlock("ptfe", GTCEu.id("block/casings/pipe/machine_casing_pipe_polytetrafluoroethylene"));
        MINER_PIPE = GTRegistries.REGISTRATE.block("miner_pipe", MinerPipeBlock::new).initialProperties(() -> class_2246.field_9987).properties(class_4970.class_2251::method_22488).addLayer(() -> class_1921::method_23579).blockstate((ctx, prov) -> GTModels.createModelBlockState((DataGenContext<class_2248, ? extends class_2248>)ctx, prov, GTCEu.id("block/miner_pipe"))).tag(new class_6862[]{class_3481.field_17753, class_3481.field_17754, class_3481.field_25590, class_3481.field_33757, class_3481.field_33863}).register();
        CASING_PUMP_DECK = ((BlockBuilder)GTRegistries.REGISTRATE.block("pump_deck", p -> new RendererBlock((class_4970.class_2251)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_bottom_top"), Map.of("bottom", GTCEu.id("block/casings/pump_deck/bottom"), "top", GTCEu.id("block/casings/pump_deck/top"), "side", GTCEu.id("block/casings/pump_deck/side"))) : null))).initialProperties(() -> class_2246.field_10085).properties(p -> p.method_9626(class_2498.field_11547).method_31710(class_3620.field_15996)).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).tag(new class_6862[]{GTToolType.WRENCH.harvestTags.get(0), class_3481.field_33713}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        MACHINE_CASING_ULV = GTBlocks.createMachineCasingBlock(0);
        MACHINE_CASING_LV = GTBlocks.createMachineCasingBlock(1);
        MACHINE_CASING_MV = GTBlocks.createMachineCasingBlock(2);
        MACHINE_CASING_HV = GTBlocks.createMachineCasingBlock(3);
        MACHINE_CASING_EV = GTBlocks.createMachineCasingBlock(4);
        MACHINE_CASING_IV = GTBlocks.createMachineCasingBlock(5);
        MACHINE_CASING_LuV = GTBlocks.createMachineCasingBlock(6);
        MACHINE_CASING_ZPM = GTBlocks.createMachineCasingBlock(7);
        MACHINE_CASING_UV = GTBlocks.createMachineCasingBlock(8);
        MACHINE_CASING_UHV = GTBlocks.createMachineCasingBlock(9);
        MACHINE_CASING_UEV = GTBlocks.createMachineCasingBlock(10);
        MACHINE_CASING_UIV = GTBlocks.createMachineCasingBlock(11);
        MACHINE_CASING_UXV = GTBlocks.createMachineCasingBlock(12);
        MACHINE_CASING_OpV = GTBlocks.createMachineCasingBlock(13);
        MACHINE_CASING_MAX = GTBlocks.createMachineCasingBlock(14);
        HERMETIC_CASING_LV = GTBlocks.createHermeticCasing(1);
        HERMETIC_CASING_MV = GTBlocks.createHermeticCasing(2);
        HERMETIC_CASING_HV = GTBlocks.createHermeticCasing(3);
        HERMETIC_CASING_EV = GTBlocks.createHermeticCasing(4);
        HERMETIC_CASING_IV = GTBlocks.createHermeticCasing(5);
        HERMETIC_CASING_LuV = GTBlocks.createHermeticCasing(6);
        HERMETIC_CASING_ZPM = GTBlocks.createHermeticCasing(7);
        HERMETIC_CASING_UV = GTBlocks.createHermeticCasing(8);
        HERMETIC_CASING_UHV = GTBlocks.createHermeticCasing(9);
        BRONZE_HULL = GTBlocks.createSteamCasing("bronze_machine_casing", "bronze");
        BRONZE_BRICKS_HULL = GTBlocks.createSteamCasing("bronze_brick_casing", "bricked_bronze");
        STEEL_HULL = GTBlocks.createSteamCasing("steel_machine_casing", "steel");
        STEEL_BRICKS_HULL = GTBlocks.createSteamCasing("steel_brick_casing", "bricked_steel");
        ALL_COILS = new HashMap<ICoilType, Supplier<CoilBlock>>();
        COIL_CUPRONICKEL = GTBlocks.createCoilBlock(CoilBlock.CoilType.CUPRONICKEL);
        COIL_KANTHAL = GTBlocks.createCoilBlock(CoilBlock.CoilType.KANTHAL);
        COIL_NICHROME = GTBlocks.createCoilBlock(CoilBlock.CoilType.NICHROME);
        COIL_TUNGSTENSTEEL = GTBlocks.createCoilBlock(CoilBlock.CoilType.TUNGSTENSTEEL);
        COIL_HSSG = GTBlocks.createCoilBlock(CoilBlock.CoilType.HSSG);
        COIL_NAQUADAH = GTBlocks.createCoilBlock(CoilBlock.CoilType.NAQUADAH);
        COIL_TRINIUM = GTBlocks.createCoilBlock(CoilBlock.CoilType.TRINIUM);
        COIL_TRITANIUM = GTBlocks.createCoilBlock(CoilBlock.CoilType.TRITANIUM);
        PSS_BATTERIES = new HashMap<IBatteryData, Supplier<BatteryBlock>>();
        BATTERY_EMPTY_TIER_I = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_I);
        BATTERY_LAPOTRONIC_EV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EV_LAPOTRONIC);
        BATTERY_LAPOTRONIC_IV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.IV_LAPOTRONIC);
        BATTERY_EMPTY_TIER_II = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_II);
        BATTERY_LAPOTRONIC_LuV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.LuV_LAPOTRONIC);
        BATTERY_LAPOTRONIC_ZPM = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.ZPM_LAPOTRONIC);
        BATTERY_EMPTY_TIER_III = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_III);
        BATTERY_LAPOTRONIC_UV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.UV_LAPOTRONIC);
        BATTERY_ULTIMATE_UHV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.UHV_ULTIMATE);
        CASING_ENGINE_INTAKE = GTBlocks.createActiveCasing("engine_intake_casing", "block/variant/engine_intake");
        CASING_EXTREME_ENGINE_INTAKE = GTBlocks.createActiveCasing("extreme_engine_intake_casing", "block/variant/extreme_engine_intake");
        ALL_FUSION_CASINGS = new HashMap<IFusionCasingType, Supplier<FusionCasingBlock>>();
        SUPERCONDUCTING_COIL = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.SUPERCONDUCTING_COIL);
        FUSION_COIL = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_COIL);
        FUSION_CASING = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING);
        FUSION_CASING_MK2 = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING_MK2);
        FUSION_CASING_MK3 = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING_MK3);
        FUSION_GLASS = GTBlocks.createGlassCasingBlock("fusion_glass", GTCEu.id("block/casings/transparent/fusion_glass"), () -> class_1921::method_23579);
        ALL_FILTERS = new HashMap<IFilterType, Supplier<class_2248>>();
        PLASTCRETE = GTBlocks.createCasingBlock("plascrete", GTCEu.id("block/casings/cleanroom/plascrete"));
        FILTER_CASING = GTBlocks.createCleanroomFilter(CleanroomFilterType.FILTER_CASING);
        FILTER_CASING_STERILE = GTBlocks.createCleanroomFilter(CleanroomFilterType.FILTER_CASING_STERILE);
        CLEANROOM_GLASS = GTBlocks.createGlassCasingBlock("cleanroom_glass", GTCEu.id("block/casings/transparent/cleanroom_glass"), () -> class_1921::method_23579);
        ALL_FIREBOXES = new HashMap<BoilerFireboxType, BlockEntry<ActiveBlock>>();
        FIREBOX_BRONZE = GTBlocks.createFireboxCasing(BoilerFireboxType.BRONZE_FIREBOX);
        FIREBOX_STEEL = GTBlocks.createFireboxCasing(BoilerFireboxType.STEEL_FIREBOX);
        FIREBOX_TITANIUM = GTBlocks.createFireboxCasing(BoilerFireboxType.TITANIUM_FIREBOX);
        FIREBOX_TUNGSTENSTEEL = GTBlocks.createFireboxCasing(BoilerFireboxType.TUNGSTENSTEEL_FIREBOX);
        HIGH_POWER_CASING = GTBlocks.createCasingBlock("high_power_casing", GTCEu.id("block/casings/hpca/high_power_casing"));
        RUBBER_SAPLING = ((BlockBuilder)((ItemBuilder)GTRegistries.REGISTRATE.block("rubber_sapling", properties -> new class_2473(new class_2647(){

            protected class_5321<class_2975<?, ?>> method_11430(@Nonnull class_5819 random, boolean largeHive) {
                return GTConfiguredFeatures.RUBBER;
            }
        }, properties)).initialProperties(() -> class_2246.field_10394).lang("Rubber Sapling").blockstate(GTModels::createCrossBlockState).addLayer(() -> class_1921::method_23579).tag(new class_6862[]{class_3481.field_15462}).item().model(GTModels::rubberTreeSaplingModel).tag(new class_6862[]{class_3489.field_15528}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        RUBBER_LOG = ((BlockBuilder)((ItemBuilder)GTRegistries.REGISTRATE.block("rubber_log", RubberLogBlock::new).properties(p -> p.method_9632(2.0f).method_9626(class_2498.field_11547)).loot((table, block) -> table.method_45988((class_2248)block, class_52.method_324().method_336(((class_55.class_56)table.method_45978((class_1935)block, (class_192)class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)))).method_351((class_79.class_80)class_77.method_411((class_1935)block))).method_336(((class_55.class_56)table.method_45978((class_1935)block, (class_192)class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)))).method_351(((class_85.class_86)class_77.method_411((class_1935)((class_1935)GTItems.STICKY_RESIN.get())).method_421((class_5341.class_210)class_212.method_900((class_2248)block).method_22584(class_4559.class_4560.method_22523().method_22527((class_2769)RubberLogBlock.NATURAL, true)))).method_421(class_219.method_932((float)0.85f)))))).lang("Rubber Log").tag(new class_6862[]{class_3481.field_15475}).blockstate((ctx, provider) -> provider.logBlock((class_2465)ctx.get())).item().tag(new class_6862[]{class_3489.field_15539}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        RUBBER_LEAVES_DROPPING_CHANCE = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        RUBBER_LEAVES = ((BlockBuilder)((ItemBuilder)GTRegistries.REGISTRATE.block("rubber_leaves", class_2397::new).initialProperties(() -> class_2246.field_10503).lang("Rubber Leaves").blockstate((ctx, prov) -> GTModels.createModelBlockState((DataGenContext<class_2248, ? extends class_2248>)ctx, prov, GTCEu.id("block/rubber_leaves"))).loot((table, block) -> table.method_45988((class_2248)block, table.method_45986((class_2248)block, (class_2248)RUBBER_SAPLING.get(), RUBBER_LEAVES_DROPPING_CHANCE))).tag(new class_6862[]{class_3481.field_15503}).color(() -> GTBlocks::leavesBlockColor).item().color(() -> GTBlocks::leavesItemColor).tag(new class_6862[]{class_3489.field_15558}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        RUBBER_PLANK = ((BlockBuilder)((ItemBuilder)GTRegistries.REGISTRATE.block("rubber_planks", class_2248::new).initialProperties(() -> class_2246.field_10161).lang("Rubber Planks").properties(p -> p.method_31710(class_3620.field_16027)).tag(new class_6862[]{class_3481.field_15471}).item().tag(new class_6862[]{class_3489.field_15537}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        TREATED_WOOD_PLANK = ((BlockBuilder)GTRegistries.REGISTRATE.block("treated_wood_planks", class_2248::new).initialProperties(() -> class_2246.field_10161).lang("Treated Wood Planks").properties(p -> p.method_31710(class_3620.field_16027)).tag(new class_6862[]{class_3481.field_15471}).item().tag(new class_6862[]{TagUtil.createItemTag("treated_wood")}).build()).register();
    }
}

