/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.LongInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.FluidDetectorCover;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class AdvancedFluidDetectorCover
extends FluidDetectorCover
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedFluidDetectorCover.class, DetectorCover.MANAGED_FIELD_HOLDER);
    private static final int DEFAULT_MIN = 64;
    private static final int DEFAULT_MAX = 512;
    @Persisted
    private long minValue = 64L;
    @Persisted
    private long maxValue = 512L;
    @Persisted
    @DescSynced
    protected final FilterHandler<FluidStack, FluidFilter> filterHandler = FilterHandlers.fluid(this);

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public AdvancedFluidDetectorCover(CoverDefinition definition, ICoverable coverHolder, class_2350 attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public List<class_1799> getAdditionalDrops() {
        List<class_1799> list = super.getAdditionalDrops();
        if (!this.filterHandler.getFilterItem().method_7960()) {
            list.add(this.filterHandler.getFilterItem());
        }
        return list;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        FluidFilter filter = this.filterHandler.getFilter();
        IFluidTransfer fluidHandler = this.getFluidTransfer();
        if (fluidHandler == null) {
            return;
        }
        long storedFluid = 0L;
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack content = fluidHandler.getFluidInTank(tank);
            if (content.isEmpty() || !filter.test(content)) continue;
            storedFluid += content.getAmount();
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneBetweenValues(storedFluid, this.maxValue, this.minValue, this.isInverted()));
    }

    public void setMinValue(long minValue) {
        this.minValue = GTMath.clamp(minValue, 0L, this.maxValue - 1L);
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = Math.max(maxValue, 0L);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 170);
        group.addWidget((Widget)new LabelWidget(10, 5, "cover.advanced_fluid_detector.label"));
        group.addWidget((Widget)new TextBoxWidget(10, 55, 65, List.of(LocalizationUtils.format((String)"cover.advanced_fluid_detector.min", (Object[])new Object[0]))));
        group.addWidget((Widget)new TextBoxWidget(10, 80, 65, List.of(LocalizationUtils.format((String)"cover.advanced_fluid_detector.max", (Object[])new Object[0]))));
        group.addWidget((Widget)new LongInputWidget(80, 50, 86, 20, this::getMinValue, this::setMinValue));
        group.addWidget((Widget)new LongInputWidget(80, 75, 86, 20, this::getMaxValue, this::setMaxValue));
        group.addWidget((Widget)new ToggleButtonWidget(9, 20, 20, 20, (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON, this::isInverted, this::setInverted){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(List.copyOf(LangHandler.getMultiLang("cover.advanced_fluid_detector.invert." + (this.isPressed ? "enabled" : "disabled"))));
            }
        });
        group.addWidget(this.filterHandler.createFilterSlotUI(148, 100));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 100, 156, 60));
        return group;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public FilterHandler<FluidStack, FluidFilter> getFilterHandler() {
        return this.filterHandler;
    }
}

