/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.blockentity.fabric.ItemPipeBlockEntityImpl;
import com.gregtechceu.gtceu.common.pipelike.item.ItemNetHandler;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlockEntity
extends PipeBlockEntity<ItemPipeType, ItemPipeData> {
    protected WeakReference<ItemPipeNet> currentItemPipeNet = new WeakReference<Object>(null);
    protected final EnumMap<class_2350, ItemNetHandler> handlers = new EnumMap(class_2350.class);
    private final Map<FacingPos, Integer> transferred = new HashMap<FacingPos, Integer>();
    protected ItemNetHandler defaultHandler;

    public ItemPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemPipeBlockEntity create(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        void var2_2;
        void var1_1;
        return ItemPipeBlockEntityImpl.create(type, (class_2338)var1_1, (class_2680)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onBlockEntityRegister(class_2591<ItemPipeBlockEntity> cableBlockEntityBlockEntityType) {
        ItemPipeBlockEntityImpl.onBlockEntityRegister(cableBlockEntityBlockEntityType);
    }

    public void initHandlers() {
        ItemPipeNet net = this.getItemPipeNet();
        if (net == null) {
            return;
        }
        for (class_2350 facing : class_2350.values()) {
            this.handlers.put(facing, new ItemNetHandler(net, this, facing));
        }
        this.defaultHandler = new ItemNetHandler(net, this, null);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            ItemPipeNet current = this.getItemPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (ItemNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    @Override
    public boolean canAttachTo(class_2350 side) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.field_11863.method_8321(this.method_11016().method_10093(side)) instanceof ItemPipeBlockEntity) {
            return false;
        }
        return ItemTransferHelper.getItemTransfer((class_1937)this.field_11863, (class_2338)this.method_11016().method_10093(side), (class_2350)side.method_10153()) != null;
    }

    @Nullable
    public ItemPipeNet getItemPipeNet() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_19372 = this.method_11010().method_26204();
            if (class_19372 instanceof ItemPipeBlock) {
                ItemPipeBlock itemPipeBlock = (ItemPipeBlock)class_19372;
                ItemPipeNet currentItemPipeNet = (ItemPipeNet)((Object)this.currentItemPipeNet.get());
                if (currentItemPipeNet != null && currentItemPipeNet.isValid() && currentItemPipeNet.containsNode(this.method_11016())) {
                    return currentItemPipeNet;
                }
                currentItemPipeNet = (ItemPipeNet)itemPipeBlock.getWorldPipeNet(serverLevel).getNetFromPos(this.method_11016());
                if (currentItemPipeNet != null) {
                    this.currentItemPipeNet = new WeakReference<ItemPipeNet>(currentItemPipeNet);
                }
            }
        }
        return (ItemPipeNet)((Object)this.currentItemPipeNet.get());
    }

    public void resetTransferred() {
        this.transferred.clear();
    }

    public IItemTransfer getHandler(@Nullable class_2350 side, boolean useCoverCapability) {
        ItemNetHandler handler = this.getHandlers().getOrDefault(side, this.getDefaultHandler());
        if (!useCoverCapability || side == null) {
            return handler;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemTransferCap(side, handler) : handler;
    }

    public EnumMap<class_2350, ItemNetHandler> getHandlers() {
        return this.handlers;
    }

    public Map<FacingPos, Integer> getTransferred() {
        return this.transferred;
    }

    public ItemNetHandler getDefaultHandler() {
        return this.defaultHandler;
    }
}

