/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.client.renderer.block.TextureOverrideRenderer;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class CoilBlock
extends ActiveBlock {
    public ICoilType coilType;

    public CoilBlock(class_4970.class_2251 properties, ICoilType coilType) {
        super(properties, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new class_2960("block/cube_all"), Map.of("all", coilType.getTexture())) : null), (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(GTCEu.id("block/cube_2_layer_all"), Map.of("bot_all", coilType.getTexture(), "top_all", new class_2960(coilType.getTexture() + "_bloom"))) : null));
        this.coilType = coilType;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, level, tooltip, flag);
        if (GTUtil.isShiftDown()) {
            int coilTier = this.coilType.getTier();
            tooltip.add((class_2561)class_2561.method_43469((String)"block.gtceu.wire_coil.tooltip_heat", (Object[])new Object[]{this.coilType.getCoilTemperature()}));
            tooltip.add((class_2561)class_2561.method_43471((String)"block.gtceu.wire_coil.tooltip_smelter"));
            tooltip.add((class_2561)class_2561.method_43469((String)"block.gtceu.wire_coil.tooltip_parallel_smelter", (Object[])new Object[]{this.coilType.getLevel() * 32}));
            tooltip.add((class_2561)class_2561.method_43469((String)"block.gtceu.wire_coil.tooltip_energy_smelter", (Object[])new Object[]{Math.max(1, 16 / this.coilType.getEnergyDiscount())}));
            tooltip.add((class_2561)class_2561.method_43471((String)"block.gtceu.wire_coil.tooltip_pyro"));
            tooltip.add((class_2561)class_2561.method_43469((String)"block.gtceu.wire_coil.tooltip_speed_pyro", (Object[])new Object[]{coilTier == 0 ? 75 : 50 * (coilTier + 1)}));
            tooltip.add((class_2561)class_2561.method_43471((String)"block.gtceu.wire_coil.tooltip_cracking"));
            tooltip.add((class_2561)class_2561.method_43469((String)"block.gtceu.wire_coil.tooltip_energy_cracking", (Object[])new Object[]{100 - 10 * coilTier}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"block.gtceu.wire_coil.tooltip_extended_info"));
        }
    }

    public static enum CoilType implements class_3542,
    ICoilType
    {
        CUPRONICKEL("cupronickel", 1800, 1, 1, GTMaterials.Cupronickel, GTCEu.id("block/casings/coils/machine_coil_cupronickel")),
        KANTHAL("kanthal", 2700, 2, 1, GTMaterials.Kanthal, GTCEu.id("block/casings/coils/machine_coil_kanthal")),
        NICHROME("nichrome", 3600, 2, 2, GTMaterials.Nichrome, GTCEu.id("block/casings/coils/machine_coil_nichrome")),
        TUNGSTENSTEEL("tungstensteel", 4500, 4, 2, GTMaterials.TungstenSteel, GTCEu.id("block/casings/coils/machine_coil_tungstensteel")),
        HSSG("hssg", 5400, 4, 4, GTMaterials.HSSG, GTCEu.id("block/casings/coils/machine_coil_hssg")),
        NAQUADAH("naquadah", 7200, 8, 4, GTMaterials.Naquadah, GTCEu.id("block/casings/coils/machine_coil_naquadah")),
        TRINIUM("trinium", 9001, 8, 8, GTMaterials.Trinium, GTCEu.id("block/casings/coils/machine_coil_trinium")),
        TRITANIUM("tritanium", 10800, 16, 8, GTMaterials.Tritanium, GTCEu.id("block/casings/coils/machine_coil_tritanium"));

        @NotNull
        private final String name;
        private final int coilTemperature;
        private final int level;
        private final int energyDiscount;
        @NotNull
        private final Material material;
        @NotNull
        private final class_2960 texture;

        private CoilType(String name, int coilTemperature, int level, int energyDiscount, Material material, class_2960 texture) {
            this.name = name;
            this.coilTemperature = coilTemperature;
            this.level = level;
            this.energyDiscount = energyDiscount;
            this.material = material;
            this.texture = texture;
        }

        @Override
        public int getTier() {
            return this.ordinal();
        }

        @Nonnull
        public String toString() {
            return this.getName();
        }

        @Nonnull
        public String method_15434() {
            return this.name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public int getCoilTemperature() {
            return this.coilTemperature;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public int getEnergyDiscount() {
            return this.energyDiscount;
        }

        @Override
        @NotNull
        public Material getMaterial() {
            return this.material;
        }

        @Override
        @NotNull
        public class_2960 getTexture() {
            return this.texture;
        }
    }
}

