/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.data.GTBlockEntities;
import com.gregtechceu.gtceu.common.pipelike.cable.CableData;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.pipelike.cable.LevelEnergyNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class CableBlock
extends MaterialPipeBlock<Insulation, CableData, LevelEnergyNet> {
    public CableBlock(class_4970.class_2251 properties, Insulation insulation, Material material) {
        super(properties, insulation, material);
    }

    @Override
    public int tinted(class_2680 blockState, @Nullable class_1920 blockAndTintGetter, @Nullable class_2338 blockPos, int index) {
        if (((Insulation)this.pipeType).isCable && index == 0) {
            return 0x404040;
        }
        return index == 0 || index == 1 ? this.material.getMaterialRGB() : -1;
    }

    @Override
    protected CableData createMaterialData() {
        return new CableData(this.material.getProperty(PropertyKey.WIRE), 0);
    }

    @Override
    public LevelEnergyNet getWorldPipeNet(class_3218 level) {
        return LevelEnergyNet.getOrCreate(level);
    }

    @Override
    public class_2591<? extends PipeBlockEntity<Insulation, CableData>> getBlockEntityType() {
        return (class_2591)GTBlockEntities.CABLE.get();
    }

    @Override
    protected PipeModel createPipeModel() {
        return ((Insulation)this.pipeType).createPipeModel(this.material);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, level, tooltip, flag);
        WireProperties wireProperties = ((Insulation)this.pipeType).modifyProperties((CableData)this.createRawData(this.method_9564(), stack)).properties();
        byte tier = GTUtil.getTierByVoltage(wireProperties.getVoltage());
        if (wireProperties.isSuperconductor()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"gtceu.cable.superconductor", (Object[])new Object[]{GTValues.VN[tier]}));
        }
        tooltip.add((class_2561)class_2561.method_43469((String)"gtceu.cable.voltage", (Object[])new Object[]{wireProperties.getVoltage(), GTValues.VNF[tier]}));
        tooltip.add((class_2561)class_2561.method_43469((String)"gtceu.cable.amperage", (Object[])new Object[]{wireProperties.getAmperage()}));
        tooltip.add((class_2561)class_2561.method_43469((String)"gtceu.cable.loss_per_block", (Object[])new Object[]{wireProperties.getLossPerBlock()}));
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.method_9530(state, level, pos, context);
    }
}

