/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.gregtechceu.gtceu.core.mixins.GuiGraphicsAccessor;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class BlockHighLightRenderer {
    private static float rColour;
    private static float gColour;
    private static float bColour;

    public static void renderBlockHighLight(class_4587 poseStack, class_4184 camera, class_3965 target, class_4597 multiBufferSource, float partialTick) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        class_746 player = mc.field_1724;
        if (level != null && player != null) {
            Object pipeType;
            class_1792 texture2;
            Set<GTToolType> set;
            class_1799 held = player.method_6047();
            class_2338 blockPos = target.method_17777();
            class_1792 class_17922 = held.method_7909();
            if (class_17922 instanceof IGTTool) {
                IGTTool toolItem = (IGTTool)class_17922;
                set = toolItem.getToolClasses(held);
            } else {
                set = null;
            }
            Set<GTToolType> toolType = set;
            class_2586 blockEntity = level.method_8321(blockPos);
            if (toolType != null && blockEntity instanceof IToolGridHighLight) {
                IToolGridHighLight gridHighLight = (IToolGridHighLight)blockEntity;
                class_243 pos = camera.method_19326();
                poseStack.method_22903();
                poseStack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
                if (gridHighLight.shouldRenderGrid((class_1657)player, held, toolType)) {
                    class_4588 buffer = multiBufferSource.getBuffer(class_1921.method_23594());
                    RenderSystem.lineWidth((float)3.0f);
                    BlockHighLightRenderer.drawGridOverlays(poseStack, buffer, target, side -> gridHighLight.sideTips((class_1657)player, toolType, (class_2350)side));
                } else {
                    class_2350 facing = target.method_17780();
                    ResourceTexture texture2 = gridHighLight.sideTips((class_1657)player, toolType, facing);
                    if (texture2 != null) {
                        RenderSystem.disableDepthTest();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        poseStack.method_22904((double)facing.method_10148() * 0.01, (double)facing.method_10164() * 0.01, (double)facing.method_10165() * 0.01);
                        RenderUtils.moveToFace((class_4587)poseStack, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_2350)facing);
                        if (facing.method_10166() == class_2350.class_2351.field_11052) {
                            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)facing, (class_2350)class_2350.field_11035);
                        } else {
                            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)facing, null);
                        }
                        poseStack.method_22905(0.0625f, 0.0625f, 0.0f);
                        poseStack.method_46416(-8.0f, -8.0f, 0.0f);
                        texture2.copy().draw(GuiGraphicsAccessor.create(class_310.method_1551(), poseStack, class_4597.method_22991((class_287)class_289.method_1348().method_1349())), 0, 0, 4.0f, 4.0f, 8, 8);
                        RenderSystem.disableBlend();
                        RenderSystem.enableDepthTest();
                    }
                }
                poseStack.method_22909();
                return;
            }
            ICoverable coverable = GTCapabilityHelper.getCoverable((class_1937)level, blockPos, target.method_17780());
            if (coverable != null) {
                if (CoverPlaceBehavior.isCoverBehaviorItem(held, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) {
                    class_243 pos = camera.method_19326();
                    poseStack.method_22903();
                    poseStack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
                    class_4588 buffer = multiBufferSource.getBuffer(class_1921.method_23594());
                    RenderSystem.lineWidth((float)3.0f);
                    BlockHighLightRenderer.drawGridOverlays(poseStack, buffer, target, side -> coverable.hasCover((class_2350)side) ? null : GuiTextures.TOOL_ATTACH_COVER);
                    poseStack.method_22909();
                }
            }
            if ((texture2 = held.method_7909()) instanceof PipeBlockItem) {
                PipeBlockItem pipeBlockItem = (PipeBlockItem)texture2;
                v1 = pipeBlockItem.getBlock().pipeType;
            } else {
                v1 = pipeType = null;
            }
            if (pipeType instanceof IPipeType) {
                PipeBlockEntity pipeBlockEntity;
                IPipeType type = pipeType;
                if (blockEntity instanceof PipeBlockEntity && ((IPipeType)((Object)(pipeBlockEntity = (PipeBlockEntity)blockEntity).getPipeType())).type().equals((Object)type.type())) {
                    class_243 pos = camera.method_19326();
                    poseStack.method_22903();
                    poseStack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
                    class_4588 buffer = multiBufferSource.getBuffer(class_1921.method_23594());
                    RenderSystem.lineWidth((float)3.0f);
                    BlockHighLightRenderer.drawGridOverlays(poseStack, buffer, target, side -> level.method_22347(blockPos.method_10093(side)) ? pipeBlockEntity.getPipeTexture(true) : null);
                    poseStack.method_22909();
                }
            }
        }
    }

    private static void drawGridOverlays(class_4587 poseStack, class_4588 buffer, class_3965 blockHitResult, Function<class_2350, ResourceTexture> test) {
        boolean hoverRight;
        boolean hoverTop;
        boolean hoverLeft;
        ResourceTexture bottomBlocked;
        ResourceTexture rightBlocked;
        ResourceTexture topBlocked;
        ResourceTexture leftBlocked;
        rColour = gColour = 0.2f + (float)Math.sin((float)System.currentTimeMillis() % 2513.2742f / 800.0f) / 2.0f;
        bColour = 1.0f;
        class_2338 blockPos = blockHitResult.method_17777();
        class_2350 facing = blockHitResult.method_17780();
        class_238 box = new class_238(blockPos);
        class_2350 attachSide = ICoverable.traceCoverSide(blockHitResult);
        Vector3f topRight = new Vector3f((float)box.field_1320, (float)box.field_1325, (float)box.field_1324);
        Vector3f bottomRight = new Vector3f((float)box.field_1320, (float)box.field_1322, (float)box.field_1324);
        Vector3f bottomLeft = new Vector3f((float)box.field_1323, (float)box.field_1322, (float)box.field_1324);
        Vector3f topLeft = new Vector3f((float)box.field_1323, (float)box.field_1325, (float)box.field_1324);
        Vector3f shift = new Vector3f(0.25f, 0.0f, 0.0f);
        Vector3f shiftVert = new Vector3f(0.0f, 0.25f, 0.0f);
        Vector3f cubeCenter = box.method_1005().method_46409();
        topRight.sub((Vector3fc)cubeCenter);
        bottomRight.sub((Vector3fc)cubeCenter);
        bottomLeft.sub((Vector3fc)cubeCenter);
        topLeft.sub((Vector3fc)cubeCenter);
        ResourceTexture frontBlocked = test.apply(facing);
        ResourceTexture backBlocked = test.apply(facing.method_10153());
        boolean hoverFront = attachSide == facing;
        boolean hoverBack = attachSide == facing.method_10153();
        Vector3f down = new Vector3f(0.0f, -1.0f, 0.0f);
        boolean hoverBottom = switch (facing) {
            case class_2350.field_11039 -> {
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)down));
                leftBlocked = test.apply(class_2350.field_11043);
                topBlocked = test.apply(class_2350.field_11036);
                rightBlocked = test.apply(class_2350.field_11035);
                bottomBlocked = test.apply(class_2350.field_11033);
                hoverLeft = attachSide == class_2350.field_11043;
                hoverTop = attachSide == class_2350.field_11036;
                hoverRight = attachSide == class_2350.field_11035;
                yield attachSide == class_2350.field_11033;
            }
            case class_2350.field_11034 -> {
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)down));
                leftBlocked = test.apply(class_2350.field_11035);
                topBlocked = test.apply(class_2350.field_11036);
                rightBlocked = test.apply(class_2350.field_11043);
                bottomBlocked = test.apply(class_2350.field_11033);
                hoverLeft = attachSide == class_2350.field_11035;
                hoverTop = attachSide == class_2350.field_11036;
                hoverRight = attachSide == class_2350.field_11043;
                yield attachSide == class_2350.field_11033;
            }
            case class_2350.field_11043 -> {
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis((float)Math.PI, (Vector3fc)down));
                leftBlocked = test.apply(class_2350.field_11034);
                topBlocked = test.apply(class_2350.field_11036);
                rightBlocked = test.apply(class_2350.field_11039);
                bottomBlocked = test.apply(class_2350.field_11033);
                hoverLeft = attachSide == class_2350.field_11034;
                hoverTop = attachSide == class_2350.field_11036;
                hoverRight = attachSide == class_2350.field_11039;
                yield attachSide == class_2350.field_11033;
            }
            case class_2350.field_11036 -> {
                Vector3f side = new Vector3f(1.0f, 0.0f, 0.0f);
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(-1.5707964f, (Vector3fc)side));
                leftBlocked = test.apply(class_2350.field_11034);
                topBlocked = test.apply(class_2350.field_11035);
                rightBlocked = test.apply(class_2350.field_11039);
                bottomBlocked = test.apply(class_2350.field_11043);
                hoverLeft = attachSide == class_2350.field_11034;
                hoverTop = attachSide == class_2350.field_11035;
                hoverRight = attachSide == class_2350.field_11039;
                yield attachSide == class_2350.field_11043;
            }
            case class_2350.field_11033 -> {
                Vector3f side = new Vector3f(1.0f, 0.0f, 0.0f);
                topRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                bottomRight.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                bottomLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                topLeft.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                shift.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                shiftVert.rotate((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, (Vector3fc)side));
                leftBlocked = test.apply(class_2350.field_11039);
                topBlocked = test.apply(class_2350.field_11035);
                rightBlocked = test.apply(class_2350.field_11034);
                bottomBlocked = test.apply(class_2350.field_11043);
                hoverLeft = attachSide == class_2350.field_11039;
                hoverTop = attachSide == class_2350.field_11035;
                hoverRight = attachSide == class_2350.field_11034;
                yield attachSide == class_2350.field_11043;
            }
            default -> {
                leftBlocked = test.apply(class_2350.field_11039);
                topBlocked = test.apply(class_2350.field_11036);
                rightBlocked = test.apply(class_2350.field_11034);
                bottomBlocked = test.apply(class_2350.field_11033);
                hoverLeft = attachSide == class_2350.field_11039;
                hoverTop = attachSide == class_2350.field_11036;
                hoverRight = attachSide == class_2350.field_11034;
                yield attachSide == class_2350.field_11033;
            }
        };
        topRight.add((Vector3fc)cubeCenter);
        bottomRight.add((Vector3fc)cubeCenter);
        bottomLeft.add((Vector3fc)cubeCenter);
        topLeft.add((Vector3fc)cubeCenter);
        Matrix4f mat = poseStack.method_23760().method_23761();
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)topRight).add((Vector3fc)new Vector3f((Vector3fc)shift).mul(-1.0f)), new Vector3f((Vector3fc)bottomRight).add((Vector3fc)new Vector3f((Vector3fc)shift).mul(-1.0f)));
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)bottomLeft).add((Vector3fc)shift), new Vector3f((Vector3fc)topLeft).add((Vector3fc)shift));
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)topLeft).add((Vector3fc)new Vector3f((Vector3fc)shiftVert).mul(-1.0f)), new Vector3f((Vector3fc)topRight).add((Vector3fc)new Vector3f((Vector3fc)shiftVert).mul(-1.0f)));
        BlockHighLightRenderer.drawLine(mat, buffer, new Vector3f((Vector3fc)bottomLeft).add((Vector3fc)shiftVert), new Vector3f((Vector3fc)bottomRight).add((Vector3fc)shiftVert));
        poseStack.method_22903();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.method_22904((double)facing.method_10148() * 0.01, (double)facing.method_10164() * 0.01, (double)facing.method_10165() * 0.01);
        RenderUtils.moveToFace((class_4587)poseStack, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_2350)facing);
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)facing, (class_2350)class_2350.field_11035);
        } else {
            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)facing, null);
        }
        poseStack.method_22905(0.0625f, 0.0625f, 0.0f);
        poseStack.method_46416(-8.0f, -8.0f, 0.0f);
        class_332 graphics = GuiGraphicsAccessor.create(class_310.method_1551(), poseStack, class_4597.method_22991((class_287)class_289.method_1348().method_1349()));
        if (leftBlocked != null) {
            leftBlocked.copy().scale(0.9f).setColor(hoverLeft ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 0.0f, 6.0f, 4, 4);
        }
        if (topBlocked != null) {
            topBlocked.copy().scale(0.9f).setColor(hoverTop ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 6.0f, 0.0f, 4, 4);
        }
        if (rightBlocked != null) {
            rightBlocked.copy().scale(0.9f).setColor(hoverRight ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 12.0f, 6.0f, 4, 4);
        }
        if (bottomBlocked != null) {
            bottomBlocked.copy().scale(0.9f).setColor(hoverBottom ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 6.0f, 12.0f, 4, 4);
        }
        if (frontBlocked != null) {
            frontBlocked.copy().scale(0.9f).setColor(hoverFront ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 6.0f, 6.0f, 4, 4);
        }
        if (backBlocked != null) {
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 0.0f, 0.0f, 4, 4);
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 12.0f, 0.0f, 4, 4);
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 0.0f, 12.0f, 4, 4);
            backBlocked.copy().scale(0.9f).setColor(hoverBack ? -1 : 0x44FFFFFF).draw(graphics, 0, 0, 12.0f, 12.0f, 4, 4);
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    private static void drawLine(Matrix4f mat, class_4588 buffer, Vector3f from, Vector3f to) {
        Vector3f normal = new Vector3f((Vector3fc)from).sub((Vector3fc)to);
        buffer.method_22918(mat, from.x, from.y, from.z).method_22915(rColour, gColour, bColour, 1.0f).method_22914(normal.x, normal.y, normal.z).method_1344();
        buffer.method_22918(mat, to.x, to.y, to.z).method_22915(rColour, gColour, bColour, 1.0f).method_22914(normal.x, normal.y, normal.z).method_1344();
    }
}

