/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_777;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeModel {
    public static final int ITEM_CONNECTIONS = 12;
    public final float thickness;
    public final class_238 coreCube;
    public final Map<class_2350, class_238> sideCubes;
    public Supplier<class_2960> sideTexture;
    public Supplier<class_2960> endTexture;
    @Nullable
    public @Nullable Supplier<@Nullable class_2960> secondarySideTexture;
    @Nullable
    public @Nullable Supplier<@Nullable class_2960> secondaryEndTexture;
    public class_2960 sideOverlayTexture;
    public class_2960 endOverlayTexture;
    @Environment(value=EnvType.CLIENT)
    class_1058 sideSprite;
    @Environment(value=EnvType.CLIENT)
    class_1058 endSprite;
    @Environment(value=EnvType.CLIENT)
    class_1058 secondarySideSprite;
    @Environment(value=EnvType.CLIENT)
    class_1058 secondaryEndSprite;
    @Environment(value=EnvType.CLIENT)
    class_1058 sideOverlaySprite;
    @Environment(value=EnvType.CLIENT)
    class_1058 endOverlaySprite;
    private final Map<Optional<class_2350>, List<class_777>> itemModelCache = new ConcurrentHashMap<Optional<class_2350>, List<class_777>>();

    public PipeModel(float thickness, Supplier<class_2960> sideTexture, Supplier<class_2960> endTexture, @Nullable @Nullable Supplier<@Nullable class_2960> secondarySideTexture, @Nullable @Nullable Supplier<@Nullable class_2960> secondaryEndTexture) {
        this.sideTexture = sideTexture;
        this.endTexture = endTexture;
        this.secondarySideTexture = secondarySideTexture;
        this.secondaryEndTexture = secondaryEndTexture;
        this.thickness = thickness;
        double min = (1.0 - (double)thickness) / 2.0;
        double max = min + (double)thickness;
        this.coreCube = new class_238(min, min, min, max, max, max);
        this.sideCubes = new EnumMap<class_2350, class_238>(class_2350.class);
        class_2350[] class_2350Array = class_2350.values();
        int n = class_2350Array.length;
        for (int i = 0; i < n; ++i) {
            class_2350 side;
            class_2382 normal = (side = class_2350Array[i]).method_10163();
            this.sideCubes.put(side, new class_238(normal.method_10263() == 0 ? min : (normal.method_10263() > 0 ? max : 0.0), normal.method_10264() == 0 ? min : (normal.method_10264() > 0 ? max : 0.0), normal.method_10260() == 0 ? min : (normal.method_10260() > 0 ? max : 0.0), normal.method_10263() == 0 ? max : (normal.method_10263() > 0 ? 1.0 : min), normal.method_10264() == 0 ? max : (normal.method_10264() > 0 ? 1.0 : min), normal.method_10260() == 0 ? max : (normal.method_10260() > 0 ? 1.0 : min)));
        }
    }

    public class_265 getShapes(int connections) {
        ArrayList<class_265> shapes = new ArrayList<class_265>(7);
        shapes.add(class_259.method_1078((class_238)this.coreCube));
        for (class_2350 side : class_2350.values()) {
            if (!this.isConnected(connections, side)) continue;
            shapes.add(class_259.method_1078((class_238)this.sideCubes.get(side)));
        }
        return shapes.stream().reduce(class_259.method_1073(), class_259::method_1084);
    }

    public boolean isConnected(int connections, class_2350 side) {
        return (connections >> side.ordinal() & 1) == 1;
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_777> bakeQuads(@Nullable class_2350 side, int connections) {
        if (this.sideSprite == null) {
            this.sideSprite = ModelFactory.getBlockSprite((class_2960)this.sideTexture.get());
        }
        if (this.endSprite == null) {
            this.endSprite = ModelFactory.getBlockSprite((class_2960)this.endTexture.get());
        }
        if (this.secondarySideTexture != null && this.secondarySideTexture.get() != null && this.secondarySideSprite == null) {
            this.secondarySideSprite = ModelFactory.getBlockSprite((class_2960)this.secondarySideTexture.get());
        }
        if (this.secondaryEndTexture != null && this.secondaryEndTexture.get() != null && this.secondaryEndSprite == null) {
            this.secondaryEndSprite = ModelFactory.getBlockSprite((class_2960)this.secondaryEndTexture.get());
        }
        if (this.sideOverlayTexture != null && this.sideOverlaySprite == null) {
            this.sideOverlaySprite = ModelFactory.getBlockSprite((class_2960)this.sideOverlayTexture);
        }
        if (this.endOverlayTexture != null && this.endOverlaySprite == null) {
            this.endOverlaySprite = ModelFactory.getBlockSprite((class_2960)this.endOverlayTexture);
        }
        if (side != null) {
            if (this.thickness == 1.0f) {
                ArrayList<class_777> quads = new ArrayList<class_777>();
                quads.add(FaceQuad.builder((class_2350)side, (class_1058)this.sideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                if (this.secondarySideSprite != null) {
                    quads.add(FaceQuad.builder((class_2350)side, (class_1058)this.secondarySideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                }
                return quads;
            }
            if (this.isConnected(connections, side)) {
                ArrayList<class_777> quads = new ArrayList<class_777>();
                quads.add(FaceQuad.builder((class_2350)side, (class_1058)this.endSprite).cube(this.sideCubes.get(side).method_1014(-0.001)).cubeUV().tintIndex(1).bake());
                if (this.secondaryEndSprite != null) {
                    quads.add(FaceQuad.builder((class_2350)side, (class_1058)this.secondaryEndSprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(1).bake());
                }
                if (this.endOverlaySprite != null) {
                    quads.add(FaceQuad.builder((class_2350)side, (class_1058)this.endOverlaySprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(0).bake());
                }
                if (this.sideOverlaySprite != null) {
                    for (class_2350 face : class_2350.values()) {
                        if (face == side || face == side.method_10153()) continue;
                        quads.add(FaceQuad.builder((class_2350)face, (class_1058)this.sideOverlaySprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(2).bake());
                    }
                }
                return quads;
            }
            return Collections.emptyList();
        }
        LinkedList<class_777> quads = new LinkedList<class_777>();
        if (this.thickness < 1.0f) {
            for (class_2350 face : class_2350.values()) {
                if (!this.isConnected(connections, face)) {
                    quads.add(FaceQuad.builder((class_2350)face, (class_1058)this.sideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                    if (this.secondarySideSprite != null) {
                        quads.add(FaceQuad.builder((class_2350)face, (class_1058)this.secondarySideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                    }
                }
                for (class_2350 facing : class_2350.values()) {
                    if (facing.method_10166() == face.method_10166() || !this.isConnected(connections, facing)) continue;
                    quads.add(FaceQuad.builder((class_2350)face, (class_1058)this.sideSprite).cube(this.sideCubes.get(facing)).cubeUV().tintIndex(0).bake());
                    if (this.secondarySideSprite != null) {
                        quads.add(FaceQuad.builder((class_2350)face, (class_1058)this.secondarySideSprite).cube(this.sideCubes.get(facing)).cubeUV().tintIndex(0).bake());
                    }
                    if (this.sideOverlaySprite == null) continue;
                    quads.add(FaceQuad.builder((class_2350)face, (class_1058)this.sideOverlaySprite).cube(this.sideCubes.get(facing).method_1014(0.001)).cubeUV().tintIndex(2).bake());
                }
            }
        }
        return quads;
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public class_1058 getParticleTexture() {
        if (this.sideSprite == null) {
            this.sideSprite = ModelFactory.getBlockSprite((class_2960)this.sideTexture.get());
        }
        return this.sideSprite;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        IItemRendererProvider.disabled.set(true);
        class_310.method_1551().method_1480().method_23179(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (state, direction, random) -> this.itemModelCache.computeIfAbsent(Optional.ofNullable(direction), direction1 -> this.bakeQuads(direction1.orElse(null), 12)));
        IItemRendererProvider.disabled.set(false);
    }

    @Environment(value=EnvType.CLIENT)
    public void registerTextureAtlas(Consumer<class_2960> register) {
        this.itemModelCache.clear();
        register.accept(this.sideTexture.get());
        register.accept(this.endTexture.get());
        if (this.sideOverlayTexture != null) {
            register.accept(this.sideOverlayTexture);
        }
        if (this.endOverlayTexture != null) {
            register.accept(this.endOverlayTexture);
        }
        this.sideSprite = null;
        this.endSprite = null;
        this.endOverlaySprite = null;
    }

    public void setSideOverlayTexture(class_2960 sideOverlayTexture) {
        this.sideOverlayTexture = sideOverlayTexture;
    }

    public void setEndOverlayTexture(class_2960 endOverlayTexture) {
        this.endOverlayTexture = endOverlayTexture;
    }
}

