/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.client.renderer.GTRendererProvider;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.OverlaySteamMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayTieredMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSidedCasingMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSteamMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableTieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.TriFunction;

@ParametersAreNonnullByDefault
@class_6328
public class MachineBuilder<DEFINITION extends MachineDefinition>
extends BuilderBase<DEFINITION> {
    protected final Registrate registrate;
    protected final String name;
    protected final BiFunction<class_4970.class_2251, DEFINITION, IMachineBlock> blockFactory;
    protected final BiFunction<IMachineBlock, class_1792.class_1793, MetaMachineItem> itemFactory;
    protected final TriFunction<class_2591<?>, class_2338, class_2680, IMachineBlockEntity> blockEntityFactory;
    protected Function<class_2960, DEFINITION> definitionFactory;
    protected Function<IMachineBlockEntity, MetaMachine> metaMachine;
    @Nullable
    private Supplier<IRenderer> renderer;
    private class_265 shape = class_259.method_1077();
    private RotationState rotationState = RotationState.NONE;
    private boolean hasTESR;
    private NonNullUnaryOperator<class_4970.class_2251> blockProp = p -> p;
    private NonNullUnaryOperator<class_1792.class_1793> itemProp = p -> p;
    private Consumer<BlockBuilder<? extends class_2248, ?>> blockBuilder;
    private Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder;
    private NonNullConsumer<class_2591<class_2586>> onBlockEntityRegister = MetaMachineBlockEntity::onBlockEntityRegister;
    private GTRecipeType[] recipeTypes;
    private int tier;
    private Object2IntMap<RecipeCapability<?>> recipeOutputLimits = new Object2IntOpenHashMap();
    private int paintingColor;
    private BiFunction<class_1799, Integer, Integer> itemColor;
    private PartAbility[] abilities;
    private final List<class_2561> tooltips;
    private BiConsumer<class_1799, List<class_2561>> tooltipBuilder;
    private BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier;
    private boolean alwaysTryModifyRecipe;
    private Supplier<class_2680> appearance;
    @Nullable
    private EditableMachineUI editableUI;
    private String langValue;
    private final Set<CompassSection> compassSections;
    @Nullable
    private String compassNode;
    @Nullable
    private class_2960 compassPage;
    private final List<class_2960> preNodes;

    protected MachineBuilder(Registrate registrate, String name, Function<class_2960, DEFINITION> definitionFactory, Function<IMachineBlockEntity, MetaMachine> metaMachine, BiFunction<class_4970.class_2251, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, class_1792.class_1793, MetaMachineItem> itemFactory, TriFunction<class_2591<?>, class_2338, class_2680, IMachineBlockEntity> blockEntityFactory) {
        super(new class_2960(registrate.getModid(), name), new Object[0]);
        this.paintingColor = Long.decode(ConfigHolder.INSTANCE.client.defaultPaintingColor).intValue();
        this.itemColor = (itemStack, tintIndex) -> tintIndex == 2 ? GTValues.VC[this.tier] : (tintIndex == 1 ? this.paintingColor : -1);
        this.abilities = new PartAbility[0];
        this.tooltips = new ArrayList<class_2561>();
        this.recipeModifier = (machine, recipe) -> recipe;
        this.langValue = null;
        this.compassSections = new HashSet<CompassSection>();
        this.compassNode = null;
        this.compassPage = null;
        this.preNodes = new ArrayList<class_2960>();
        this.registrate = registrate;
        this.name = name;
        this.metaMachine = metaMachine;
        this.blockFactory = blockFactory;
        this.itemFactory = itemFactory;
        this.blockEntityFactory = blockEntityFactory;
        this.definitionFactory = definitionFactory;
    }

    public MachineBuilder<DEFINITION> recipeType(GTRecipeType type) {
        this.recipeTypes = (GTRecipeType[])ArrayUtils.add((Object[])this.recipeTypes, (Object)type);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeTypes(GTRecipeType ... types) {
        for (GTRecipeType type : types) {
            this.recipeTypes = (GTRecipeType[])ArrayUtils.add((Object[])this.recipeTypes, (Object)type);
        }
        return this;
    }

    public static <DEFINITION extends MachineDefinition> MachineBuilder<DEFINITION> create(Registrate registrate, String name, Function<class_2960, DEFINITION> definitionFactory, Function<IMachineBlockEntity, MetaMachine> metaMachine, BiFunction<class_4970.class_2251, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, class_1792.class_1793, MetaMachineItem> itemFactory, TriFunction<class_2591<?>, class_2338, class_2680, IMachineBlockEntity> blockEntityFactory) {
        return new MachineBuilder<DEFINITION>(registrate, name, definitionFactory, metaMachine, blockFactory, itemFactory, blockEntityFactory);
    }

    public MachineBuilder<DEFINITION> modelRenderer(Supplier<class_2960> model) {
        this.renderer = () -> new MachineRenderer((class_2960)model.get());
        return this;
    }

    public MachineBuilder<DEFINITION> defaultModelRenderer() {
        return this.modelRenderer(() -> new class_2960(this.registrate.getModid(), "block/" + this.name));
    }

    public MachineBuilder<DEFINITION> overlayTieredHullRenderer(String name) {
        return this.renderer(() -> new OverlayTieredMachineRenderer(this.tier, new class_2960(this.registrate.getModid(), "block/machine/part/" + name)));
    }

    public MachineBuilder<DEFINITION> overlaySteamHullRenderer(String name) {
        return this.renderer(() -> new OverlaySteamMachineRenderer(new class_2960(this.registrate.getModid(), "block/machine/part/" + name)));
    }

    public MachineBuilder<DEFINITION> workableTieredHullRenderer(class_2960 workableModel) {
        return this.renderer(() -> new WorkableTieredHullMachineRenderer(this.tier, workableModel));
    }

    public MachineBuilder<DEFINITION> workableSteamHullRenderer(boolean isHighPressure, class_2960 workableModel) {
        return this.renderer(() -> new WorkableSteamMachineRenderer(isHighPressure, workableModel));
    }

    public MachineBuilder<DEFINITION> workableCasingRenderer(class_2960 baseCasing, class_2960 workableModel) {
        return this.renderer(() -> new WorkableCasingMachineRenderer(baseCasing, workableModel));
    }

    public MachineBuilder<DEFINITION> workableCasingRenderer(class_2960 baseCasing, class_2960 workableModel, boolean tint) {
        return this.renderer(() -> new WorkableCasingMachineRenderer(baseCasing, workableModel, tint));
    }

    public MachineBuilder<DEFINITION> sidedWorkableCasingRenderer(String basePath, class_2960 overlayModel, boolean tint) {
        return this.renderer(() -> new WorkableSidedCasingMachineRenderer(basePath, overlayModel, tint));
    }

    public MachineBuilder<DEFINITION> appearanceBlock(Supplier<? extends class_2248> block) {
        this.appearance = () -> ((class_2248)block.get()).method_9564();
        return this;
    }

    public MachineBuilder<DEFINITION> tooltips(class_2561 ... components) {
        this.tooltips.addAll(Arrays.stream(components).filter(Objects::nonNull).toList());
        return this;
    }

    public MachineBuilder<DEFINITION> abilities(PartAbility ... abilities) {
        this.abilities = abilities;
        this.compassSections(GTCompassSections.PARTS);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier, boolean alwaysTryModifyRecipe) {
        this.recipeModifier = recipeModifier;
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this;
    }

    public MachineBuilder<DEFINITION> addOutputLimit(RecipeCapability<?> capability, int limit) {
        this.recipeOutputLimits.put(capability, limit);
        return this;
    }

    public MachineBuilder<DEFINITION> compassSections(CompassSection ... sections) {
        this.compassSections.addAll(Arrays.stream(sections).toList());
        return this;
    }

    public MachineBuilder<DEFINITION> compassNodeSelf() {
        this.compassNode = this.name;
        return this;
    }

    public MachineBuilder<DEFINITION> compassNode(String compassNode) {
        this.compassNode = compassNode;
        return this;
    }

    public MachineBuilder<DEFINITION> compassPreNodes(CompassSection section, String ... compassNodes) {
        for (String nodeID : compassNodes) {
            this.preNodes.add(GTCEu.id(section.sectionID().method_12832() + "/" + nodeID));
        }
        return this;
    }

    public MachineBuilder<DEFINITION> compassPreNodes(class_2960 ... compassNodes) {
        this.preNodes.addAll(Arrays.asList(compassNodes));
        return this;
    }

    public MachineBuilder<DEFINITION> compassPreNodes(CompassNode ... compassNodes) {
        this.preNodes.addAll(Arrays.stream(compassNodes).map(CompassNode::nodeID).toList());
        return this;
    }

    protected DEFINITION createDefinition() {
        return (DEFINITION)((MachineDefinition)this.definitionFactory.apply(new class_2960(this.registrate.getModid(), this.name)));
    }

    @Override
    public DEFINITION register() {
        DEFINITION definition = this.createDefinition();
        BlockBuilder blockBuilder = (BlockBuilder)this.registrate.block(this.name, properties -> {
            RotationState.set(this.rotationState);
            IMachineBlock b = this.blockFactory.apply((class_4970.class_2251)properties, definition);
            RotationState.clear();
            return b.self();
        }).color(() -> () -> IMachineBlock::colorTinted).initialProperties(() -> class_2246.field_10200).properties(properties -> properties.method_42327()).addLayer(() -> class_1921::method_23579).blockstate(NonNullBiConsumer.noop()).properties(this.blockProp).onRegister(b -> Arrays.stream(this.abilities).forEach(a -> a.register(this.tier, (class_2248)b)));
        if (this.langValue != null) {
            blockBuilder.lang(this.langValue);
        }
        if (this.blockBuilder != null) {
            this.blockBuilder.accept(blockBuilder);
        }
        BlockEntry block = blockBuilder.register();
        ItemBuilder itemBuilder = ((ItemBuilder)this.registrate.item(this.name, properties -> this.itemFactory.apply((IMachineBlock)block.get(), (class_1792.class_1793)properties)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model(NonNullBiConsumer.noop()).color(() -> () -> this.itemColor::apply).properties(this.itemProp);
        if (this.itemBuilder != null) {
            this.itemBuilder.accept(itemBuilder);
        }
        if (this.compassNode != null) {
            if (this.compassSections.isEmpty()) {
                this.compassSections.add(GTCompassSections.MACHINES);
            }
            for (CompassSection section : this.compassSections) {
                itemBuilder.onRegister(item -> {
                    CompassNode node = CompassNode.getOrCreate(section, this.compassNode).addItem(() -> ((MetaMachineItem)((Object)item)).method_8389()).addPreNode((class_2960[])this.preNodes.toArray(class_2960[]::new));
                    if (this.compassPage != null) {
                        node.page(this.compassPage);
                    }
                });
            }
        }
        ItemEntry item2 = itemBuilder.register();
        BlockEntityBuilder blockEntityBuilder = ((BlockEntityBuilder)this.registrate.blockEntity(this.name, (type, pos, state) -> ((IMachineBlockEntity)this.blockEntityFactory.apply((Object)type, (Object)pos, (Object)state)).self()).onRegister(this.onBlockEntityRegister)).validBlock((NonNullSupplier)block);
        if (this.hasTESR) {
            blockEntityBuilder = blockEntityBuilder.renderer(() -> GTRendererProvider::getOrCreate);
        }
        BlockEntityEntry blockEntity = blockEntityBuilder.register();
        ((MachineDefinition)definition).setRecipeTypes(this.recipeTypes);
        ((MachineDefinition)definition).setBlockSupplier((Supplier<class_2248>)block);
        ((MachineDefinition)definition).setItemSupplier((Supplier<MetaMachineItem>)item2);
        ((MachineDefinition)definition).setTier(this.tier);
        ((MachineDefinition)definition).setRecipeOutputLimits(this.recipeOutputLimits);
        ((MachineDefinition)definition).setBlockEntityTypeSupplier(() -> ((BlockEntityEntry)blockEntity).get());
        ((MachineDefinition)definition).setMachineSupplier(this.metaMachine);
        ((MachineDefinition)definition).setTooltipBuilder((itemStack, components) -> {
            components.addAll(this.tooltips);
            if (this.tooltipBuilder != null) {
                this.tooltipBuilder.accept((class_1799)itemStack, (List<class_2561>)components);
            }
        });
        ((MachineDefinition)definition).setRecipeModifier(this.recipeModifier);
        ((MachineDefinition)definition).setAlwaysTryModifyRecipe(this.alwaysTryModifyRecipe);
        if (this.renderer == null) {
            this.renderer = () -> new MachineRenderer(new class_2960(this.registrate.getModid(), "block/machine/" + this.name));
        }
        if (this.recipeTypes != null) {
            for (GTRecipeType type2 : this.recipeTypes) {
                if (type2 == null || type2.getIconSupplier() != null) continue;
                type2.setIconSupplier(() -> definition.asStack());
            }
        }
        if (this.appearance == null) {
            this.appearance = () -> ((BlockEntry)block).getDefaultState();
        }
        if (this.editableUI != null) {
            ((MachineDefinition)definition).setEditableUI(this.editableUI);
        }
        ((MachineDefinition)definition).setAppearance(this.appearance);
        ((MachineDefinition)definition).setRenderer(LDLib.isClient() ? this.renderer.get() : IRenderer.EMPTY);
        ((MachineDefinition)definition).setShape(this.shape);
        ((MachineDefinition)definition).setDefaultPaintingColor(this.paintingColor);
        GTRegistries.MACHINES.register(((MachineDefinition)definition).getId(), (MachineDefinition)definition);
        return definition;
    }

    public MachineBuilder<DEFINITION> definitionFactory(Function<class_2960, DEFINITION> definitionFactory) {
        this.definitionFactory = definitionFactory;
        return this;
    }

    public MachineBuilder<DEFINITION> metaMachine(Function<IMachineBlockEntity, MetaMachine> metaMachine) {
        this.metaMachine = metaMachine;
        return this;
    }

    public MachineBuilder<DEFINITION> renderer(@Nullable Supplier<IRenderer> renderer) {
        this.renderer = renderer;
        return this;
    }

    public MachineBuilder<DEFINITION> shape(class_265 shape) {
        this.shape = shape;
        return this;
    }

    public MachineBuilder<DEFINITION> rotationState(RotationState rotationState) {
        this.rotationState = rotationState;
        return this;
    }

    public MachineBuilder<DEFINITION> hasTESR(boolean hasTESR) {
        this.hasTESR = hasTESR;
        return this;
    }

    public MachineBuilder<DEFINITION> blockProp(NonNullUnaryOperator<class_4970.class_2251> blockProp) {
        this.blockProp = blockProp;
        return this;
    }

    public MachineBuilder<DEFINITION> itemProp(NonNullUnaryOperator<class_1792.class_1793> itemProp) {
        this.itemProp = itemProp;
        return this;
    }

    public MachineBuilder<DEFINITION> blockBuilder(Consumer<BlockBuilder<? extends class_2248, ?>> blockBuilder) {
        this.blockBuilder = blockBuilder;
        return this;
    }

    public MachineBuilder<DEFINITION> itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
        this.itemBuilder = itemBuilder;
        return this;
    }

    public MachineBuilder<DEFINITION> onBlockEntityRegister(NonNullConsumer<class_2591<class_2586>> onBlockEntityRegister) {
        this.onBlockEntityRegister = onBlockEntityRegister;
        return this;
    }

    public int tier() {
        return this.tier;
    }

    public MachineBuilder<DEFINITION> tier(int tier) {
        this.tier = tier;
        return this;
    }

    public MachineBuilder<DEFINITION> recipeOutputLimits(Object2IntMap<RecipeCapability<?>> recipeOutputLimits) {
        this.recipeOutputLimits = recipeOutputLimits;
        return this;
    }

    public MachineBuilder<DEFINITION> paintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        return this;
    }

    public MachineBuilder<DEFINITION> itemColor(BiFunction<class_1799, Integer, Integer> itemColor) {
        this.itemColor = itemColor;
        return this;
    }

    public MachineBuilder<DEFINITION> tooltipBuilder(BiConsumer<class_1799, List<class_2561>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier) {
        this.recipeModifier = recipeModifier;
        return this;
    }

    public MachineBuilder<DEFINITION> alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this;
    }

    public MachineBuilder<DEFINITION> appearance(Supplier<class_2680> appearance) {
        this.appearance = appearance;
        return this;
    }

    public MachineBuilder<DEFINITION> editableUI(@Nullable EditableMachineUI editableUI) {
        this.editableUI = editableUI;
        return this;
    }

    public MachineBuilder<DEFINITION> langValue(String langValue) {
        this.langValue = langValue;
        return this;
    }

    public MachineBuilder<DEFINITION> compassPage(@Nullable class_2960 compassPage) {
        this.compassPage = compassPage;
        return this;
    }
}

