/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.registry.registrate.IGTFluidBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.SoundEntryBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.fabric.GTRegistrateImpl;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6328;
import org.apache.commons.lang3.function.TriFunction;

@ParametersAreNonnullByDefault
@class_6328
public abstract class GTRegistrate
extends Registrate {
    private RegistryEntry<class_1761> currentTab;
    private static final Map<RegistryEntry<?>, RegistryEntry<class_1761>> TAB_LOOKUP = new IdentityHashMap();

    protected GTRegistrate(String modId) {
        super(modId);
    }

    @Nonnull
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static GTRegistrate create(String modId) {
        return GTRegistrateImpl.create(modId);
    }

    public abstract void registerRegistrate();

    public IGTFluidBuilder createFluid(String name, String langKey, Material material, class_2960 stillTexture, class_2960 flowingTexture) {
        return GTRegistrate.fluid(this, material, name, langKey, stillTexture, flowingTexture);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IGTFluidBuilder fluid(GTRegistrate parent, Material material, String name, String langKey, class_2960 stillTexture, class_2960 flowingTexture) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return GTRegistrateImpl.fluid(parent, (Material)var1_1, (String)var2_2, (String)var3_3, (class_2960)var4_4, (class_2960)var5_5);
    }

    public <DEFINITION extends MachineDefinition> MachineBuilder<DEFINITION> machine(String name, Function<class_2960, DEFINITION> definitionFactory, Function<IMachineBlockEntity, MetaMachine> metaMachine, BiFunction<class_4970.class_2251, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, class_1792.class_1793, MetaMachineItem> itemFactory, TriFunction<class_2591<?>, class_2338, class_2680, IMachineBlockEntity> blockEntityFactory) {
        return MachineBuilder.create(this, name, definitionFactory, metaMachine, blockFactory, itemFactory, blockEntityFactory);
    }

    public MachineBuilder<MachineDefinition> machine(String name, Function<IMachineBlockEntity, MetaMachine> metaMachine) {
        return MachineBuilder.create(this, name, MachineDefinition::createDefinition, metaMachine, MetaMachineBlock::new, MetaMachineItem::new, MetaMachineBlockEntity::createBlockEntity);
    }

    public Stream<MachineBuilder<MachineDefinition>> machine(String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> metaMachine, int ... tiers) {
        return Arrays.stream(tiers).mapToObj(tier -> MachineBuilder.create(this, name + "." + GTValues.VN[tier].toLowerCase(Locale.ROOT), MachineDefinition::createDefinition, holder -> (MetaMachine)metaMachine.apply((IMachineBlockEntity)holder, tier), MetaMachineBlock::new, MetaMachineItem::new, MetaMachineBlockEntity::createBlockEntity));
    }

    public MultiblockMachineBuilder multiblock(String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine, BiFunction<class_4970.class_2251, MultiblockMachineDefinition, IMachineBlock> blockFactory, BiFunction<IMachineBlock, class_1792.class_1793, MetaMachineItem> itemFactory, TriFunction<class_2591<?>, class_2338, class_2680, IMachineBlockEntity> blockEntityFactory) {
        return MultiblockMachineBuilder.createMulti(this, name, metaMachine, blockFactory, itemFactory, blockEntityFactory);
    }

    public MultiblockMachineBuilder multiblock(String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine) {
        return MultiblockMachineBuilder.createMulti(this, name, metaMachine, MetaMachineBlock::new, MetaMachineItem::new, MetaMachineBlockEntity::createBlockEntity);
    }

    public SoundEntryBuilder sound(String name) {
        return new SoundEntryBuilder(GTCEu.id(name));
    }

    @Nonnull
    public <T extends class_1792> ItemBuilder<T, Registrate> item(String name, NonNullFunction<class_1792.class_1793, T> factory) {
        return super.item(name, factory).lang(FormattingUtil.toEnglishName(name.replaceAll("/.", "_")));
    }

    public void creativeModeTab(Supplier<RegistryEntry<class_1761>> currentTab) {
        this.currentTab = currentTab.get();
    }

    public void creativeModeTab(RegistryEntry<class_1761> currentTab) {
        this.currentTab = currentTab;
    }

    public boolean isInCreativeTab(RegistryEntry<?> entry, RegistryEntry<class_1761> tab) {
        return TAB_LOOKUP.get(entry) == tab;
    }

    public void setCreativeTab(RegistryEntry<?> entry, @Nullable RegistryEntry<class_1761> tab) {
        TAB_LOOKUP.put(entry, tab);
    }

    protected <R, T extends R> RegistryEntry<T> accept(String name, class_5321<? extends class_2378<R>> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
        RegistryEntry entry = super.accept(name, type, builder, creator, entryFactory);
        if (this.currentTab != null) {
            TAB_LOOKUP.put(entry, this.currentTab);
        }
        return entry;
    }

    public <P> NoConfigBuilder<class_1761, class_1761, P> defaultCreativeTab(P parent, String name, Consumer<class_1761.class_7913> config) {
        return this.createCreativeModeTab(parent, name, config);
    }

    protected <P> NoConfigBuilder<class_1761, class_1761, P> createCreativeModeTab(P parent, String name, Consumer<class_1761.class_7913> config) {
        return super.defaultCreativeTab(parent, name, config);
    }
}

