/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

@ParametersAreNonnullByDefault
@class_6328
public class CompassNode {
    private final class_2960 sectionID;
    private final class_2960 nodeID;
    private class_2960 page;
    private int size = 24;
    @Nullable
    private Position position = null;
    private final Set<class_2960> preNodes = new HashSet<class_2960>();
    private final List<Supplier<? extends class_1792>> items = new ArrayList<Supplier<? extends class_1792>>();
    private final Set<class_6862<class_1792>> tags = new HashSet<class_6862<class_1792>>();
    @Nullable
    private Supplier<IGuiTexture> icon = null;
    private String lang;

    private CompassNode(class_2960 sectionID, String nodeID) {
        this.sectionID = sectionID;
        this.lang = FormattingUtil.toEnglishName(nodeID);
        this.page = this.nodeID = GTCEu.id(sectionID.method_12832() + "/" + nodeID);
    }

    public static CompassNode getOrCreate(class_2960 sectionID, String nodeID) {
        CompassNode exist = (CompassNode)GTRegistries.COMPASS_NODES.get(GTCEu.id(sectionID.method_12832() + "/" + nodeID));
        return exist == null ? new CompassNode(sectionID, nodeID).register() : exist;
    }

    public static CompassNode getOrCreate(CompassSection section, String nodeID) {
        return CompassNode.getOrCreate(section.sectionID(), nodeID);
    }

    public static CompassNode getOrCreate(CompassSection section, Supplier<? extends class_1792> item) {
        return CompassNode.getOrCreate(section.sectionID(), class_7923.field_41178.method_10221((Object)item.get()).method_12832()).addItem(item);
    }

    private CompassNode register() {
        GTRegistries.COMPASS_NODES.register(this.nodeID, this);
        return this;
    }

    public String getUnlocalizedKey() {
        return this.nodeID.method_42093("compass.node");
    }

    public CompassNode position(int x, int y) {
        this.position = new Position(x, y);
        return this;
    }

    public CompassNode addPreNode(class_2960 ... nodeID) {
        this.preNodes.addAll(Arrays.stream(nodeID).toList());
        return this;
    }

    public CompassNode addPreNode(CompassNode ... node) {
        this.preNodes.addAll(Arrays.stream(node).map(CompassNode::nodeID).toList());
        return this;
    }

    public CompassNode addItem(Supplier<? extends class_1792> item) {
        this.items.add(item);
        return this;
    }

    public CompassNode addTag(class_6862<class_1792> ... tags) {
        this.tags.addAll(List.of(tags));
        return this;
    }

    public CompassNode iconIfNull(Supplier<IGuiTexture> icon) {
        this.icon = this.icon == null ? icon : this.icon;
        return this;
    }

    public class_2960 sectionID() {
        return this.sectionID;
    }

    public class_2960 nodeID() {
        return this.nodeID;
    }

    public CompassNode page(class_2960 page) {
        this.page = page;
        return this;
    }

    public CompassNode size(int size) {
        this.size = size;
        return this;
    }

    public CompassNode position(@Nullable Position position) {
        this.position = position;
        return this;
    }

    public CompassNode icon(@Nullable Supplier<IGuiTexture> icon) {
        this.icon = icon;
        return this;
    }

    public CompassNode lang(String lang) {
        this.lang = lang;
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public static class CompassNodeProvider
    implements class_2405 {
        private final class_7784 output;
        private final Predicate<class_2960> existingHelper;

        public CompassNodeProvider(class_7784 output, Predicate<class_2960> existingHelper) {
            this.output = output;
            this.existingHelper = existingHelper;
        }

        public CompletableFuture<?> method_10319(class_7403 cache) {
            return this.generate(this.output.method_45972(class_7784.class_7490.field_39368).resolve("gtceu"), cache);
        }

        public String method_10321() {
            return "GTCEU's Compass Nodes";
        }

        public CompletableFuture<?> generate(Path path, class_7403 cache) {
            HashMap<class_2960, List> nodesNOPosition = new HashMap<class_2960, List>();
            CompletionStage<Object> future = CompletableFuture.completedFuture(null);
            for (CompassNode node : GTRegistries.COMPASS_NODES) {
                if (node.position == null) {
                    nodesNOPosition.computeIfAbsent(node.sectionID, k -> new ArrayList()).add(node);
                    continue;
                }
                this.genNodeData(path, cache, node);
            }
            block1: for (List nodes : nodesNOPosition.values()) {
                int size = nodes.size();
                int row = (int)Math.ceil(Math.sqrt(size));
                for (int i = 0; i < row; ++i) {
                    boolean done = false;
                    for (int j = 0; j < row; ++j) {
                        int index = i * row + j;
                        if (index >= nodes.size()) {
                            done = true;
                            break;
                        }
                        CompassNode node = (CompassNode)nodes.get(index);
                        node.position = new Position(-(row * 50) + 50 * j, 50 * i);
                        Path finalPath = path;
                        future = future.thenComposeAsync(v -> this.genNodeData(finalPath, cache, node));
                    }
                    if (done) continue block1;
                }
            }
            return future;
        }

        private CompletableFuture<?> genNodeData(Path path, class_7403 cache, CompassNode node) {
            if (node.position == null) {
                return CompletableFuture.completedFuture(null);
            }
            String resourcePath = "compass/nodes/" + node.nodeID.method_12832() + ".json";
            if (this.existingHelper.test(GTCEu.id(resourcePath))) {
                return CompletableFuture.completedFuture(null);
            }
            JsonObject json = new JsonObject();
            json.addProperty("section", node.sectionID.toString());
            json.addProperty("page", node.page.toString());
            if (node.icon == null) {
                node.icon = !node.items.isEmpty() ? () -> new ItemStackTexture(new class_1792[]{node.items.get(0).get()}) : () -> IGuiTexture.EMPTY;
            }
            json.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson((IGuiTexture)node.icon.get()));
            if (node.size != 24) {
                json.addProperty("size", (Number)node.size);
            }
            JsonArray pos = new JsonArray();
            pos.add((Number)node.position.x);
            pos.add((Number)node.position.y);
            json.add("position", (JsonElement)pos);
            if (!node.preNodes.isEmpty()) {
                JsonArray pre = new JsonArray();
                for (class_2960 class_29602 : node.preNodes) {
                    pre.add(class_29602.toString());
                }
                json.add("pre_nodes", (JsonElement)pre);
            }
            JsonArray items = new JsonArray();
            if (!node.tags.isEmpty()) {
                for (class_6862 class_68622 : node.tags) {
                    items.add("#" + class_68622.comp_327());
                }
            }
            if (!node.items.isEmpty()) {
                for (Supplier supplier : node.items) {
                    items.add(class_7923.field_41178.method_10221((Object)((class_1792)supplier.get())).toString());
                }
            }
            if (!items.isEmpty()) {
                json.add("items", (JsonElement)items);
            }
            return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)path.resolve(resourcePath));
        }
    }
}

