/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FluidIngredient
implements Predicate<FluidStack> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluidIngredient EMPTY = new FluidIngredient(Stream.empty(), 0L, null);
    public Value[] values;
    @Nullable
    public FluidStack[] stacks;
    private long amount;
    private class_2487 nbt;
    private boolean changed = true;

    public FluidIngredient(Stream<? extends Value> empty, long amount, @Nullable class_2487 nbt) {
        this.values = (Value[])empty.toArray(Value[]::new);
        this.amount = amount;
        this.nbt = nbt;
    }

    public static FluidIngredient fromValues(Stream<? extends Value> stream, long amount, @Nullable class_2487 nbt) {
        FluidIngredient ingredient = new FluidIngredient(stream, amount, nbt);
        return ingredient.isEmpty() ? EMPTY : ingredient;
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_34062(Arrays.asList(this.getStacks()), (buf, stack) -> stack.writeToBuf(buf));
        buffer.method_10791(this.amount);
        buffer.method_10794(this.nbt);
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("amount", (Number)(this.amount * FluidHelper.getBucket() / 1000L));
        if (this.nbt != null) {
            jsonObject.addProperty("nbt", this.nbt.method_10714());
        }
        if (this.values.length == 1) {
            jsonObject.add("value", (JsonElement)this.values[0].serialize());
        }
        JsonArray jsonArray = new JsonArray();
        for (Value value : this.values) {
            jsonArray.add((JsonElement)value.serialize());
        }
        jsonObject.add("value", (JsonElement)jsonArray);
        return jsonObject;
    }

    public FluidIngredient copy() {
        return new FluidIngredient(Arrays.stream(this.values).map(Value::copy), this.amount, this.nbt == null ? null : this.nbt.method_10553());
    }

    @Override
    public boolean test(@Nullable FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return stack.isEmpty();
        }
        if (this.nbt != null && !this.nbt.equals((Object)stack.getTag())) {
            return false;
        }
        for (FluidStack fluidStack : this.getStacks()) {
            if (fluidStack.getFluid() != stack.getFluid()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public FluidStack[] getStacks() {
        if (this.changed || this.stacks == null) {
            this.stacks = (FluidStack[])Arrays.stream(this.values).flatMap(entry -> entry.getStacks().stream()).distinct().map(fluid -> FluidStack.create((class_3611)fluid, (long)this.amount, (class_2487)this.nbt)).toArray(FluidStack[]::new);
            this.changed = false;
        }
        return this.stacks;
    }

    public void setAmount(long amount) {
        this.amount = amount;
        this.changed = true;
    }

    public void setNbt(class_2487 nbt) {
        this.nbt = nbt;
        this.changed = true;
    }

    public static FluidIngredient of() {
        return EMPTY;
    }

    public static FluidIngredient of(long amount, class_3611 ... items) {
        return FluidIngredient.of(Arrays.stream(items), amount, null);
    }

    public static FluidIngredient of(FluidStack ... stacks) {
        return FluidIngredient.of(Arrays.stream(stacks).map(FluidStack::getFluid), stacks.length == 0 ? 0L : stacks[0].getAmount(), stacks.length == 0 ? null : stacks[0].getTag());
    }

    public static FluidIngredient of(Stream<class_3611> stacks, long amount, class_2487 nbt) {
        return FluidIngredient.fromValues(stacks.filter(stack -> stack != null && !stack.method_15780(class_3612.field_15906)).map(FluidValue::new), amount, nbt);
    }

    public static FluidIngredient of(class_6862<class_3611> tag, long amount) {
        return FluidIngredient.fromValues(Stream.of(new TagValue(tag)), amount, null);
    }

    public static FluidIngredient of(class_6862<class_3611> tag, long amount, class_2487 nbt) {
        return FluidIngredient.fromValues(Stream.of(new TagValue(tag)), amount, nbt);
    }

    public static FluidIngredient fromNetwork(class_2540 buffer) {
        return FluidIngredient.fromValues(buffer.method_34066(FluidStack::readFromBuf).stream().map(stack -> new FluidValue(stack.getFluid())), buffer.method_10792(), buffer.method_10798());
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json) {
        return FluidIngredient.fromJson(json, true);
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json, boolean allowAir) {
        class_2487 nbt;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Fluid ingredient cannot be null");
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected fluid ingredient to be object");
        }
        JsonObject jsonObject = class_3518.method_15295((JsonElement)json, (String)"ingredient");
        long amount = class_3518.method_15280((JsonObject)jsonObject, (String)"amount", (long)0L);
        class_2487 class_24872 = nbt = jsonObject.has("nbt") ? FluidIngredient.getNBT(jsonObject.get("nbt")) : null;
        if (class_3518.method_34923((JsonObject)jsonObject, (String)"value")) {
            return FluidIngredient.fromValues(Stream.of(FluidIngredient.valueFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"value"))), amount, nbt);
        }
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"value")) {
            JsonArray jsonArray = class_3518.method_15261((JsonObject)jsonObject, (String)"value");
            if (jsonArray.size() == 0 && !allowAir) {
                throw new JsonSyntaxException("Fluid array cannot be empty, at least one item must be defined");
            }
            return FluidIngredient.fromValues(StreamSupport.stream(jsonArray.spliterator(), false).map(jsonElement -> FluidIngredient.valueFromJson(class_3518.method_15295((JsonElement)jsonElement, (String)"fluid"))), amount, nbt);
        }
        throw new JsonSyntaxException("expected value to be either object or array.");
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("fluid") && json.has("tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a tag or a fluid, not both");
        }
        if (json.has("fluid")) {
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"fluid")));
            return new FluidValue(fluid);
        }
        if (json.has("tag")) {
            class_2960 resourceLocation = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)resourceLocation);
            return new TagValue((class_6862<class_3611>)tagKey);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a tag or a fluid");
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e);
        }
    }

    public long getAmount() {
        return this.amount;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public static interface Value {
        public Collection<class_3611> getStacks();

        public JsonObject serialize();

        public Value copy();
    }

    public static class TagValue
    implements Value {
        private final class_6862<class_3611> tag;

        public TagValue(class_6862<class_3611> tag) {
            this.tag = tag;
        }

        @Override
        public Collection<class_3611> getStacks() {
            ArrayList list = Lists.newArrayList();
            for (class_6880 holder : class_7923.field_41173.method_40286(this.tag)) {
                list.add((class_3611)holder.comp_349());
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tag.comp_327().toString());
            return jsonObject;
        }

        @Override
        public Value copy() {
            return new TagValue(this.tag);
        }
    }

    public static class FluidValue
    implements Value {
        private final class_3611 fluid;

        public FluidValue(class_3611 item) {
            this.fluid = item;
        }

        @Override
        public Collection<class_3611> getStacks() {
            return Collections.singleton(this.fluid);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("fluid", class_7923.field_41173.method_10221((Object)this.fluid).toString());
            return jsonObject;
        }

        @Override
        public Value copy() {
            return new FluidValue(this.fluid);
        }
    }
}

