/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class Content {
    public Object content;
    public float chance;
    public float tierChanceBoost;
    @Nullable
    public String slotName;
    @Nullable
    public String uiName;

    public Content(Object content, float chance, float tierChanceBoost, @Nullable String slotName, @Nullable String uiName) {
        this.content = content;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.slotName = slotName;
        this.uiName = uiName;
    }

    public Content copy(RecipeCapability<?> capability, @Nullable ContentModifier modifier) {
        if (modifier == null || this.chance == 0.0f) {
            return new Content(capability.copyContent(this.content), this.chance, this.tierChanceBoost, this.slotName, this.uiName);
        }
        return new Content(capability.copyContent(this.content, modifier), this.chance, this.tierChanceBoost, this.slotName, this.uiName);
    }

    public IGuiTexture createOverlay(final boolean perTick) {
        return new IGuiTexture(){

            @Environment(value=EnvType.CLIENT)
            public void draw(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
                Content.this.drawChance(graphics, x, y, width, height);
                if (perTick) {
                    Content.this.drawTick(graphics, x, y, width, height);
                }
            }
        };
    }

    @Environment(value=EnvType.CLIENT)
    public void drawChance(class_332 graphics, float x, float y, int width, int height) {
        if (this.chance == 1.0f) {
            return;
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        String s = this.chance == 0.0f ? LocalizationUtils.format((String)"gtceu.gui.content.chance_0_short", (Object[])new Object[0]) : String.format("%.1f", Float.valueOf(this.chance * 100.0f)) + "%";
        int color = this.chance == 0.0f ? 0xFF0000 : 0xFFFF00;
        class_327 fontRenderer = class_310.method_1551().field_1772;
        graphics.method_51433(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.method_1727(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height), color, true);
        graphics.method_51448().method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public void drawTick(class_332 graphics, float x, float y, int width, int height) {
        graphics.method_51448().method_22903();
        RenderSystem.disableDepthTest();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        String s = LocalizationUtils.format((String)"gtceu.gui.content.tips.per_tick_short", (Object[])new Object[0]);
        int color = 0xFFFF00;
        class_327 fontRenderer = class_310.method_1551().field_1772;
        graphics.method_25303(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.method_1727(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height + (float)(this.chance == 1.0f ? 0 : 10)), color);
        graphics.method_51448().method_22909();
    }

    public Object getContent() {
        return this.content;
    }
}

