/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;

public abstract class RecipeCondition {
    protected boolean isReverse;

    @Nullable
    public static RecipeCondition create(Class<? extends RecipeCondition> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ignored) {
            GTCEu.LOGGER.error("condition {} has no NonArgsConstructor", clazz);
            return null;
        }
    }

    public abstract String getType();

    public String getTranslationKey() {
        return "gtceu.recipe.condition." + this.getType();
    }

    public IGuiTexture getInValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + this.getType() + ".png").getSubTexture(0.0f, 0.0f, 1.0f, 0.5f);
    }

    public IGuiTexture getValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + this.getType() + ".png").getSubTexture(0.0f, 0.5f, 1.0f, 0.5f);
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public boolean isOr() {
        return false;
    }

    public RecipeCondition setReverse(boolean reverse) {
        this.isReverse = reverse;
        return this;
    }

    public abstract class_2561 getTooltips();

    public abstract boolean test(@Nonnull GTRecipe var1, @Nonnull RecipeLogic var2);

    public abstract RecipeCondition createTemplate();

    @Nonnull
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        if (this.isReverse) {
            jsonObject.addProperty("reverse", Boolean.valueOf(true));
        }
        return jsonObject;
    }

    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        this.isReverse = class_3518.method_15258((JsonObject)config, (String)"reverse", (boolean)false);
        return this;
    }

    public void toNetwork(class_2540 buf) {
        buf.writeBoolean(this.isReverse);
    }

    public RecipeCondition fromNetwork(class_2540 buf) {
        this.isReverse = buf.readBoolean();
        return this;
    }
}

