/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeBlock;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class NetworkBuilder
implements Runnable {
    private final LinkedList<class_2338> starts = new LinkedList();
    private final LongDistanceNetwork.WorldData worldData;
    private LongDistanceNetwork network;
    private final class_1936 world;
    private final LinkedList<class_2338> currentPoints = new LinkedList();
    private final ObjectOpenHashSet<class_2338> walked = new ObjectOpenHashSet();
    private final List<class_2338> pipes = new ArrayList<class_2338>();
    private final List<ILDEndpoint> endpoints = new ArrayList<ILDEndpoint>();

    public NetworkBuilder(LongDistanceNetwork.WorldData worldData, LongDistanceNetwork network, class_2338 start) {
        this.worldData = worldData;
        this.network = network;
        this.world = worldData.getWorld();
        this.starts.add(start);
    }

    public NetworkBuilder(LongDistanceNetwork.WorldData worldData, LongDistanceNetwork network, Collection<class_2338> starts) {
        this.worldData = worldData;
        this.network = network;
        this.world = worldData.getWorld();
        this.starts.addAll(starts);
    }

    @Override
    public void run() {
        boolean first = true;
        while (!this.starts.isEmpty()) {
            class_2338 start = this.starts.pollFirst();
            if (first) {
                first = false;
                this.checkNetwork(start);
                continue;
            }
            LongDistanceNetwork ldn = this.worldData.getNetwork(start);
            if (ldn != null) continue;
            this.network = this.network.getPipeType().createNetwork(this.worldData);
            this.currentPoints.clear();
            this.walked.clear();
            this.pipes.clear();
            this.endpoints.clear();
            this.checkNetwork(start);
        }
    }

    private void checkNetwork(class_2338 start) {
        this.currentPoints.add(start);
        this.checkPos(this.world.method_8320(start), start);
        class_2338.class_2339 pos = new class_2338.class_2339();
        while (!this.currentPoints.isEmpty()) {
            class_2338 current = this.currentPoints.pollFirst();
            for (class_2350 facing : class_2350.values()) {
                class_2680 blockState;
                pos.method_10101((class_2382)current).method_10098(facing);
                if (this.walked.contains((Object)pos) || (blockState = this.world.method_8320((class_2338)pos)).method_26215()) continue;
                this.checkPos(blockState, (class_2338)pos);
            }
        }
        this.network.setData(this.pipes, this.endpoints);
    }

    private void checkPos(class_2680 blockState, class_2338 pos) {
        class_2338 bp = pos.method_10062();
        if (blockState.method_26204() instanceof LongDistancePipeBlock && this.network.getPipeType().isValidBlock(blockState)) {
            this.pipes.add(bp);
            this.currentPoints.addLast(bp);
        } else {
            ILDEndpoint endpoint = ILDEndpoint.tryGet(this.world, pos);
            if (endpoint != null && this.network.getPipeType().isValidEndpoint(endpoint)) {
                this.pipes.add(bp);
                this.endpoints.add(endpoint);
            }
        }
        this.walked.add((Object)bp);
    }
}

