/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemPipeType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public abstract class LongDistancePipeType {
    private static final Object2ObjectOpenHashMap<String, LongDistancePipeType> PIPE_TYPES = new Object2ObjectOpenHashMap();
    private static LDFluidPipeType FLUID;
    private static LDItemPipeType ITEM;
    private final String name;

    protected LongDistancePipeType(String name) {
        this.name = Objects.requireNonNull(name);
        if (PIPE_TYPES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Pipe Type with name " + name + " already exists!");
        }
        for (LongDistancePipeType pipeType : PIPE_TYPES.values()) {
            if (this.getClass() != pipeType.getClass()) continue;
            throw new IllegalStateException("Duplicate Pipe Type " + name + " and " + pipeType.name);
        }
        PIPE_TYPES.put((Object)name, (Object)this);
    }

    public static void init() {
        FLUID = LDFluidPipeType.INSTANCE;
        ITEM = LDItemPipeType.INSTANCE;
    }

    public static LDFluidPipeType fluid() {
        return FLUID;
    }

    public static LDItemPipeType item() {
        return ITEM;
    }

    public static LongDistancePipeType getPipeType(String name) {
        return (LongDistancePipeType)PIPE_TYPES.get((Object)name);
    }

    public abstract boolean isValidBlock(class_2680 var1);

    public abstract boolean isValidEndpoint(ILDEndpoint var1);

    public int getMinLength() {
        return 0;
    }

    public boolean satisfiesMinLength(ILDEndpoint endpoint1, ILDEndpoint endpoint2) {
        class_2338 p = endpoint2.getPos();
        int minLength = this.getMinLength();
        return endpoint1 != endpoint2 && endpoint1.getPos().method_10262((class_2382)p) >= (double)(minLength * minLength);
    }

    @Nonnull
    public LongDistanceNetwork createNetwork(LongDistanceNetwork.WorldData worldData) {
        return new LongDistanceNetwork(this, worldData);
    }

    public final LongDistanceNetwork createNetwork(class_1937 world) {
        return this.createNetwork(LongDistanceNetwork.WorldData.get((class_1936)world));
    }

    public final String getName() {
        return this.name;
    }
}

