/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern.predicates;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.error.SinglePredicateError;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;

public class SimplePredicate {
    public static SimplePredicate ANY = new SimplePredicate("any", x -> true, null);
    public static SimplePredicate AIR = new SimplePredicate("air", blockWorldState -> blockWorldState.getWorld().method_22347(blockWorldState.getPos()), null);
    @Nullable
    public Supplier<BlockInfo[]> candidates;
    public Predicate<MultiblockState> predicate;
    public List<class_2561> toolTips;
    public int minCount = -1;
    public int maxCount = -1;
    public int minLayerCount = -1;
    public int maxLayerCount = -1;
    public int previewCount = -1;
    public boolean disableRenderFormed = false;
    public IO io = IO.BOTH;
    public String slotName;
    public String nbtParser;
    public final String type;

    public SimplePredicate() {
        this("unknown");
    }

    public SimplePredicate(String type) {
        this.type = type;
    }

    public SimplePredicate(Predicate<MultiblockState> predicate, @Nullable Supplier<BlockInfo[]> candidates) {
        this();
        this.predicate = predicate;
        this.candidates = candidates;
    }

    public SimplePredicate(String type, Predicate<MultiblockState> predicate, @Nullable Supplier<BlockInfo[]> candidates) {
        this(type);
        this.predicate = predicate;
        this.candidates = candidates;
    }

    public SimplePredicate buildPredicate() {
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getToolTips(TraceabilityPredicate predicates) {
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        if (this.toolTips != null) {
            result.addAll(this.toolTips);
        }
        if (this.minCount == this.maxCount && this.maxCount != -1) {
            result.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.pattern.error.limited_exact", (Object[])new Object[]{this.minCount}));
        } else if (this.minCount != this.maxCount && this.minCount != -1 && this.maxCount != -1) {
            result.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.pattern.error.limited_within", (Object[])new Object[]{this.minCount, this.maxCount}));
        } else {
            if (this.minCount != -1) {
                result.add((class_2561)LangHandler.getFromMultiLang("gtceu.multiblock.pattern.error.limited", 1, this.minCount));
            }
            if (this.maxCount != -1) {
                result.add((class_2561)LangHandler.getFromMultiLang("gtceu.multiblock.pattern.error.limited", 0, this.maxCount));
            }
        }
        if (predicates == null) {
            return result;
        }
        if (predicates.isSingle()) {
            result.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.pattern.single"));
        }
        if (predicates.hasAir()) {
            result.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.pattern.replaceable_air"));
        }
        return result;
    }

    public boolean test(MultiblockState blockWorldState) {
        if (this.predicate.test(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    public boolean testLimited(MultiblockState blockWorldState) {
        if (this.testGlobal(blockWorldState) && this.testLayer(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    private boolean checkInnerConditions(MultiblockState blockWorldState) {
        if (this.disableRenderFormed) {
            blockWorldState.getMatchContext().getOrCreate("renderMask", LongOpenHashSet::new).add(blockWorldState.getPos().method_10063());
        }
        if (this.io != IO.BOTH) {
            if (blockWorldState.io == IO.BOTH) {
                blockWorldState.io = this.io;
            } else if (blockWorldState.io != this.io) {
                blockWorldState.io = null;
            }
        }
        if (this.nbtParser != null && !blockWorldState.world.field_9236) {
            class_2586 te = blockWorldState.getTileEntity();
            if (te != null) {
                class_2487 nbt = te.method_38242();
                if (Pattern.compile(this.nbtParser).matcher(nbt.toString()).find()) {
                    return true;
                }
            }
            blockWorldState.setError(new PatternStringError("The NBT fails to match"));
            return false;
        }
        if (this.slotName != null) {
            Map slots = (Map)blockWorldState.getMatchContext().getOrCreate("slots", Long2ObjectArrayMap::new);
            slots.computeIfAbsent(blockWorldState.getPos().method_10063(), s -> new HashSet()).add(this.slotName);
            return true;
        }
        return true;
    }

    public boolean testGlobal(MultiblockState blockWorldState) {
        if (this.minCount == -1 && this.maxCount == -1) {
            return true;
        }
        Integer count = blockWorldState.getGlobalCount().get(this);
        boolean base = this.predicate.test(blockWorldState);
        count = (count == null ? 0 : count) + (base ? 1 : 0);
        blockWorldState.getGlobalCount().put(this, count);
        if (this.maxCount == -1 || count <= this.maxCount) {
            return base;
        }
        blockWorldState.setError(new SinglePredicateError(this, 0));
        return false;
    }

    public boolean testLayer(MultiblockState blockWorldState) {
        if (this.minLayerCount == -1 && this.maxLayerCount == -1) {
            return true;
        }
        Integer count = blockWorldState.getLayerCount().get(this);
        boolean base = this.predicate.test(blockWorldState);
        count = (count == null ? 0 : count) + (base ? 1 : 0);
        blockWorldState.getLayerCount().put(this, count);
        if (this.maxLayerCount == -1 || count <= this.maxLayerCount) {
            return base;
        }
        blockWorldState.setError(new SinglePredicateError(this, 2));
        return false;
    }

    public List<class_1799> getCandidates() {
        if (LDLib.isClient()) {
            return this.candidates == null ? Collections.emptyList() : Arrays.stream(this.candidates.get()).filter(info -> info.getBlockState().method_26204() != class_2246.field_10124).map(blockInfo -> blockInfo.getItemStackForm((class_1920)class_310.method_1551().field_1687, class_2338.field_10980)).collect(Collectors.toList());
        }
        return this.candidates == null ? Collections.emptyList() : Arrays.stream(this.candidates.get()).filter(info -> info.getBlockState().method_26204() != class_2246.field_10124).map(BlockInfo::getItemStackForm).collect(Collectors.toList());
    }
}

