/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class MultiblockWorldSavedData
extends class_18 {
    private final class_3218 serverLevel;
    public final Map<class_2338, MultiblockState> mapping;
    public final Map<class_1923, Set<MultiblockState>> chunkPosMapping;
    private final CopyOnWriteArrayList<IMultiController> controllers = new CopyOnWriteArrayList();
    private ScheduledExecutorService executorService;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("GTCEu Multiblock Async Thread-%d").setDaemon(true).build();
    private static final ThreadLocal<Boolean> IN_SERVICE = ThreadLocal.withInitial(() -> false);
    private long periodID = Long.MIN_VALUE;

    public static MultiblockWorldSavedData getOrCreate(class_3218 serverLevel) {
        return (MultiblockWorldSavedData)serverLevel.method_17983().method_17924(tag -> new MultiblockWorldSavedData(serverLevel, (class_2487)tag), () -> new MultiblockWorldSavedData(serverLevel), "gtceu_multiblock");
    }

    private MultiblockWorldSavedData(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
        this.mapping = new Object2ObjectOpenHashMap();
        this.chunkPosMapping = new HashMap<class_1923, Set<MultiblockState>>();
    }

    private MultiblockWorldSavedData(class_3218 serverLevel, class_2487 tag) {
        this(serverLevel);
    }

    public MultiblockState[] getControllerInChunk(class_1923 chunkPos) {
        return (MultiblockState[])this.chunkPosMapping.getOrDefault(chunkPos, Collections.emptySet()).toArray(MultiblockState[]::new);
    }

    public void addMapping(MultiblockState state) {
        this.mapping.put(state.controllerPos, state);
        for (class_2338 blockPos : state.getCache()) {
            this.chunkPosMapping.computeIfAbsent(new class_1923(blockPos), c -> new HashSet()).add(state);
        }
        this.method_78(true);
    }

    public void removeMapping(MultiblockState state) {
        this.mapping.remove(state.controllerPos);
        for (Set<MultiblockState> set : this.chunkPosMapping.values()) {
            set.remove(state);
        }
        this.method_78(true);
    }

    @Nonnull
    public class_2487 method_75(@Nonnull class_2487 compound) {
        return compound;
    }

    public void createExecutorService() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            return;
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
        this.executorService.scheduleAtFixedRate(this::searchingTask, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public void addAsyncLogic(IMultiController controller) {
        this.controllers.add(controller);
        this.createExecutorService();
    }

    public void removeAsyncLogic(IMultiController controller) {
        if (this.controllers.contains(controller)) {
            this.controllers.remove(controller);
            if (this.controllers.isEmpty()) {
                this.releaseExecutorService();
            }
        }
    }

    private void searchingTask() {
        try {
            IN_SERVICE.set(true);
            for (IMultiController controller : this.controllers) {
                controller.asyncCheckPattern(this.periodID);
            }
        }
        catch (Throwable e) {
            GTCEu.LOGGER.error("asyncThreadLogic error: {}", (Object)e.getMessage());
        }
        finally {
            IN_SERVICE.set(false);
        }
        ++this.periodID;
    }

    public static boolean isThreadService() {
        return IN_SERVICE.get();
    }

    public void releaseExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
    }

    public long getPeriodID() {
        return this.periodID;
    }
}

