/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.fabric;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidHelperImpl;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.jetbrains.annotations.ApiStatus;

public class FluidCellStorage
extends SingleVariantItemStorage<FluidVariant> {
    private final long capacity;
    private final boolean allowPartialFill;
    private final int maxFluidTemperature;
    private final boolean gasProof;
    private final boolean acidProof;
    private final boolean cryoProof;
    private final boolean plasmaProof;

    public FluidCellStorage(ContainerItemContext context, long capacity, boolean allowPartialFill, int maxFluidTemperature, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        super(context);
        this.capacity = capacity;
        this.allowPartialFill = allowPartialFill;
        this.maxFluidTemperature = maxFluidTemperature;
        this.gasProof = gasProof;
        this.acidProof = acidProof;
        this.cryoProof = cryoProof;
        this.plasmaProof = plasmaProof;
    }

    @ApiStatus.Internal
    public FluidVariant getBlankResource() {
        return FluidVariant.blank();
    }

    @ApiStatus.Internal
    public FluidVariant getResource(ItemVariant currentVariant) {
        return FluidHelperImpl.toFluidVariant((FluidStack)this.getFluidStack(currentVariant));
    }

    @ApiStatus.Internal
    public long getAmount(ItemVariant currentVariant) {
        return this.getFluidStack(currentVariant).getAmount();
    }

    @ApiStatus.Internal
    public long getCapacity(FluidVariant variant) {
        return this.capacity;
    }

    @ApiStatus.Internal
    public ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
        class_2487 newNbt = currentVariant.copyOrCreateNbt();
        if (newResource.isBlank() || newAmount == 0L) {
            newNbt.method_10551("Fluid");
            if (newNbt.method_33133()) {
                newNbt = null;
            }
        } else {
            class_2487 nbtFluid = FluidStack.create((class_3611)newResource.getFluid(), (long)newAmount, (class_2487)newResource.getNbt()).saveToTag(new class_2487());
            newNbt.method_10566("Fluid", (class_2520)nbtFluid);
        }
        return ItemVariant.of((class_1935)currentVariant.getItem(), (class_2487)newNbt);
    }

    @ApiStatus.Internal
    public boolean canInsert(FluidVariant resource) {
        int temperature = FluidVariantAttributes.getTemperature((FluidVariant)resource);
        return !(temperature > this.getMaxFluidTemperature() || temperature < 120 && !this.isCryoProof() || FluidVariantAttributes.isLighterThanAir((FluidVariant)resource) && !this.isGasProof());
    }

    @ApiStatus.Internal
    public boolean canExtract(FluidVariant resource) {
        return true;
    }

    public long insert(FluidVariant insertedResource, long maxAmount, TransactionContext transaction) {
        if (!this.canInsert(insertedResource)) {
            return 0L;
        }
        if (!this.isAllowPartialFill()) {
            maxAmount = maxAmount < this.getCapacity(insertedResource) ? 0L : this.getCapacity(insertedResource);
        }
        return super.insert((TransferVariant)insertedResource, maxAmount, transaction);
    }

    public long extract(FluidVariant extractedResource, long maxAmount, TransactionContext transaction) {
        if (!this.canExtract(extractedResource)) {
            return 0L;
        }
        if (!this.isAllowPartialFill()) {
            maxAmount = maxAmount < this.getAmount() ? 0L : this.getAmount();
        }
        return super.extract((TransferVariant)extractedResource, maxAmount, transaction);
    }

    public FluidStack getFluidStack(ItemVariant currentVariant) {
        class_2487 root = currentVariant.getNbt();
        if (root == null) {
            return FluidStack.empty();
        }
        return FluidStack.loadFromTag((class_2487)root.method_10562("Fluid"));
    }

    public boolean isAllowPartialFill() {
        return this.allowPartialFill;
    }

    public int getMaxFluidTemperature() {
        return this.maxFluidTemperature;
    }

    public boolean isGasProof() {
        return this.gasProof;
    }

    public boolean isAcidProof() {
        return this.acidProof;
    }

    public boolean isCryoProof() {
        return this.cryoProof;
    }

    public boolean isPlasmaProof() {
        return this.plasmaProof;
    }
}

