/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamWorkableMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public abstract class SteamBoilerMachine
extends SteamWorkableMachine
implements IUIMachine,
IExplosionMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SteamBoilerMachine.class, SteamWorkableMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableFluidTank waterTank;
    @Persisted
    @DescSynced
    private int currentTemperature;
    @Persisted
    private int timeBeforeCoolingDown;
    private boolean hasNoWater;
    @Nullable
    protected TickableSubscription temperatureSubs;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription steamTankSubs;

    public SteamBoilerMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.waterTank = this.createWaterTank(args);
        this.waterTank.setFilter(fluid -> class_3612.field_15910 == fluid.getFluid());
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableFluidTank createSteamTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.OUT);
    }

    protected NotifiableFluidTank createWaterTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.IN);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
        }
        this.updateSteamSubscription();
        this.steamTankSubs = this.steamTank.addChangedListener(this::updateAutoOutputSubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.steamTankSubs != null) {
            this.steamTankSubs.unsubscribe();
            this.steamTankSubs = null;
        }
    }

    @Override
    public void setOutputFacing(@NotNull class_2350 outputFacing) {
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        if (class_2350.method_42013().filter(direction -> direction != this.getFrontFacing() && direction != class_2350.field_11033).anyMatch(direction -> FluidTransferHelper.getFluidTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(direction), (class_2350)direction.method_10153()) != null)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.steamTank.exportToNearby((class_2350[])class_2350.method_42013().filter(direction -> direction != this.getFrontFacing() && direction != class_2350.field_11033).filter(direction -> FluidTransferHelper.getFluidTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(direction), (class_2350)direction.method_10153()) != null).toArray(class_2350[]::new));
            this.updateAutoOutputSubscription();
        }
    }

    protected void updateSteamSubscription() {
        if (this.currentTemperature > 0) {
            this.temperatureSubs = this.subscribeServerTick(this.temperatureSubs, this::updateCurrentTemperature);
        } else if (this.temperatureSubs != null) {
            this.temperatureSubs.unsubscribe();
            this.temperatureSubs = null;
        }
    }

    protected void updateCurrentTemperature() {
        if (this.recipeLogic.isWorking()) {
            if (this.getOffsetTimer() % 12L == 0L && this.currentTemperature < this.getMaxTemperature()) {
                if (this.isHighPressure) {
                    ++this.currentTemperature;
                } else if (this.getOffsetTimer() % 24L == 0L) {
                    ++this.currentTemperature;
                }
            }
        } else if (this.timeBeforeCoolingDown == 0) {
            if (this.currentTemperature > 0) {
                this.currentTemperature -= this.getCoolDownRate();
                this.timeBeforeCoolingDown = this.getCooldownInterval();
            }
        } else {
            --this.timeBeforeCoolingDown;
        }
        if (this.getOffsetTimer() % 10L == 0L) {
            if (this.currentTemperature >= 100) {
                class_1937 class_19372;
                long fillAmount = (long)((double)this.getBaseSteamOutput() * ((double)this.currentTemperature / ((double)this.getMaxTemperature() * 1.0)) / 2.0);
                boolean hasDrainedWater = !this.waterTank.drainInternal(FluidHelper.getBucket() / 1000L, false).isEmpty();
                long filledSteam = 0L;
                if (hasDrainedWater) {
                    filledSteam = this.steamTank.fillInternal(GTMaterials.Steam.getFluid(fillAmount * FluidHelper.getBucket() / 1000L), false);
                }
                if (this.hasNoWater && hasDrainedWater) {
                    this.doExplosion(2.0f);
                } else {
                    boolean bl = this.hasNoWater = !hasDrainedWater;
                }
                if (filledSteam == 0L && hasDrainedWater && (class_19372 = this.getLevel()) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    float x = (float)this.getPos().method_10263() + 0.5f;
                    float y = (float)this.getPos().method_10264() + 0.5f;
                    float z = (float)this.getPos().method_10260() + 0.5f;
                    serverLevel.method_14199((class_2394)class_2398.field_11204, (double)x + (double)this.getFrontFacing().method_10148() * 0.6, (double)y + (double)this.getFrontFacing().method_10164() * 0.6, (double)z + (double)this.getFrontFacing().method_10165() * 0.6, 7 + GTValues.RNG.method_43048(3), (double)this.getFrontFacing().method_10148() / 2.0, (double)this.getFrontFacing().method_10164() / 2.0, (double)this.getFrontFacing().method_10165() / 2.0, 0.1);
                    if (ConfigHolder.INSTANCE.machines.machineSounds) {
                        this.getLevel().method_43128(null, (double)x, (double)y, (double)z, class_3417.field_19198, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    this.steamTank.drainInternal(FluidHelper.getBucket() * 4L, false);
                }
            } else {
                this.hasNoWater = false;
            }
        }
        this.updateSteamSubscription();
    }

    protected int getCooldownInterval() {
        return this.isHighPressure ? 40 : 45;
    }

    protected int getCoolDownRate() {
        return 1;
    }

    public int getMaxTemperature() {
        return this.isHighPressure ? 1000 : 500;
    }

    private double getTemperaturePercent() {
        return (double)this.currentTemperature / ((double)this.getMaxTemperature() * 1.0);
    }

    protected abstract long getBaseSteamOutput();

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof SteamBoilerMachine) {
            SteamBoilerMachine boilerMachine = (SteamBoilerMachine)machine;
            recipe = recipe.copy();
            recipe.duration = boilerMachine.isHighPressure ? recipe.duration / 2 : recipe.duration;
            return recipe;
        }
        return null;
    }

    @Override
    public void onWorking() {
        if (this.currentTemperature < this.getMaxTemperature()) {
            this.currentTemperature = Math.max(1, this.currentTemperature);
            this.updateSteamSubscription();
        }
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        this.timeBeforeCoolingDown = this.getCooldownInterval();
    }

    @Override
    protected class_1269 onSoftMalletClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        return class_1269.field_5811;
    }

    public ModularUI createUI(class_1657 entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(this.isHighPressure)}).widget((Widget)new LabelWidget(6, 6, this.getBlockState().method_26204().method_9539())).widget((Widget)new ProgressWidget(this::getTemperaturePercent, 96, 26, 10, 54).setProgressTexture((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure), (IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_HEAT).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setDynamicHoverTips(pct -> class_1074.method_4662((String)"gtceu.multiblock.large_boiler.temperature", (Object[])new Object[]{(int)((double)this.currentTemperature + 274.15), (int)((double)this.getMaxTemperature() + 274.15)}))).widget((Widget)new TankWidget((IFluidStorage)this.waterTank.storages[0], 83, 26, 10, 54, false, true).setShowAmount(false).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setBackground((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).widget((Widget)new TankWidget((IFluidStorage)this.steamTank.storages[0], 70, 26, 10, 54, true, false).setShowAmount(false).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setBackground((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).widget((Widget)new ImageWidget(43, 44, 18, 18, (IGuiTexture)GuiTextures.CANISTER_OVERLAY_STEAM.get(this.isHighPressure))).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.method_31548(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(this.isHighPressure), 7, 84, true));
    }

    @Override
    public void animateTick(class_5819 random) {
        if (this.isActive()) {
            class_2338 pos = this.getPos();
            float x = (float)pos.method_10263() + 0.5f;
            float z = (float)pos.method_10260() + 0.5f;
            class_2350 facing = this.getFrontFacing();
            float horizontalOffset = random.method_43057() * 0.6f - 0.3f;
            float y = (float)pos.method_10264() + random.method_43057() * 0.375f;
            if (facing.method_10166() == class_2350.class_2351.field_11048) {
                x = facing.method_10171() == class_2350.class_2352.field_11056 ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.method_10166() == class_2350.class_2351.field_11051) {
                z = facing.method_10171() == class_2350.class_2352.field_11056 ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            this.randomDisplayTick(random, x, y, z);
        }
    }

    protected void randomDisplayTick(class_5819 random, float x, float y, float z) {
        this.getLevel().method_8406((class_2394)(this.isHighPressure ? class_2398.field_11237 : class_2398.field_11251), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        this.getLevel().method_8406((class_2394)class_2398.field_11240, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
    }

    public boolean isHasNoWater() {
        return this.hasNoWater;
    }
}

