/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class TieredWorkableElectricMultiblockMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine,
IOverclockMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(TieredWorkableElectricMultiblockMachine.class, WorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    private final int tier;
    @Persisted
    protected int overclockTier;

    public TieredWorkableElectricMultiblockMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, args);
        this.tier = tier;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public int getMinOverclockTier() {
        return 0;
    }

    @Override
    public void setOverclockTier(int tier) {
        if (!this.isRemote() && tier >= this.getMinOverclockTier() && tier <= this.getMaxOverclockTier()) {
            this.overclockTier = tier;
            this.recipeLogic.markLastRecipeDirty();
        }
    }

    @Override
    public long getOverclockVoltage() {
        return Math.min(GTValues.V[this.getOverclockTier()], super.getOverclockVoltage());
    }

    @Override
    public int getTier() {
        return Math.min(this.tier, super.getTier());
    }

    @Override
    public long getMaxVoltage() {
        return Math.min(GTValues.V[this.tier], super.getMaxVoltage());
    }

    @Override
    public int getOverclockTier() {
        return this.overclockTier;
    }
}

