/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;

public interface IRotorHolderMachine
extends IMultiPart {
    public static final int SPEED_INCREMENT = 1;
    public static final int SPEED_DECREMENT = 3;

    public static int getBaseEfficiency() {
        return 100;
    }

    public class_1799 getRotorStack();

    public void setRotorStack(class_1799 var1);

    public int getRotorSpeed();

    public void setRotorSpeed(int var1);

    public int getMaxRotorHolderSpeed();

    public int getTierDifference();

    default public int getHolderEfficiency() {
        int tierDifference = this.getTierDifference();
        if (tierDifference == -1) {
            return -1;
        }
        return 100 + 10 * tierDifference;
    }

    default public int getHolderPowerMultiplier() {
        int tierDifference = this.getTierDifference();
        if (tierDifference == -1) {
            return -1;
        }
        return (int)Math.pow(2.0, this.getTierDifference());
    }

    default public boolean hasRotor() {
        return TurbineRotorBehaviour.getBehaviour(this.getRotorStack()) != null;
    }

    default public int getRotorEfficiency() {
        class_1799 stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            return behavior.getRotorEfficiency(stack);
        }
        return -1;
    }

    default public int getRotorPower() {
        class_1799 stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            return behavior.getRotorPower(stack);
        }
        return -1;
    }

    default public int getRotorDurabilityPercent() {
        class_1799 stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            return behavior.getRotorDurabilityPercent(stack);
        }
        return -1;
    }

    default public void damageRotor(int damageAmount) {
        class_1799 stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            behavior.setPartDamage(stack, damageAmount);
            this.setRotorStack(stack);
        }
    }

    default public boolean isFrontFaceFree() {
        class_2350 facing = this.self().getFrontFacing();
        boolean permuteXZ = facing.method_10166() == class_2350.class_2351.field_11051;
        class_2338 centerPos = this.self().getPos().method_10093(facing);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                class_2338 blockPos = centerPos.method_10069(permuteXZ ? x : 0, y, permuteXZ ? 0 : x);
                class_2680 blockState = this.self().getLevel().method_8320(blockPos);
                if (blockState.method_26215()) continue;
                return false;
            }
        }
        return true;
    }

    default public int getTotalEfficiency() {
        int rotorEfficiency = this.getRotorEfficiency();
        if (rotorEfficiency == -1) {
            return -1;
        }
        int holderEfficiency = this.getHolderEfficiency();
        if (holderEfficiency == -1) {
            return -1;
        }
        return Math.max(IRotorHolderMachine.getBaseEfficiency(), rotorEfficiency * holderEfficiency / 100);
    }

    default public int getTotalPower() {
        return this.getHolderPowerMultiplier() * this.getRotorPower();
    }

    default public boolean isRotorSpinning() {
        return this.getRotorSpeed() > 0;
    }

    @Override
    default public GTRecipe modifyRecipe(GTRecipe recipe) {
        if (!this.isFrontFaceFree() || !this.hasRotor()) {
            return null;
        }
        return IMultiPart.super.modifyRecipe(recipe);
    }

    @Override
    default public void attachFancyTooltipsToController(IMultiController controller, TooltipsPanel tooltipsPanel) {
        this.attachTooltips(tooltipsPanel);
    }

    @Override
    default public void attachTooltips(TooltipsPanel tooltipsPanel) {
        tooltipsPanel.attachTooltips(new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(class_2561.method_43471((String)"gtceu.multiblock.universal.muffler_obstructed").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))), () -> !this.isFrontFaceFree(), () -> null));
    }
}

