/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public interface IMultiController
extends IMachineFeature {
    @Override
    default public MultiblockControllerMachine self() {
        return (MultiblockControllerMachine)this;
    }

    default public boolean checkPattern() {
        BlockPattern pattern = this.getPattern();
        return pattern != null && pattern.checkPatternAt(this.getMultiblockState(), false);
    }

    default public boolean checkPatternWithLock() {
        Lock lock = this.getPatternLock();
        lock.lock();
        boolean result = this.checkPattern();
        lock.unlock();
        return result;
    }

    default public boolean checkPatternWithTryLock() {
        Lock lock = this.getPatternLock();
        if (lock.tryLock()) {
            boolean result = this.checkPattern();
            lock.unlock();
            return result;
        }
        return false;
    }

    default public BlockPattern getPattern() {
        return this.self().getDefinition().getPatternFactory().get();
    }

    public boolean isFormed();

    @Nonnull
    public MultiblockState getMultiblockState();

    public void asyncCheckPattern(long var1);

    public void onStructureFormed();

    public void onStructureInvalid();

    public boolean hasFrontFacing();

    public List<IMultiPart> getParts();

    public void onPartUnload();

    public Lock getPatternLock();

    default public boolean shouldAddPartToController(IMultiPart part) {
        return true;
    }

    @Nullable
    default public class_2680 getPartAppearance(IMultiPart part, class_2350 side, class_2680 sourceState, class_2338 sourcePos) {
        if (this.isFormed()) {
            return (class_2680)this.self().getDefinition().getPartAppearance().apply((Object)this, (Object)part, (Object)side);
        }
        return null;
    }
}

