/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public class MachineModeFancyConfigurator
implements IFancyConfigurator {
    protected IRecipeLogicMachine machine;

    public MachineModeFancyConfigurator(IRecipeLogicMachine machine) {
        this.machine = machine;
    }

    @Override
    public String getTitle() {
        return "gtceu.gui.machinemode.title";
    }

    @Override
    public IGuiTexture getIcon() {
        return new ResourceTexture("gtceu:textures/item/lv_robot_arm.png");
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        buffer.method_10804(this.machine.getActiveRecipeType());
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        this.machine.setActiveRecipeType(buffer.method_10816());
    }

    @Override
    public void detectAndSendChange(BiConsumer<Integer, Consumer<class_2540>> sender) {
        sender.accept(0, buf -> buf.method_10804(this.machine.getActiveRecipeType()));
    }

    @Override
    public void readUpdateInfo(int id, class_2540 buffer) {
        if (id == 0) {
            this.machine.setActiveRecipeType(buffer.method_10816());
        }
    }

    @Override
    public Widget createConfigurator() {
        WidgetGroup group = new WidgetGroup(0, 0, 140, 20 * this.machine.getRecipeTypes().length + 4);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        for (int i = 0; i < this.machine.getRecipeTypes().length; ++i) {
            int finalI = i;
            group.addWidget((Widget)new ButtonWidget(2, 2 + i * 20, 136, 20, IGuiTexture.EMPTY, cd -> this.machine.setActiveRecipeType(finalI)));
            group.addWidget((Widget)new ImageWidget(2, 2 + i * 20, 136, 20, () -> new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON.copy().setColor(this.machine.getActiveRecipeType() == finalI ? ColorPattern.CYAN.color : -1), new TextTexture(this.machine.getRecipeTypes()[finalI].registryName.method_42094()).setWidth(136).setType(TextTexture.TextType.ROLL)})));
        }
        return group;
    }

    @Override
    public List<class_2561> getTooltips() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add((class_2561)class_2561.method_43470((String)"Change active Machine Mode"));
        return tooltip;
    }
}

