/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.utils.ShapeUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class MachineDefinition
implements Supplier<IMachineBlock> {
    private final class_2960 id;
    private Supplier<? extends class_2248> blockSupplier;
    private Supplier<? extends MetaMachineItem> itemSupplier;
    private Supplier<class_2591<? extends class_2586>> blockEntityTypeSupplier;
    private Function<IMachineBlockEntity, MetaMachine> machineSupplier;
    @Nullable
    private GTRecipeType[] recipeTypes;
    private int tier;
    private int defaultPaintingColor;
    private BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier;
    private boolean alwaysTryModifyRecipe;
    private IRenderer renderer;
    private class_265 shape;
    private final Map<class_2350, class_265> cache = new EnumMap<class_2350, class_265>(class_2350.class);
    private BiConsumer<class_1799, List<class_2561>> tooltipBuilder;
    private Supplier<class_2680> appearance;
    @Nullable
    private EditableMachineUI editableUI;
    private Object2IntMap<RecipeCapability<?>> recipeOutputLimits = new Object2IntOpenHashMap();

    protected MachineDefinition(class_2960 id) {
        this.id = id;
    }

    public static MachineDefinition createDefinition(class_2960 id) {
        return new MachineDefinition(id);
    }

    public class_2248 getBlock() {
        return this.blockSupplier.get();
    }

    public MetaMachineItem getItem() {
        return this.itemSupplier.get();
    }

    public class_2591<? extends class_2586> getBlockEntityType() {
        return this.blockEntityTypeSupplier.get();
    }

    public MetaMachine createMetaMachine(IMachineBlockEntity blockEntity) {
        return this.machineSupplier.apply(blockEntity);
    }

    public class_1799 asStack() {
        return new class_1799((class_1935)this.getItem());
    }

    public class_1799 asStack(int count) {
        return new class_1799((class_1935)this.getItem(), count);
    }

    public class_265 getShape(class_2350 direction) {
        if (this.shape.method_1110() || this.shape == class_259.method_1077() || direction == class_2350.field_11043) {
            return this.shape;
        }
        return this.cache.computeIfAbsent(direction, dir -> ShapeUtils.rotate((class_265)this.shape, (class_2350)dir));
    }

    @Override
    public IMachineBlock get() {
        return (IMachineBlock)this.blockSupplier.get();
    }

    public String getName() {
        return this.id.method_12832();
    }

    public String toString() {
        return "[Definition: %s]".formatted(this.id);
    }

    public String getDescriptionId() {
        return this.getBlock().method_9539();
    }

    public class_2680 defaultBlockState() {
        return this.getBlock().method_9564();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineDefinition that = (MachineDefinition)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public class_2960 getId() {
        return this.id;
    }

    public void setBlockSupplier(Supplier<? extends class_2248> blockSupplier) {
        this.blockSupplier = blockSupplier;
    }

    public void setItemSupplier(Supplier<? extends MetaMachineItem> itemSupplier) {
        this.itemSupplier = itemSupplier;
    }

    public void setBlockEntityTypeSupplier(Supplier<class_2591<? extends class_2586>> blockEntityTypeSupplier) {
        this.blockEntityTypeSupplier = blockEntityTypeSupplier;
    }

    public void setMachineSupplier(Function<IMachineBlockEntity, MetaMachine> machineSupplier) {
        this.machineSupplier = machineSupplier;
    }

    @Nullable
    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes;
    }

    public void setRecipeTypes(@Nullable GTRecipeType[] recipeTypes) {
        this.recipeTypes = recipeTypes;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setDefaultPaintingColor(int defaultPaintingColor) {
        this.defaultPaintingColor = defaultPaintingColor;
    }

    public int getDefaultPaintingColor() {
        return this.defaultPaintingColor;
    }

    public void setRecipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier) {
        this.recipeModifier = recipeModifier;
    }

    public BiFunction<MetaMachine, GTRecipe, GTRecipe> getRecipeModifier() {
        return this.recipeModifier;
    }

    public void setAlwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
    }

    public boolean isAlwaysTryModifyRecipe() {
        return this.alwaysTryModifyRecipe;
    }

    public void setRenderer(IRenderer renderer) {
        this.renderer = renderer;
    }

    public IRenderer getRenderer() {
        return this.renderer;
    }

    public void setShape(class_265 shape) {
        this.shape = shape;
    }

    public BiConsumer<class_1799, List<class_2561>> getTooltipBuilder() {
        return this.tooltipBuilder;
    }

    public void setTooltipBuilder(BiConsumer<class_1799, List<class_2561>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
    }

    public Supplier<class_2680> getAppearance() {
        return this.appearance;
    }

    public void setAppearance(Supplier<class_2680> appearance) {
        this.appearance = appearance;
    }

    @Nullable
    public EditableMachineUI getEditableUI() {
        return this.editableUI;
    }

    public void setEditableUI(@Nullable EditableMachineUI editableUI) {
        this.editableUI = editableUI;
    }

    public Object2IntMap<RecipeCapability<?>> getRecipeOutputLimits() {
        return this.recipeOutputLimits;
    }

    public void setRecipeOutputLimits(Object2IntMap<RecipeCapability<?>> recipeOutputLimits) {
        this.recipeOutputLimits = recipeOutputLimits;
    }
}

