/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.syncdata.EnhancedFieldManagedStorage;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.gregtechceu.gtceu.api.syncdata.UpdateListener;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.ReadOnlyManaged;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MachineCoverContainer
implements ICoverable,
IEnhancedManaged {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MachineCoverContainer.class);
    private final EnhancedFieldManagedStorage syncStorage = new EnhancedFieldManagedStorage(this);
    private final MetaMachine machine;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior up;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior down;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior north;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior south;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior west;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior east;

    public MachineCoverContainer(MetaMachine machine) {
        this.machine = machine;
    }

    private void onCoverSet(CoverBehavior newValue, CoverBehavior oldValue) {
        if (newValue != oldValue && (newValue == null || oldValue == null)) {
            this.scheduleRenderUpdate();
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        class_1937 level = this.getLevel();
        if (level != null && !level.field_9236 && level.method_8503() != null) {
            level.method_8503().execute(this::markDirty);
        }
    }

    @Override
    public class_1937 getLevel() {
        return this.machine.getLevel();
    }

    @Override
    public class_2338 getPos() {
        return this.machine.getPos();
    }

    @Override
    public long getOffsetTimer() {
        return this.machine.getOffsetTimer();
    }

    @Override
    public void markDirty() {
        this.machine.markDirty();
    }

    @Override
    public void notifyBlockUpdate() {
        this.machine.notifyBlockUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.machine.scheduleRenderUpdate();
    }

    @Override
    public void scheduleNeighborShapeUpdate() {
        this.machine.scheduleNeighborShapeUpdate();
    }

    @Override
    public boolean isInValid() {
        return this.machine.isInValid();
    }

    @Override
    public boolean canPlaceCoverOnSide(CoverDefinition definition, class_2350 side) {
        ArrayList<class_265> collisionList = new ArrayList<class_265>();
        this.machine.addCollisionBoundingBox(collisionList);
        return !ICoverable.doesCoverCollide(side, collisionList, this.getCoverPlateThickness());
    }

    @Override
    public double getCoverPlateThickness() {
        return 0.0;
    }

    @Override
    public class_2350 getFrontFacing() {
        return this.machine.getFrontFacing();
    }

    @Override
    public boolean shouldRenderBackSide() {
        return !this.machine.getBlockState().method_26225();
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        return this.machine.subscribeServerTick(runnable);
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        this.machine.unsubscribe(current);
    }

    @Override
    public CoverBehavior getCoverAtSide(class_2350 side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> this.up;
            case class_2350.field_11035 -> this.south;
            case class_2350.field_11039 -> this.west;
            case class_2350.field_11033 -> this.down;
            case class_2350.field_11034 -> this.east;
            case class_2350.field_11043 -> this.north;
        };
    }

    @Override
    public void setCoverAtSide(@Nullable CoverBehavior coverBehavior, class_2350 side) {
        switch (side) {
            case field_11036: {
                this.up = coverBehavior;
                break;
            }
            case field_11035: {
                this.south = coverBehavior;
                break;
            }
            case field_11039: {
                this.west = coverBehavior;
                break;
            }
            case field_11033: {
                this.down = coverBehavior;
                break;
            }
            case field_11034: {
                this.east = coverBehavior;
                break;
            }
            case field_11043: {
                this.north = coverBehavior;
            }
        }
        if (coverBehavior != null) {
            coverBehavior.getSyncStorage().markAllDirty();
        }
    }

    @Override
    public IItemTransfer getItemTransferCap(@Nullable class_2350 side, boolean useCoverCapability) {
        return this.machine.getItemTransferCap(side, useCoverCapability);
    }

    @Override
    public IFluidTransfer getFluidTransferCap(@Nullable class_2350 side, boolean useCoverCapability) {
        return this.machine.getFluidTransferCap(side, useCoverCapability);
    }

    private boolean onCoverDirty(CoverBehavior coverBehavior) {
        if (coverBehavior != null) {
            for (IRef ref : coverBehavior.getSyncStorage().getNonLazyFields()) {
                ref.update();
            }
            return coverBehavior.getSyncStorage().hasDirtySyncFields() || coverBehavior.getSyncStorage().hasDirtyPersistedFields();
        }
        return false;
    }

    private class_2487 serializeCoverUid(CoverBehavior coverBehavior) {
        class_2487 uid = new class_2487();
        uid.method_10582("id", ((class_2960)GTRegistries.COVERS.getKey(coverBehavior.coverDefinition)).toString());
        uid.method_10569("side", coverBehavior.attachedSide.ordinal());
        return uid;
    }

    private CoverBehavior deserializeCoverUid(class_2487 uid) {
        class_2960 definitionId = new class_2960(uid.method_10558("id"));
        class_2350 side = class_2350.values()[uid.method_10550("side")];
        CoverDefinition definition = (CoverDefinition)GTRegistries.COVERS.get(definitionId);
        if (definition != null) {
            return definition.createCoverBehavior(this, side);
        }
        GTCEu.LOGGER.error("couldn't find cover definition {}", (Object)definitionId);
        throw new RuntimeException();
    }

    public EnhancedFieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }
}

