/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabsWidget
extends Widget {
    protected final Consumer<IFancyUIProvider> onTabClick;
    protected IFancyUIProvider mainTab;
    protected List<IFancyUIProvider> subTabs;
    @Nullable
    protected IFancyUIProvider selectedTab;
    protected IGuiTexture leftButtonTexture = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.LEFT.copy().scale(0.7f)});
    protected IGuiTexture leftButtonHoverTexture = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.LEFT.copy().setColor(-5592406).scale(0.7f)});
    protected IGuiTexture rightButtonTexture = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.RIGHT.copy().scale(0.7f)});
    protected IGuiTexture rightButtonHoverTexture = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.RIGHT.copy().setColor(-5592406).scale(0.7f)});
    protected IGuiTexture tabTexture = new ResourceTexture("gtceu:textures/gui/tab/tabs_top.png").getSubTexture(0.33333334f, 0.0f, 0.33333334f, 0.5f);
    protected IGuiTexture tabHoverTexture;
    protected IGuiTexture tabPressedTexture = this.tabHoverTexture = new ResourceTexture("gtceu:textures/gui/tab/tabs_top.png").getSubTexture(0.33333334f, 0.5f, 0.33333334f, 0.5f);
    protected int offset;
    @Nullable
    protected BiConsumer<IFancyUIProvider, IFancyUIProvider> onTabSwitch;

    public TabsWidget(Consumer<IFancyUIProvider> onTabClick) {
        super(0, -21, 200, 24);
        this.subTabs = new ArrayList<IFancyUIProvider>();
        this.onTabClick = onTabClick;
    }

    public void setMainTab(IFancyUIProvider mainTab) {
        this.mainTab = mainTab;
        if (this.selectedTab == null) {
            this.selectedTab = this.mainTab;
        }
    }

    public void attachSubTab(IFancyUIProvider subTab) {
        this.subTabs.add(subTab);
    }

    public boolean hasButton() {
        return (this.subTabs.size() + 1) * 24 + 16 > this.getSize().width;
    }

    public void handleClientAction(int id, class_2540 buffer) {
        super.handleClientAction(id, buffer);
        if (id == 0) {
            int index = buffer.method_10816();
            IFancyUIProvider old = this.selectedTab;
            if (index < 0) {
                this.selectedTab = this.mainTab;
            } else if (index < this.subTabs.size()) {
                this.selectedTab = this.subTabs.get(index);
            } else {
                return;
            }
            if (this.onTabSwitch != null) {
                this.onTabSwitch.accept(old, this.selectedTab);
            }
            this.onTabClick.accept(this.selectedTab);
        }
    }

    public int getSubTabsWidth() {
        return this.getSize().width - 8 - 24 - 4 - 16 - 8 - 16;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            IFancyUIProvider hoveredTab = this.getHoveredTab(mouseX, mouseY);
            if (hoveredTab != null && hoveredTab != this.selectedTab) {
                if (this.onTabSwitch != null) {
                    this.onTabSwitch.accept(this.selectedTab, hoveredTab);
                }
                this.selectedTab = hoveredTab;
                this.writeClientAction(0, buf -> buf.method_10804(this.selectedTab == this.mainTab ? -1 : this.subTabs.indexOf(this.selectedTab)));
                this.onTabClick.accept(this.selectedTab);
                TabsWidget.playButtonClickSound();
            }
            if (this.hasButton()) {
                if (this.isHoverLeftButton(mouseX, mouseY)) {
                    this.offset = class_3532.method_15340((int)(this.offset - 24), (int)0, (int)(this.subTabs.size() * 24 - this.getSubTabsWidth()));
                    TabsWidget.playButtonClickSound();
                } else if (this.isHoverRightButton(mouseX, mouseY)) {
                    this.offset = class_3532.method_15340((int)(this.offset + 24), (int)0, (int)(this.subTabs.size() * 24 - this.getSubTabsWidth()));
                    TabsWidget.playButtonClickSound();
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        int sx = this.getPosition().x + 8 + 24 + 4 + 16;
        if (TabsWidget.isMouseOver((int)sx, (int)this.getPosition().y, (int)this.getSubTabsWidth(), (int)24, (double)mouseX, (double)mouseY)) {
            this.offset = class_3532.method_15340((int)(this.offset + 5 * (wheelDelta > 0.0 ? -1 : 1)), (int)0, (int)(this.subTabs.size() * 24 - this.getSubTabsWidth()));
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        IFancyUIProvider hoveredTab = this.getHoveredTab(mouseX, mouseY);
        this.drawTab(this.mainTab, graphics, mouseX, mouseY, position.x + 8, position.y, 24, 24, hoveredTab);
        if (this.hasButton()) {
            if (this.isHoverLeftButton(mouseX, mouseY)) {
                this.leftButtonHoverTexture.draw(graphics, mouseX, mouseY, (float)(position.x + 8 + 24 + 4), (float)position.y, 16, 24);
            } else {
                this.leftButtonTexture.draw(graphics, mouseX, mouseY, (float)(position.x + 8 + 24 + 4), (float)position.y, 16, 24);
            }
            if (this.isHoverRightButton(mouseX, mouseY)) {
                this.rightButtonHoverTexture.draw(graphics, mouseX, mouseY, (float)(position.x + size.width - 8 - 16), (float)position.y, 16, 24);
            } else {
                this.rightButtonTexture.draw(graphics, mouseX, mouseY, (float)(position.x + size.width - 8 - 16), (float)position.y, 16, 24);
            }
            int sx = position.x + 8 + 24 + 4 + 16;
            graphics.method_44379(sx, position.y - 1, sx + this.getSubTabsWidth(), position.y - 1 + 24 + 2);
            for (int i = 0; i < this.subTabs.size(); ++i) {
                this.drawTab(this.subTabs.get(i), graphics, mouseX, mouseY, sx + i * 24 - this.offset, position.y, 24, 24, hoveredTab);
            }
            graphics.method_44380();
        } else {
            for (int i = this.subTabs.size() - 1; i >= 0; --i) {
                this.drawTab(this.subTabs.get(i), graphics, mouseX, mouseY, position.x + size.width - 8 - 24 * (this.subTabs.size() - i), position.y, 24, 24, hoveredTab);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        IFancyUIProvider hoveredTab = this.getHoveredTab(mouseX, mouseY);
        if (hoveredTab != null && this.gui != null && this.gui.getModularUIGui() != null) {
            this.gui.getModularUIGui().setHoverTooltip(hoveredTab.getTabTooltips(), class_1799.field_8037, null, hoveredTab.getTabTooltipComponent());
        }
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isHoverLeftButton(double mouseX, double mouseY) {
        return TabsWidget.isMouseOver((int)(this.getPosition().x + 8 + 24 + 4), (int)this.getPosition().y, (int)16, (int)24, (double)mouseX, (double)mouseY);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isHoverRightButton(double mouseX, double mouseY) {
        return TabsWidget.isMouseOver((int)(this.getPosition().x + this.getSize().width - 8 - 16), (int)this.getPosition().y, (int)16, (int)24, (double)mouseX, (double)mouseY);
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public IFancyUIProvider getHoveredTab(double mouseX, double mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            Position position = this.getPosition();
            Size size = this.getSize();
            if (TabsWidget.isMouseOver((int)(position.x + 8), (int)position.y, (int)24, (int)24, (double)mouseX, (double)mouseY)) {
                return this.mainTab;
            }
            if (this.hasButton()) {
                int i;
                int sx = position.x + 8 + 24 + 4 + 16;
                if (TabsWidget.isMouseOver((int)sx, (int)position.y, (int)this.getSubTabsWidth(), (int)24, (double)mouseX, (double)mouseY) && (i = ((int)mouseX - sx + this.getOffset()) / 24) < this.subTabs.size()) {
                    return this.subTabs.get(i);
                }
            } else {
                int i = (position.x + size.width - 8 - (int)mouseX) / 24;
                if (i < this.subTabs.size()) {
                    return this.subTabs.get(this.subTabs.size() - 1 - i);
                }
            }
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void drawTab(IFancyUIProvider tab, @NotNull class_332 graphics, int mouseX, int mouseY, int x, int y, int width, int height, IFancyUIProvider hoveredTab) {
        if (tab == this.selectedTab) {
            this.tabPressedTexture.draw(graphics, mouseX, mouseY, (float)x, (float)y, width, height);
        } else if (tab == hoveredTab) {
            this.tabHoverTexture.draw(graphics, mouseX, mouseY, (float)x, (float)y, width, height);
        } else {
            this.tabTexture.draw(graphics, mouseX, mouseY, (float)x, (float)y, width, height);
        }
        tab.getTabIcon().draw(graphics, mouseX, mouseY, (float)x + (float)(width - 16) / 2.0f, (float)y + (float)(height - 16) / 2.0f, 16, 16);
    }

    public Consumer<IFancyUIProvider> getOnTabClick() {
        return this.onTabClick;
    }

    public IFancyUIProvider getMainTab() {
        return this.mainTab;
    }

    public List<IFancyUIProvider> getSubTabs() {
        return this.subTabs;
    }

    @Nullable
    public IFancyUIProvider getSelectedTab() {
        return this.selectedTab;
    }

    public IGuiTexture getLeftButtonTexture() {
        return this.leftButtonTexture;
    }

    public IGuiTexture getLeftButtonHoverTexture() {
        return this.leftButtonHoverTexture;
    }

    public IGuiTexture getRightButtonTexture() {
        return this.rightButtonTexture;
    }

    public IGuiTexture getRightButtonHoverTexture() {
        return this.rightButtonHoverTexture;
    }

    public IGuiTexture getTabTexture() {
        return this.tabTexture;
    }

    public IGuiTexture getTabHoverTexture() {
        return this.tabHoverTexture;
    }

    public IGuiTexture getTabPressedTexture() {
        return this.tabPressedTexture;
    }

    @Nullable
    public BiConsumer<IFancyUIProvider, IFancyUIProvider> getOnTabSwitch() {
        return this.onTabSwitch;
    }

    public void setLeftButtonTexture(IGuiTexture leftButtonTexture) {
        this.leftButtonTexture = leftButtonTexture;
    }

    public void setLeftButtonHoverTexture(IGuiTexture leftButtonHoverTexture) {
        this.leftButtonHoverTexture = leftButtonHoverTexture;
    }

    public void setTabTexture(IGuiTexture tabTexture) {
        this.tabTexture = tabTexture;
    }

    public void setTabHoverTexture(IGuiTexture tabHoverTexture) {
        this.tabHoverTexture = tabHoverTexture;
    }

    public void setTabPressedTexture(IGuiTexture tabPressedTexture) {
        this.tabPressedTexture = tabPressedTexture;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOnTabSwitch(@Nullable BiConsumer<IFancyUIProvider, IFancyUIProvider> onTabSwitch) {
        this.onTabSwitch = onTabSwitch;
    }
}

