/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.custom.PlayerInventoryWidget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import org.jetbrains.annotations.Nullable;

public class FancyMachineUIWidget
extends WidgetGroup {
    protected final IFancyUIProvider fancyUIProvider;
    protected final TabsWidget tabsWidget;
    protected final WidgetGroup pageContainer;
    protected final ConfiguratorPanel configuratorPanel;
    protected final TooltipsPanel tooltipsPanel;
    @Nullable
    protected final PlayerInventoryWidget playerInventory;
    protected int border = 4;

    public FancyMachineUIWidget(IFancyUIProvider fancyUIProvider) {
        super(0, 0, 200, 100 + (fancyUIProvider.hasPlayerInventory() ? 90 : 0));
        this.fancyUIProvider = fancyUIProvider;
        this.pageContainer = new WidgetGroup(0, 0, 200, 100);
        this.addWidget((Widget)this.pageContainer);
        if (fancyUIProvider.hasPlayerInventory()) {
            this.playerInventory = new PlayerInventoryWidget();
            this.addWidget((Widget)this.playerInventory);
        } else {
            this.playerInventory = null;
        }
        this.tabsWidget = new TabsWidget(this::onTabSwitch);
        this.addWidget(this.tabsWidget);
        this.tooltipsPanel = new TooltipsPanel();
        this.addWidget(this.tooltipsPanel);
        this.configuratorPanel = new ConfiguratorPanel();
        this.addWidget((Widget)this.configuratorPanel);
    }

    public void initWidget() {
        super.initWidget();
        if (this.playerInventory != null) {
            this.playerInventory.setPlayer(this.gui.entityPlayer);
        }
        this.setupFancyUI(this.fancyUIProvider);
        this.fancyUIProvider.setupTabs(this.tabsWidget);
    }

    public void setupFancyUI(IFancyUIProvider fancyUI) {
        Widget mainPage = fancyUI.createMainPage();
        this.pageContainer.clearAllWidgets();
        this.configuratorPanel.clear();
        this.tooltipsPanel.clear();
        Size size = new Size(Math.max(172, mainPage.getSize().width + this.border * 2), Math.max(86, mainPage.getSize().height + this.border * 2));
        this.setSize(new Size(size.width, size.height + (this.playerInventory == null ? 0 : this.playerInventory.getSize().height + 4)));
        if (LDLib.isRemote() && this.getGui() != null) {
            this.getGui().setSize(this.getSize().width, this.getSize().height);
        }
        this.tabsWidget.setSize(new Size(size.width, 24));
        this.pageContainer.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND});
        this.pageContainer.setSize(size);
        this.tooltipsPanel.setSelfPosition(new Position(size.width + 2, 2));
        if (this.playerInventory != null) {
            this.playerInventory.setSelfPosition(new Position((size.width - this.playerInventory.getSize().width) / 2, size.height + 4));
        }
        this.pageContainer.addWidget(mainPage);
        mainPage.setSelfPosition(new Position((this.pageContainer.getSize().width - mainPage.getSize().width) / 2, (this.pageContainer.getSize().height - mainPage.getSize().height) / 2));
        fancyUI.attachConfigurators(this.configuratorPanel);
        fancyUI.attachTooltips(this.tooltipsPanel);
    }

    private void onTabSwitch(IFancyUIProvider newTab) {
        this.setupFancyUI(newTab);
    }

    public IFancyUIProvider getFancyUIProvider() {
        return this.fancyUIProvider;
    }

    public TabsWidget getTabsWidget() {
        return this.tabsWidget;
    }

    public WidgetGroup getPageContainer() {
        return this.pageContainer;
    }

    public ConfiguratorPanel getConfiguratorPanel() {
        return this.configuratorPanel;
    }

    public TooltipsPanel getTooltipsPanel() {
        return this.tooltipsPanel;
    }

    @Nullable
    public PlayerInventoryWidget getPlayerInventory() {
        return this.playerInventory;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }
}

