/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.compass;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.BlockAnima;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.CompassScene;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.w3c.dom.Element;

public class MultiblockAction
extends Action {
    private final BlockAnima animation;
    @Nullable
    private final MultiblockMachineDefinition machineDefinition;
    private final int shapeIndex;
    private final boolean isFormed;
    private final class_2350 facing;

    public MultiblockAction(Element element) {
        MachineDefinition definition;
        String machineName = XmlUtils.getAsString((Element)element, (String)"machine", (String)"");
        class_2338 blockPos = XmlUtils.getAsBlockPos((Element)element, (String)"pos", (class_2338)class_2338.field_10980);
        this.shapeIndex = XmlUtils.getAsInt((Element)element, (String)"shape-index", (int)0);
        this.facing = (class_2350)XmlUtils.getAsEnum((Element)element, (String)"facing", class_2350.class, (Enum)class_2350.field_11043);
        this.isFormed = XmlUtils.getAsBoolean((Element)element, (String)"formed", (boolean)true);
        this.animation = new BlockAnima(blockPos, XmlUtils.getAsVec3((Element)element, (String)"offset", (class_243)new class_243(0.0, 0.7, 0.0)), XmlUtils.getAsInt((Element)element, (String)"duration", (int)15));
        if (class_2960.method_20207((String)machineName) && (definition = (MachineDefinition)GTRegistries.MACHINES.get(new class_2960(machineName))) instanceof MultiblockMachineDefinition) {
            MultiblockMachineDefinition multiblockDefinition;
            this.machineDefinition = multiblockDefinition = (MultiblockMachineDefinition)definition;
            return;
        }
        this.machineDefinition = null;
    }

    public int getDuration() {
        return this.machineDefinition == null ? 5 : this.animation.duration() + 5;
    }

    public void performAction(AnimationFrame frame, CompassScene scene, boolean anima) {
        List<MultiblockShapeInfo> shapes;
        if (this.machineDefinition != null && !(shapes = this.machineDefinition.getMatchingShapes()).isEmpty()) {
            MultiblockShapeInfo shape = shapes.get(0);
            if (this.shapeIndex < shapes.size()) {
                shape = shapes.get(this.shapeIndex);
            }
            BlockInfo[][][] blocks = shape.getBlocks();
            HashMap<class_2338, BlockInfo> blockMap = new HashMap<class_2338, BlockInfo>();
            class_2338 offset = class_2338.field_10980;
            for (int x = 0; x < blocks.length; ++x) {
                BlockInfo[][] aisle = blocks[x];
                for (int y = 0; y < aisle.length; ++y) {
                    BlockInfo[] column = aisle[y];
                    for (int z = 0; z < column.length; ++z) {
                        IMachineBlockEntity holder;
                        class_2680 blockState = column[z].getBlockState();
                        class_2338 pos2 = this.animation.pos().method_10069(x, y, z);
                        class_2586 class_25862 = column[z].getBlockEntity(pos2);
                        if (class_25862 instanceof IMachineBlockEntity && (holder = (IMachineBlockEntity)class_25862).getMetaMachine() instanceof IMultiController) {
                            offset = pos2;
                        }
                        blockMap.put(pos2, BlockInfo.fromBlockState((class_2680)blockState));
                    }
                }
            }
            class_2338 finalOffset = offset;
            blockMap.forEach((pos, blockInfo) -> scene.addBlock(pos.method_10059((class_2382)finalOffset).method_10081((class_2382)this.animation.pos()), blockInfo, anima ? this.animation : null));
        }
    }
}

