/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTOres;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3124;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@class_6328
@ParametersAreNonnullByDefault
public class OreVeinUtil {
    private OreVeinUtil() {
    }

    public static boolean canPlaceOre(class_2680 pState, Function<class_2338, class_2680> pAdjacentStateAccessor, class_5819 pRandom, GTOreDefinition entry, class_3124.class_5876 pTargetState, class_2338.class_2339 pMatablePos) {
        if (!pTargetState.field_29068.method_16768(pState, pRandom)) {
            return false;
        }
        if (OreVeinUtil.shouldSkipAirCheck(pRandom, entry.discardChanceOnAirExposure())) {
            return true;
        }
        return !class_3031.method_33981(pAdjacentStateAccessor, (class_2338)pMatablePos);
    }

    public static boolean canPlaceOre(class_2680 pState, Function<class_2338, class_2680> pAdjacentStateAccessor, class_5819 pRandom, GTOreDefinition entry, class_2338.class_2339 pMatablePos) {
        if (!entry.layer().getTarget().method_16768(pState, pRandom)) {
            return false;
        }
        if (OreVeinUtil.shouldSkipAirCheck(pRandom, entry.discardChanceOnAirExposure())) {
            return true;
        }
        return !class_3031.method_33981(pAdjacentStateAccessor, (class_2338)pMatablePos);
    }

    protected static boolean shouldSkipAirCheck(class_5819 pRandom, float pChance) {
        return pChance <= 0.0f || !(pChance >= 1.0f) && pRandom.method_43057() >= pChance;
    }

    public static Optional<class_2338> getVeinCenter(class_1923 chunkPos, class_5819 random) {
        int gridSize = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinGridSize;
        int randomOffset = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinRandomOffset;
        if (chunkPos.field_9181 % gridSize != 0 || chunkPos.field_9180 % gridSize != 0) {
            return Optional.empty();
        }
        class_2338 chunkCenter = chunkPos.method_33943(0);
        if (randomOffset == 0) {
            return Optional.of(chunkCenter);
        }
        return Optional.of(chunkCenter.method_10069(random.method_43051(-randomOffset, randomOffset), 0, random.method_43051(-randomOffset, randomOffset)));
    }

    static int getMaxVeinSearchDistance() {
        double halfVeinSize = (double)GTOres.getLargestVeinSize() / 2.0;
        int randomOffset = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinRandomOffset;
        return (int)Math.ceil((halfVeinSize + (double)randomOffset) / 16.0);
    }

    static int getMaxIndicatorSearchDistance() {
        return OreVeinUtil.getMaxVeinSearchDistance() + (int)Math.ceil((double)GTOres.getLargestIndicatorOffset() / 16.0);
    }

    @Nullable
    public static Supplier<class_6885<class_1959>> resolveBiomes(List<String> biomes) {
        if (biomes.isEmpty()) {
            return null;
        }
        class_6903 registryOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)GTRegistries.builtinRegistry());
        JsonElement codecInput = OreVeinUtil.resolveBiomeCodecInput(biomes);
        return () -> (class_6885)class_6895.method_40340((class_5321)class_7924.field_41236).decode((DynamicOps)registryOps, (Object)codecInput).map(Pair::getFirst).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    private static JsonElement resolveBiomeCodecInput(List<String> biomes) {
        if (biomes.size() == 1) {
            return new JsonPrimitive(biomes.get(0));
        }
        if (biomes.stream().anyMatch(filter -> filter.startsWith("#"))) {
            throw new IllegalStateException("Cannot resolve biomes: You may use either a single tag or multiple individual biomes.");
        }
        JsonArray jsonArray = new JsonArray();
        biomes.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray;
    }
}

