/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2826;
import net.minecraft.class_2919;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4651;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5543;
import net.minecraft.class_5586;
import net.minecraft.class_5587;
import net.minecraft.class_5588;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5867;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class GeodeVeinGenerator
extends VeinGenerator {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    public static final Codec<Double> CHANCE_RANGE = Codec.doubleRange((double)0.0, (double)1.0);
    public static final Codec<GeodeVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GeodeBlockSettings.CODEC.fieldOf("blocks").forGetter(config -> config.geodeBlockSettings), (App)class_5587.field_27306.fieldOf("layers").forGetter(config -> config.geodeLayerSettings), (App)class_5586.field_27302.fieldOf("crack").forGetter(config -> config.geodeCrackSettings), (App)CHANCE_RANGE.fieldOf("use_potential_placements_chance").orElse((Object)0.35).forGetter(config -> config.usePotentialPlacementsChance), (App)CHANCE_RANGE.fieldOf("use_alternate_layer0_chance").orElse((Object)0.0).forGetter(config -> config.useAlternateLayer0Chance), (App)Codec.BOOL.fieldOf("placements_require_layer0_alternate").orElse((Object)true).forGetter(config -> config.placementsRequireLayer0Alternate), (App)class_6017.method_35004((int)1, (int)20).fieldOf("outer_wall_distance").orElse((Object)class_6019.method_35017((int)4, (int)5)).forGetter(config -> config.outerWallDistance), (App)class_6017.method_35004((int)1, (int)20).fieldOf("distribution_points").orElse((Object)class_6019.method_35017((int)3, (int)4)).forGetter(config -> config.distributionPoints), (App)class_6017.method_35004((int)0, (int)10).fieldOf("point_offset").orElse((Object)class_6019.method_35017((int)1, (int)2)).forGetter(config -> config.pointOffset), (App)Codec.INT.fieldOf("min_gen_offset").orElse((Object)-16).forGetter(config -> config.minGenOffset), (App)Codec.INT.fieldOf("max_gen_offset").orElse((Object)16).forGetter(config -> config.maxGenOffset), (App)CHANCE_RANGE.fieldOf("noise_multiplier").orElse((Object)0.05).forGetter(config -> config.noiseMultiplier), (App)Codec.INT.fieldOf("invalid_blocks_threshold").forGetter(config -> config.invalidBlocksThreshold)).apply((Applicative)instance, GeodeVeinGenerator::new));
    public GeodeBlockSettings geodeBlockSettings;
    public class_5587 geodeLayerSettings;
    public class_5586 geodeCrackSettings;
    public double usePotentialPlacementsChance = 0.5;
    public double useAlternateLayer0Chance = 0.0;
    public boolean placementsRequireLayer0Alternate = false;
    public class_6017 outerWallDistance = class_6016.method_34998((int)0);
    public class_6017 distributionPoints = class_6016.method_34998((int)0);
    public class_6017 pointOffset = class_6016.method_34998((int)0);
    public int minGenOffset = 0;
    public int maxGenOffset = 0;
    public double noiseMultiplier = 1.0;
    public int invalidBlocksThreshold = 0;

    public GeodeVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<Map.Entry<Either<class_2680, Material>, Integer>> getAllEntries() {
        class_5820 source = new class_5820(0L);
        return List.of(Map.entry(this.geodeBlockSettings.fillingProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$14((class_5819)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.innerLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$15((class_5819)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.alternateInnerLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$16((class_5819)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.middleLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$17((class_5819)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.outerLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$18((class_5819)source, arg_0), Function.identity()), 1));
    }

    @Override
    public Map<class_2338, OreBlockPlacer> generate(class_5281 level, class_5819 random, GTOreDefinition entry, class_2338 origin) {
        class_2680 blockState;
        int offset;
        int offset2;
        class_5867 access = new class_5867((class_1936)level);
        int minOffset = this.minGenOffset;
        int maxOffset = this.maxGenOffset;
        LinkedList points = Lists.newLinkedList();
        int distributionSample = this.distributionPoints.method_35008(random);
        class_2919 worldgenRandom = new class_2919((class_5819)new class_5820(level.method_8412()));
        class_5216 normalNoise = class_5216.method_31927((class_5819)worldgenRandom, (int)-4, (double[])new double[]{1.0});
        LinkedList list2 = Lists.newLinkedList();
        double wallDistance = (double)distributionSample / (double)this.outerWallDistance.method_35011();
        double fillingSize = 1.0 / Math.sqrt(this.geodeLayerSettings.field_27307);
        double innerSize = 1.0 / Math.sqrt(this.geodeLayerSettings.field_27308 + wallDistance);
        double middleSize = 1.0 / Math.sqrt(this.geodeLayerSettings.field_27309 + wallDistance);
        double outerSize = 1.0 / Math.sqrt(this.geodeLayerSettings.field_27310 + wallDistance);
        double crackSize = 1.0 / Math.sqrt(this.geodeCrackSettings.field_27304 + random.method_43058() / 2.0 + (distributionSample > 3 ? wallDistance : 0.0));
        boolean doCrack = (double)random.method_43057() < this.geodeCrackSettings.field_27303;
        int invalidBlocksCount = 0;
        for (offset2 = 0; offset2 < distributionSample; ++offset2) {
            offset = this.outerWallDistance.method_35008(random);
            class_2338 origin2 = origin.method_10069(offset, this.outerWallDistance.method_35008(random), this.outerWallDistance.method_35008(random));
            blockState = access.method_33946(origin2);
            if ((blockState.method_26215() || blockState.method_26164(class_3481.field_33863)) && ++invalidBlocksCount > this.invalidBlocksThreshold) {
                return Map.of();
            }
            points.add(Pair.of((Object)origin2, (Object)this.pointOffset.method_35008(random)));
        }
        if (doCrack) {
            offset2 = random.method_43048(4);
            offset = distributionSample * 2 + 1;
            if (offset2 == 0) {
                list2.add(origin.method_10069(offset, 7, 0));
                list2.add(origin.method_10069(offset, 5, 0));
                list2.add(origin.method_10069(offset, 1, 0));
            } else if (offset2 == 1) {
                list2.add(origin.method_10069(0, 7, offset));
                list2.add(origin.method_10069(0, 5, offset));
                list2.add(origin.method_10069(0, 1, offset));
            } else if (offset2 == 2) {
                list2.add(origin.method_10069(offset, 7, offset));
                list2.add(origin.method_10069(offset, 5, offset));
                list2.add(origin.method_10069(offset, 1, offset));
            } else {
                list2.add(origin.method_10069(0, 7, 0));
                list2.add(origin.method_10069(0, 5, 0));
                list2.add(origin.method_10069(0, 1, 0));
            }
        }
        ArrayList positions = Lists.newArrayList();
        Predicate placementPredicate = class_5588.method_36999(this.geodeBlockSettings.cannotReplace);
        for (class_2338 pos : class_2338.method_10097((class_2338)origin.method_10069(minOffset, minOffset, minOffset), (class_2338)origin.method_10069(maxOffset, maxOffset, maxOffset))) {
            class_2826 section;
            double noiseValue = normalNoise.method_27406((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) * this.noiseMultiplier;
            double s = 0.0;
            double t = 0.0;
            for (Pair pair : points) {
                s += class_3532.method_15345((double)(pos.method_10262((class_2382)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + noiseValue;
            }
            for (class_2350[] origin4 : list2) {
                t += class_3532.method_15345((double)(pos.method_10262((class_2382)origin4) + (double)this.geodeCrackSettings.field_27305)) + noiseValue;
            }
            if (s < outerSize || !level.method_37368(pos) || (section = access.method_33944(pos)) == null) continue;
            if (doCrack && t >= crackSize && s < fillingSize) {
                this.safeSetBlock(access, section, pos, class_2246.field_10124.method_9564(), placementPredicate);
                for (class_2350 direction : DIRECTIONS) {
                    class_2338 origin5 = pos.method_10093(direction);
                    class_3610 fluidState = level.method_8316(origin5);
                    if (fluidState.method_15769()) continue;
                    level.method_39281(origin5, fluidState.method_15772(), 0);
                }
                continue;
            }
            if (s >= fillingSize) {
                this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.fillingProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                continue;
            }
            if (s >= innerSize) {
                boolean useAltLayer;
                boolean bl = useAltLayer = (double)random.method_43057() < this.useAlternateLayer0Chance;
                if (useAltLayer) {
                    this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.alternateInnerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                } else {
                    this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.innerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                }
                if (this.placementsRequireLayer0Alternate && !useAltLayer || !((double)random.method_43057() < this.usePotentialPlacementsChance)) continue;
                positions.add(pos.method_10062());
                continue;
            }
            if (s >= middleSize) {
                this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.middleLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                continue;
            }
            if (!(s >= outerSize)) continue;
            this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.outerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
        }
        List<class_2680> innerPlacements = this.geodeBlockSettings.innerPlacements;
        block5: for (class_2338 origin2 : positions) {
            blockState = (class_2680)class_156.method_32309(innerPlacements, (class_5819)random);
            for (class_2350 direction2 : DIRECTIONS) {
                class_2826 section;
                if (blockState.method_28498((class_2769)class_2741.field_12525)) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12525, (Comparable)direction2);
                }
                class_2338 origin6 = origin2.method_10093(direction2);
                class_2680 blockState2 = access.method_33946(origin6);
                if (blockState.method_28498((class_2769)class_2741.field_12508)) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(blockState2.method_26227().method_15771()));
                }
                if (!class_5543.method_31626((class_2680)blockState2) || !level.method_37368(origin6) || (section = access.method_33944(origin6)) == null) continue;
                this.safeSetBlock(access, section, origin6, blockState, placementPredicate);
                continue block5;
            }
        }
        access.close();
        return Map.of();
    }

    protected void safeSetBlock(class_5867 level, class_2826 section, class_2338 pos, class_2680 state, Predicate<class_2680> oldState) {
        if (oldState.test(level.method_33946(pos))) {
            int x = class_4076.method_18684((int)pos.method_10263());
            int y = class_4076.method_18684((int)pos.method_10264());
            int z = class_4076.method_18684((int)pos.method_10260());
            section.method_12256(x, y, z, state, false);
        }
    }

    protected class_2680 getStateFromEither(Either<class_4651, Material> either, GeodeBlockSettings settings, class_5819 random, class_2338 pos) {
        return (class_2680)either.map(provider -> provider.method_23455(random, pos), material -> ChemicalHelper.getBlock(settings.providerMaterialPrefix, material).method_9564());
    }

    @Override
    public VeinGenerator build() {
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new GeodeVeinGenerator(this.geodeBlockSettings, this.geodeLayerSettings, this.geodeCrackSettings, this.usePotentialPlacementsChance, this.useAlternateLayer0Chance, this.placementsRequireLayer0Alternate, this.outerWallDistance, this.distributionPoints, this.pointOffset, this.minGenOffset, this.maxGenOffset, this.noiseMultiplier, this.invalidBlocksThreshold);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    public GeodeVeinGenerator(GeodeBlockSettings geodeBlockSettings, class_5587 geodeLayerSettings, class_5586 geodeCrackSettings, double usePotentialPlacementsChance, double useAlternateLayer0Chance, boolean placementsRequireLayer0Alternate, class_6017 outerWallDistance, class_6017 distributionPoints, class_6017 pointOffset, int minGenOffset, int maxGenOffset, double noiseMultiplier, int invalidBlocksThreshold) {
        this.geodeBlockSettings = geodeBlockSettings;
        this.geodeLayerSettings = geodeLayerSettings;
        this.geodeCrackSettings = geodeCrackSettings;
        this.usePotentialPlacementsChance = usePotentialPlacementsChance;
        this.useAlternateLayer0Chance = useAlternateLayer0Chance;
        this.placementsRequireLayer0Alternate = placementsRequireLayer0Alternate;
        this.outerWallDistance = outerWallDistance;
        this.distributionPoints = distributionPoints;
        this.pointOffset = pointOffset;
        this.minGenOffset = minGenOffset;
        this.maxGenOffset = maxGenOffset;
        this.noiseMultiplier = noiseMultiplier;
        this.invalidBlocksThreshold = invalidBlocksThreshold;
    }

    public GeodeVeinGenerator geodeBlockSettings(GeodeBlockSettings geodeBlockSettings) {
        this.geodeBlockSettings = geodeBlockSettings;
        return this;
    }

    public GeodeVeinGenerator geodeLayerSettings(class_5587 geodeLayerSettings) {
        this.geodeLayerSettings = geodeLayerSettings;
        return this;
    }

    public GeodeVeinGenerator geodeCrackSettings(class_5586 geodeCrackSettings) {
        this.geodeCrackSettings = geodeCrackSettings;
        return this;
    }

    public GeodeVeinGenerator usePotentialPlacementsChance(double usePotentialPlacementsChance) {
        this.usePotentialPlacementsChance = usePotentialPlacementsChance;
        return this;
    }

    public GeodeVeinGenerator useAlternateLayer0Chance(double useAlternateLayer0Chance) {
        this.useAlternateLayer0Chance = useAlternateLayer0Chance;
        return this;
    }

    public GeodeVeinGenerator placementsRequireLayer0Alternate(boolean placementsRequireLayer0Alternate) {
        this.placementsRequireLayer0Alternate = placementsRequireLayer0Alternate;
        return this;
    }

    public GeodeVeinGenerator outerWallDistance(class_6017 outerWallDistance) {
        this.outerWallDistance = outerWallDistance;
        return this;
    }

    public GeodeVeinGenerator distributionPoints(class_6017 distributionPoints) {
        this.distributionPoints = distributionPoints;
        return this;
    }

    public GeodeVeinGenerator pointOffset(class_6017 pointOffset) {
        this.pointOffset = pointOffset;
        return this;
    }

    public GeodeVeinGenerator minGenOffset(int minGenOffset) {
        this.minGenOffset = minGenOffset;
        return this;
    }

    public GeodeVeinGenerator maxGenOffset(int maxGenOffset) {
        this.maxGenOffset = maxGenOffset;
        return this;
    }

    public GeodeVeinGenerator noiseMultiplier(double noiseMultiplier) {
        this.noiseMultiplier = noiseMultiplier;
        return this;
    }

    public GeodeVeinGenerator invalidBlocksThreshold(int invalidBlocksThreshold) {
        this.invalidBlocksThreshold = invalidBlocksThreshold;
        return this;
    }

    private static /* synthetic */ class_2680 lambda$getAllEntries$18(class_5819 source, class_4651 provider) {
        return provider.method_23455(source, class_2338.field_10980);
    }

    private static /* synthetic */ class_2680 lambda$getAllEntries$17(class_5819 source, class_4651 provider) {
        return provider.method_23455(source, class_2338.field_10980);
    }

    private static /* synthetic */ class_2680 lambda$getAllEntries$16(class_5819 source, class_4651 provider) {
        return provider.method_23455(source, class_2338.field_10980);
    }

    private static /* synthetic */ class_2680 lambda$getAllEntries$15(class_5819 source, class_4651 provider) {
        return provider.method_23455(source, class_2338.field_10980);
    }

    private static /* synthetic */ class_2680 lambda$getAllEntries$14(class_5819 source, class_4651 provider) {
        return provider.method_23455(source, class_2338.field_10980);
    }

    public record GeodeBlockSettings(Either<class_4651, Material> fillingProvider, Either<class_4651, Material> innerLayerProvider, Either<class_4651, Material> alternateInnerLayerProvider, Either<class_4651, Material> middleLayerProvider, Either<class_4651, Material> outerLayerProvider, List<class_2680> innerPlacements, class_6862<class_2248> cannotReplace, class_6862<class_2248> invalidBlocks, @Nullable TagPrefix providerMaterialPrefix) {
        public static final Codec<GeodeBlockSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)class_4651.field_24937, GTRegistries.MATERIALS.codec()).fieldOf("filling_provider").forGetter(config -> config.fillingProvider), (App)Codec.either((Codec)class_4651.field_24937, GTRegistries.MATERIALS.codec()).fieldOf("inner_layer_provider").forGetter(config -> config.innerLayerProvider), (App)Codec.either((Codec)class_4651.field_24937, GTRegistries.MATERIALS.codec()).fieldOf("alternate_inner_layer_provider").forGetter(config -> config.alternateInnerLayerProvider), (App)Codec.either((Codec)class_4651.field_24937, GTRegistries.MATERIALS.codec()).fieldOf("middle_layer_provider").forGetter(config -> config.middleLayerProvider), (App)Codec.either((Codec)class_4651.field_24937, GTRegistries.MATERIALS.codec()).fieldOf("outer_layer_provider").forGetter(config -> config.outerLayerProvider), (App)class_5699.method_36973((Codec)class_2680.field_24734.listOf()).fieldOf("inner_placements").forGetter(config -> config.innerPlacements), (App)class_6862.method_40093((class_5321)class_7924.field_41254).fieldOf("cannot_replace").forGetter(config -> config.cannotReplace), (App)class_6862.method_40093((class_5321)class_7924.field_41254).fieldOf("invalid_blocks").forGetter(config -> config.invalidBlocks), (App)TagPrefix.CODEC.optionalFieldOf("provider_material_prefix", (Object)TagPrefix.block).forGetter(config -> config.providerMaterialPrefix)).apply((Applicative)instance, GeodeBlockSettings::new));
    }
}

