/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2919;
import net.minecraft.class_3124;
import net.minecraft.class_3532;
import net.minecraft.class_3818;
import net.minecraft.class_3825;
import net.minecraft.class_4076;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5867;
import net.minecraft.class_6677;

public class DikeVeinGenerator
extends VeinGenerator {
    public static final Codec<DikeVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(DikeBlockDefinition.CODEC).fieldOf("blocks").forGetter(it -> it.blocks), (App)Codec.INT.fieldOf("min_y").forGetter(it -> it.minYLevel), (App)Codec.INT.fieldOf("max_y").forGetter(it -> it.maxYLevel)).apply((Applicative)instance, DikeVeinGenerator::new));
    public List<DikeBlockDefinition> blocks;
    public int minYLevel;
    public int maxYLevel;

    public DikeVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<Map.Entry<Either<class_2680, Material>, Integer>> getAllEntries() {
        return this.blocks.stream().flatMap(definition -> (Stream)definition.block.map(state -> state.stream().map(target -> Map.entry(Either.left((Object)target.field_29069), definition.weight)), material -> Stream.of(Map.entry(Either.right((Object)material), definition.weight)))).collect(Collectors.toList());
    }

    @Override
    public Map<class_2338, OreBlockPlacer> generate(class_5281 level, class_5819 random, GTOreDefinition entry, class_2338 origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        class_2919 worldgenRandom = new class_2919((class_5819)new class_5820(level.method_8412()));
        class_5216 normalNoise = class_5216.method_31927((class_5819)worldgenRandom, (int)-2, (double[])new double[]{4.0});
        class_1923 chunkPos = new class_1923(origin);
        float density = entry.density();
        int size = entry.clusterSize();
        int radius = class_3532.method_15386((float)((float)size / 2.0f));
        int xPos = chunkPos.method_8326() + level.method_8409().method_43048(16);
        int zPos = chunkPos.method_8328() + level.method_8409().method_43048(16);
        int yTop = this.maxYLevel;
        int yBottom = this.minYLevel;
        class_2338 basePos = new class_2338(xPos, yBottom, zPos);
        for (int dY = yBottom; dY <= yTop; ++dY) {
            for (int dX = -radius; dX <= radius; ++dX) {
                for (int dZ = -radius; dZ <= radius; ++dZ) {
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)(radius * 2)) continue;
                    class_2338 pos = new class_2338(basePos.method_10263() + dX, dY, basePos.method_10260() + dZ);
                    if (!(normalNoise.method_27406((double)dX, (double)dY, (double)dZ) >= 0.5) || !(random.method_43057() <= density)) continue;
                    long randomSeed = random.method_43055();
                    generatedBlocks.put(pos, (access, section) -> this.placeBlock(access, section, randomSeed, pos, entry));
                }
            }
        }
        return generatedBlocks;
    }

    private void placeBlock(class_5867 level, class_2826 section, long randomSeed, class_2338 pos, GTOreDefinition entry) {
        class_6677 rand = new class_6677(randomSeed);
        List<Map.Entry> entries = this.blocks.stream().map(b -> Map.entry(b.weight, b)).toList();
        DikeBlockDefinition blockDefinition = this.blocks.get(GTUtil.getRandomItem((class_5819)rand, entries, entries.size()));
        class_2680 current = level.method_33946(pos);
        int x = class_4076.method_18684((int)pos.method_10263());
        int y = class_4076.method_18684((int)pos.method_10264());
        int z = class_4076.method_18684((int)pos.method_10260());
        if (pos.method_10264() >= blockDefinition.minY() && pos.method_10264() <= blockDefinition.maxY()) {
            blockDefinition.block.ifLeft(blockStates -> {
                for (class_3124.class_5876 targetState : blockStates) {
                    if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((class_5867)level).method_33946(arg_0), (class_5819)rand, entry, targetState, pos.method_25503()) || targetState.field_29069.method_26215()) continue;
                    section.method_12256(x, y, z, targetState.field_29069, false);
                    break;
                }
            }).ifRight(material -> {
                if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((class_5867)level).method_33946(arg_0), (class_5819)rand, entry, pos.method_25503())) {
                    return;
                }
                class_2680 currentState = level.method_33946(pos);
                Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
                if (prefix.isEmpty()) {
                    return;
                }
                class_2248 toPlace = ChemicalHelper.getBlock(prefix.get(), material);
                if (toPlace == null || toPlace.method_9564().method_26215()) {
                    return;
                }
                section.method_12256(x, y, z, toPlace.method_9564(), false);
            });
        }
    }

    @Override
    public VeinGenerator build() {
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new DikeVeinGenerator(this.blocks, this.minYLevel, this.maxYLevel);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    public DikeVeinGenerator withBlock(Material block, int weight, int minY, int maxY) {
        return this.withBlock(new DikeBlockDefinition(block, weight, minY, maxY));
    }

    public DikeVeinGenerator withBlock(class_2680 blockState, int weight, int minY, int maxY) {
        class_3124.class_5876 target = class_3124.method_33994((class_3825)class_3818.field_16868, (class_2680)blockState);
        return this.withBlock(new DikeBlockDefinition(List.of(target), weight, minY, maxY));
    }

    public DikeVeinGenerator withBlock(DikeBlockDefinition block) {
        if (this.blocks == null) {
            this.blocks = new ArrayList<DikeBlockDefinition>();
        }
        this.blocks.add(block);
        return this;
    }

    public DikeVeinGenerator(List<DikeBlockDefinition> blocks, int minYLevel, int maxYLevel) {
        this.blocks = blocks;
        this.minYLevel = minYLevel;
        this.maxYLevel = maxYLevel;
    }

    public DikeVeinGenerator minYLevel(int minYLevel) {
        this.minYLevel = minYLevel;
        return this;
    }

    public DikeVeinGenerator maxYLevel(int maxYLevel) {
        this.maxYLevel = maxYLevel;
        return this;
    }

    public record DikeBlockDefinition(Either<List<class_3124.class_5876>, Material> block, int weight, int minY, int maxY) {
        public static final Codec<DikeBlockDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)class_3124.class_5876.field_29067.listOf(), GTRegistries.MATERIALS.codec()).fieldOf("block").forGetter(x -> x.block), (App)Codec.INT.fieldOf("weight").forGetter(x -> x.weight), (App)Codec.INT.fieldOf("min_y").orElse((Object)320).forGetter(x -> x.minY), (App)Codec.INT.fieldOf("max_y").orElse((Object)-64).forGetter(x -> x.maxY)).apply((Applicative)instance, DikeBlockDefinition::new));

        public DikeBlockDefinition(Material block, int weight, int minY, int maxY) {
            this((Either<List<class_3124.class_5876>, Material>)Either.right((Object)block), weight, minY, maxY);
        }

        public DikeBlockDefinition(List<class_3124.class_5876> block, int weight, int minY, int maxY) {
            this((Either<List<class_3124.class_5876>, Material>)Either.left(block), weight, minY, maxY);
        }
    }
}

