/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public abstract class VeinGenerator {
    public static final Codec<Codec<? extends VeinGenerator>> REGISTRY_CODEC = class_2960.field_25139.flatXmap(rl -> Optional.ofNullable((Codec)WorldGeneratorUtils.VEIN_GENERATORS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No VeinGenerator with id " + rl + " registered")), obj -> Optional.ofNullable((class_2960)WorldGeneratorUtils.VEIN_GENERATORS.inverse().get(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "VeinGenerator " + obj + " not registered")));
    public static final Codec<VeinGenerator> DIRECT_CODEC = REGISTRY_CODEC.dispatchStable(VeinGenerator::codec, Function.identity());
    protected GTOreDefinition entry;

    public VeinGenerator() {
    }

    public VeinGenerator(GTOreDefinition entry) {
        this.entry = entry;
    }

    public abstract List<Map.Entry<Either<class_2680, Material>, Integer>> getAllEntries();

    public List<class_2680> getAllBlocks() {
        return this.getAllEntries().stream().map(entry -> (class_2680)((Either)entry.getKey()).map(Function.identity(), material -> ChemicalHelper.getBlock(TagPrefix.ore, material).method_9564())).toList();
    }

    public List<Material> getAllMaterials() {
        return this.getAllEntries().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).map(either -> (Material)either.map(state -> ChemicalHelper.getMaterial((class_1935)state.method_26204()) != null ? ChemicalHelper.getMaterial((class_1935)state.method_26204()).material() : null, Function.identity())).filter(Objects::nonNull).toList();
    }

    public List<Integer> getAllChances() {
        return this.getAllEntries().stream().map(Map.Entry::getValue).toList();
    }

    public List<Map.Entry<Integer, Material>> getValidMaterialsChances() {
        return this.getAllEntries().stream().filter(entry -> ((Either)entry.getKey()).map(state -> ChemicalHelper.getMaterial((class_1935)state.method_26204()) != null ? ChemicalHelper.getMaterial((class_1935)state.method_26204()).material() : null, Function.identity()) != null).map(entry -> Map.entry((Integer)entry.getValue(), (Material)((Either)entry.getKey()).map(state -> ChemicalHelper.getMaterial((class_1935)state.method_26204()) != null ? ChemicalHelper.getMaterial((class_1935)state.method_26204()).material() : null, Function.identity()))).collect(Collectors.toList());
    }

    @HideFromJS
    public abstract Map<class_2338, OreBlockPlacer> generate(class_5281 var1, class_5819 var2, GTOreDefinition var3, class_2338 var4);

    @HideFromJS
    public abstract VeinGenerator build();

    public abstract VeinGenerator copy();

    @HideFromJS
    public GTOreDefinition parent() {
        return this.entry;
    }

    public abstract Codec<? extends VeinGenerator> codec();
}

