/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.OreVeinWorldEntry;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_6880;

@ParametersAreNonnullByDefault
@class_6328
public class BedrockOreVeinSavedData
extends class_18 {
    public static final int VEIN_CHUNK_SIZE = 3;
    public static final int MAXIMUM_VEIN_OPERATIONS = 100000;
    public final HashMap<class_1923, OreVeinWorldEntry> veinOres = new HashMap();
    private final HashMap<class_6880<class_1959>, Integer> biomeWeights = new HashMap();
    private final class_3218 serverLevel;

    public static BedrockOreVeinSavedData getOrCreate(class_3218 serverLevel) {
        return (BedrockOreVeinSavedData)serverLevel.method_17983().method_17924(tag -> new BedrockOreVeinSavedData(serverLevel, (class_2487)tag), () -> new BedrockOreVeinSavedData(serverLevel), "gtceu_bedrock_ore");
    }

    public BedrockOreVeinSavedData(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
    }

    public BedrockOreVeinSavedData(class_3218 serverLevel, class_2487 nbt) {
        this(serverLevel);
        class_2499 list = nbt.method_10554("veinInfo", 10);
        for (class_2520 tag : list) {
            if (!(tag instanceof class_2487)) continue;
            class_2487 compoundTag = (class_2487)tag;
            class_1923 chunkPos = new class_1923(compoundTag.method_10537("pos"));
            this.veinOres.put(chunkPos, OreVeinWorldEntry.readFromNBT(compoundTag.method_10562("data")));
        }
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 oreList = new class_2499();
        for (Map.Entry<class_1923, OreVeinWorldEntry> entry : this.veinOres.entrySet()) {
            class_2487 tag = new class_2487();
            tag.method_10544("pos", entry.getKey().method_8324());
            tag.method_10566("data", (class_2520)entry.getValue().writeToNBT());
            oreList.add((Object)tag);
        }
        nbt.method_10566("veinInfo", (class_2520)oreList);
        return nbt;
    }

    public OreVeinWorldEntry getOreVeinWorldEntry(int chunkX, int chunkZ) {
        class_1923 pos = new class_1923(chunkX, chunkZ);
        if (!this.veinOres.containsKey(pos)) {
            GTOreDefinition definition = null;
            int query = class_5819.method_43049((long)Objects.hash(this.serverLevel.method_8412(), chunkX / 3, chunkZ / 3)).method_43054();
            class_6880 biome = this.serverLevel.method_23753(new class_2338(chunkX << 4, 64, chunkZ << 4));
            int totalWeight = this.getTotalWeight((class_6880<class_1959>)biome);
            if (totalWeight > 0) {
                int weight = Math.abs(query % totalWeight);
                for (GTOreDefinition oreDefinition : GTRegistries.ORE_VEINS) {
                    int veinWeight = oreDefinition.weight() + (oreDefinition.biomeWeightModifier() != null ? oreDefinition.biomeWeightModifier().apply((class_6880<class_1959>)biome) : 0);
                    if (veinWeight <= 0 || !oreDefinition.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((class_5321<class_1937>)dim, (class_5321<class_1937>)this.serverLevel.method_27983())) || (weight -= veinWeight) >= 0) continue;
                    definition = oreDefinition;
                    break;
                }
            }
            class_5819 random = class_5819.method_43049((long)(961L * (long)chunkX + (long)chunkZ * 31L + (long)Long.hashCode(this.serverLevel.method_8412())));
            int maximumYield = 0;
            if (definition != null) {
                maximumYield = definition.maximumYield() - definition.minimumYield() <= 0 ? definition.minimumYield() : random.method_43048(definition.maximumYield() - definition.minimumYield()) + definition.minimumYield();
                maximumYield = Math.round((float)Math.min(maximumYield, definition.maximumYield()) * ConfigHolder.INSTANCE.worldgen.oreVeins.bedrockOreMultiplier);
            }
            this.veinOres.put(new class_1923(chunkX, chunkZ), new OreVeinWorldEntry(definition, maximumYield, 100000));
            this.method_80();
        }
        return this.veinOres.get(pos);
    }

    public void createVein(class_1923 pos, GTOreDefinition definition) {
        if (definition != null) {
            int radius = class_4076.method_42615((double)((float)definition.clusterSize() / 2.0f));
            for (int x = pos.field_9181 - radius; x <= pos.field_9181 + radius; ++x) {
                for (int z = pos.field_9180 - radius; z <= pos.field_9180 + radius; ++z) {
                    class_1923 pos2 = new class_1923(x, z);
                    if (this.veinOres.containsKey(pos2)) continue;
                    float distanceFromOriginal = Math.abs(pos.field_9181 - x) + Math.abs(pos.field_9180 - z);
                    distanceFromOriginal = distanceFromOriginal == 0.0f ? 1.0f : distanceFromOriginal;
                    distanceFromOriginal = (float)Math.pow(distanceFromOriginal, 2.0);
                    class_5819 random = class_5819.method_43049((long)(961L * (long)pos2.field_9181 + (long)pos2.field_9180 * 31L + (long)Long.hashCode(this.serverLevel.method_8412())));
                    int maximumYield = 0;
                    if ((float)(definition.maximumYield() - definition.minimumYield()) / distanceFromOriginal <= 0.0f) {
                        maximumYield = definition.minimumYield();
                    } else {
                        maximumYield = (int)((float)random.method_43048(definition.maximumYield() - definition.minimumYield() + definition.minimumYield()) / distanceFromOriginal);
                        maximumYield = Math.max(maximumYield, definition.minimumYield());
                    }
                    maximumYield = Math.min(maximumYield, definition.maximumYield());
                    this.veinOres.put(pos2, new OreVeinWorldEntry(definition, maximumYield, 100000));
                }
            }
        }
    }

    public int getTotalWeight(class_6880<class_1959> biome) {
        return this.biomeWeights.computeIfAbsent(biome, b -> {
            int totalWeight = 0;
            for (GTOreDefinition definition : GTRegistries.ORE_VEINS) {
                if (!definition.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((class_5321<class_1937>)dim, (class_5321<class_1937>)this.serverLevel.method_27983()))) continue;
                totalWeight += definition.biomeWeightModifier() != null ? definition.biomeWeightModifier().apply(biome) : 0;
                totalWeight += definition.weight();
            }
            return totalWeight;
        });
    }

    public int getOreYield(int chunkX, int chunkZ) {
        return this.getOreVeinWorldEntry(chunkX, chunkZ).getOreYield();
    }

    public int getDepletedOreYield(int chunkX, int chunkZ) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return 0;
        }
        return info.getDefinition().depletedYield();
    }

    public int getOperationsRemaining(int chunkX, int chunkZ) {
        return this.getOreVeinWorldEntry(chunkX, chunkZ).getOperationsRemaining();
    }

    @Nullable
    public List<Map.Entry<Integer, Material>> getOreInChunk(int chunkX, int chunkZ) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return null;
        }
        return info.getDefinition().getBedrockVeinMaterials();
    }

    public void depleteVein(int chunkX, int chunkZ, int amount, boolean ignoreVeinStats) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (ignoreVeinStats) {
            info.decreaseOperations(amount);
            if (amount != 0) {
                this.method_80();
            }
            return;
        }
        GTOreDefinition definition = info.getDefinition();
        if (definition == null || definition.depletionChance() == 0) {
            return;
        }
        if (definition.depletionChance() == 100 || GTValues.RNG.method_43048(100) <= definition.depletionChance()) {
            info.decreaseOperations(definition.depletionAmount());
            this.method_80();
        }
    }
}

