/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid;

import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBedrockFluids;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BedrockFluidDefinition {
    public static final MapCodec<Pair<Integer, Integer>> YIELD = Codec.mapPair((MapCodec)Codec.INT.fieldOf("min"), (MapCodec)Codec.INT.fieldOf("max"));
    public static final Codec<BedrockFluidDefinition> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("weight").forGetter(ft -> ft.weight), (App)YIELD.fieldOf("yield").forGetter(ft -> Pair.of((Object)ft.minimumYield, (Object)ft.maximumYield)), (App)Codec.INT.fieldOf("depletion_amount").forGetter(ft -> ft.depletionAmount), (App)Codec.INT.fieldOf("depletion_chance").forGetter(ft -> ft.depletionChance), (App)Codec.INT.fieldOf("depleted_yield").forGetter(ft -> ft.depletedYield), (App)class_7923.field_41173.method_39673().fieldOf("fluid").forGetter(ft -> ft.storedFluid.get()), (App)BiomeWeightModifier.CODEC.listOf().optionalFieldOf("weight_modifier", null).forGetter(ft -> ft.originalModifiers), (App)class_5321.method_39154((class_5321)class_7924.field_41223).listOf().fieldOf("dimension_filter").forGetter(ft -> new ArrayList<class_5321<class_1937>>(ft.dimensionFilter))).apply((Applicative)instance, (weight, yield, depletionAmount, depletionChance, depletedYield, storedFluid, biomeWeightModifier, dimensionFilter) -> new BedrockFluidDefinition((int)weight, (Integer)yield.getFirst(), (Integer)yield.getSecond(), (int)depletionAmount, (int)depletionChance, (int)depletedYield, () -> storedFluid, (List<BiomeWeightModifier>)biomeWeightModifier, (Set<class_5321<class_1937>>)new HashSet<class_5321<class_1937>>((Collection<class_5321<class_1937>>)dimensionFilter))));
    private int weight;
    private int minimumYield;
    private int maximumYield;
    private int depletionAmount;
    private int depletionChance;
    private int depletedYield;
    private Supplier<class_3611> storedFluid;
    private BiomeWeightModifier biomeWeightModifier;
    private List<BiomeWeightModifier> originalModifiers;
    public Set<class_5321<class_1937>> dimensionFilter;

    public BedrockFluidDefinition(class_2960 name, int weight, int minimumYield, int maximumYield, int depletionAmount, int depletionChance, int depletedYield, Supplier<class_3611> storedFluid, List<BiomeWeightModifier> originalModifiers, Set<class_5321<class_1937>> dimensionFilter) {
        this(weight, minimumYield, maximumYield, depletionAmount, depletionChance, depletedYield, storedFluid, originalModifiers, dimensionFilter);
        GTRegistries.BEDROCK_FLUID_DEFINITIONS.register(name, this);
    }

    public BedrockFluidDefinition(int weight, int minimumYield, int maximumYield, int depletionAmount, int depletionChance, int depletedYield, Supplier<class_3611> storedFluid, final List<BiomeWeightModifier> originalModifiers, Set<class_5321<class_1937>> dimensionFilter) {
        this.weight = weight;
        this.minimumYield = minimumYield;
        this.maximumYield = maximumYield;
        this.depletionAmount = depletionAmount;
        this.depletionChance = depletionChance;
        this.depletedYield = depletedYield;
        this.storedFluid = storedFluid;
        this.originalModifiers = originalModifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> class_6885.method_40242(originalModifiers.stream().flatMap(mod -> mod.biomes.get().method_40239()).toList()), originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public Integer apply(class_6880<class_1959> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : originalModifiers) {
                    if (!modifier.biomes.get().method_40241(biome)) continue;
                    mod += modifier.apply(biome).intValue();
                }
                return mod;
            }
        };
        this.dimensionFilter = dimensionFilter;
    }

    public void setOriginalModifiers(List<BiomeWeightModifier> modifiers) {
        this.originalModifiers = modifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> class_6885.method_40242(this.originalModifiers.stream().flatMap(mod -> mod.biomes.get().method_40239()).toList()), this.originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public Integer apply(class_6880<class_1959> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : BedrockFluidDefinition.this.originalModifiers) {
                    if (!modifier.biomes.get().method_40241(biome)) continue;
                    mod += modifier.apply(biome).intValue();
                }
                return mod;
            }
        };
    }

    public static Builder builder(class_2960 name) {
        return new Builder(name);
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getMinimumYield() {
        return this.minimumYield;
    }

    public int getMaximumYield() {
        return this.maximumYield;
    }

    public void setMinimumYield(int minimumYield) {
        this.minimumYield = minimumYield;
    }

    public void setMaximumYield(int maximumYield) {
        this.maximumYield = maximumYield;
    }

    public int getDepletionAmount() {
        return this.depletionAmount;
    }

    public void setDepletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
    }

    public int getDepletionChance() {
        return this.depletionChance;
    }

    public void setDepletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
    }

    public int getDepletedYield() {
        return this.depletedYield;
    }

    public void setDepletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
    }

    public Supplier<class_3611> getStoredFluid() {
        return this.storedFluid;
    }

    public void setStoredFluid(Supplier<class_3611> storedFluid) {
        this.storedFluid = storedFluid;
    }

    public BiomeWeightModifier getBiomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    public Set<class_5321<class_1937>> getDimensionFilter() {
        return this.dimensionFilter;
    }

    public void setDimensionFilter(Set<class_5321<class_1937>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
    }

    public static class Builder {
        private final class_2960 name;
        private int weight;
        private int minimumYield;
        private int maximumYield;
        private int depletionAmount;
        private int depletionChance = 1;
        private int depletedYield;
        private Supplier<class_3611> fluid;
        private Set<class_5321<class_1937>> dimensions;
        private final List<BiomeWeightModifier> biomes = new LinkedList<BiomeWeightModifier>();

        private Builder(class_2960 name) {
            this.name = name;
        }

        public Builder copy(class_2960 name) {
            Builder copied = new Builder(name);
            copied.weight = this.weight;
            copied.minimumYield = this.minimumYield;
            copied.maximumYield = this.maximumYield;
            copied.depletionAmount = this.depletionAmount;
            copied.depletionChance = this.depletionChance;
            copied.depletedYield = this.depletedYield;
            copied.fluid = this.fluid;
            return copied;
        }

        public Builder yield(int min, int max) {
            return this.minimumYield(min).maximumYield(max);
        }

        public Builder biomes(int weight, class_6862<class_1959> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> GTRegistries.builtinRegistry().method_30530(class_7924.field_41236).method_40260(biomes), weight));
            return this;
        }

        @SafeVarargs
        public final Builder biomes(int weight, class_5321<class_1959> ... biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> class_6885.method_40245(arg_0 -> ((class_2378)GTRegistries.builtinRegistry().method_30530(class_7924.field_41236)).method_40290(arg_0), (Object[])biomes), weight));
            return this;
        }

        public Builder biomes(int weight, class_6885<class_1959> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> biomes, weight));
            return this;
        }

        public BedrockFluidDefinition register() {
            BedrockFluidDefinition definition = new BedrockFluidDefinition(this.weight, this.minimumYield, this.maximumYield, this.depletionAmount, this.depletionChance, this.depletedYield, this.fluid, this.biomes, this.dimensions);
            GTBedrockFluids.toReRegister.put(this.name, definition);
            return definition;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder minimumYield(int minimumYield) {
            this.minimumYield = minimumYield;
            return this;
        }

        public Builder maximumYield(int maximumYield) {
            this.maximumYield = maximumYield;
            return this;
        }

        public Builder depletionAmount(int depletionAmount) {
            this.depletionAmount = depletionAmount;
            return this;
        }

        public Builder depletionChance(int depletionChance) {
            this.depletionChance = depletionChance;
            return this;
        }

        public Builder depletedYield(int depletedYield) {
            this.depletedYield = depletedYield;
            return this;
        }

        public Builder fluid(Supplier<class_3611> fluid) {
            this.fluid = fluid;
            return this;
        }

        public Builder dimensions(Set<class_5321<class_1937>> dimensions) {
            this.dimensions = dimensions;
            return this;
        }
    }
}

