/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.google.common.collect.HashBiMap;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3798;
import net.minecraft.class_3825;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class WorldGeneratorUtils {
    public static final class_3825 END_ORE_REPLACEABLES = new class_3798(CustomTags.ENDSTONE_ORE_REPLACEABLES);
    private static final Map<class_3218, WorldOreVeinCache> oreVeinCache = new WeakHashMap<class_3218, WorldOreVeinCache>();
    public static final SortedMap<String, IWorldGenLayer> WORLD_GEN_LAYERS = new Object2ObjectLinkedOpenHashMap();
    public static final HashBiMap<class_2960, Codec<? extends VeinGenerator>> VEIN_GENERATORS = HashBiMap.create();
    public static final HashBiMap<class_2960, Function<GTOreDefinition, ? extends VeinGenerator>> VEIN_GENERATOR_FUNCTIONS = HashBiMap.create();
    public static final HashBiMap<class_2960, Codec<? extends IndicatorGenerator>> INDICATOR_GENERATORS = HashBiMap.create();
    public static final HashBiMap<class_2960, Function<GTOreDefinition, ? extends IndicatorGenerator>> INDICATOR_GENERATOR_FUNCTIONS = HashBiMap.create();

    public static List<Map.Entry<Integer, GTOreDefinition>> getCachedBiomeVeins(class_3218 level, class_6880<class_1959> biome, class_5819 random) {
        if (oreVeinCache.containsKey(level)) {
            return oreVeinCache.get(level).getEntry(biome);
        }
        WorldOreVeinCache worldOreVeinCache = new WorldOreVeinCache(level);
        oreVeinCache.put(level, worldOreVeinCache);
        return worldOreVeinCache.getEntry(biome);
    }

    public static Optional<String> getWorldGenLayerKey(IWorldGenLayer layer) {
        return WORLD_GEN_LAYERS.entrySet().stream().filter(entry -> ((IWorldGenLayer)entry.getValue()).equals(layer)).map(Map.Entry::getKey).findFirst();
    }

    public static boolean isSameDimension(class_5321<class_1937> first, class_5321<class_1937> second) {
        return first.method_29177().equals((Object)second.method_29177());
    }

    public static <T> Map<class_1923, Map<class_2338, T>> groupByChunks(Map<class_2338, T> input) {
        return (Map)input.entrySet().stream().collect(Collectors.groupingBy(entry -> new class_1923((class_2338)entry.getKey()), Object2ObjectOpenHashMap::new, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, Object2ObjectOpenHashMap::new)));
    }

    public static <T> Map<class_1923, List<class_2338>> groupByChunks(Collection<class_2338> positions) {
        return positions.stream().collect(Collectors.groupingBy(class_1923::new));
    }

    public static Collection<class_1923> getChunks(Collection<class_2338> positions) {
        return positions.stream().collect(Collectors.groupingBy(class_1923::new)).keySet();
    }

    public static void generateChunks(class_5281 level, class_2806 requiredStatus, Collection<class_1923> chunks) {
        ObjectArrayList previouslyUnloadedChunks = new ObjectArrayList();
        class_2802 chunkSource = level.method_8398();
        for (class_1923 chunkPos : chunks) {
            class_2818 chunk2 = chunkSource.method_12126(chunkPos.field_9181, chunkPos.field_9180, false);
            if (chunk2 == null) {
                previouslyUnloadedChunks.add(chunkPos);
            }
            chunkSource.method_12121(chunkPos.field_9181, chunkPos.field_9180, requiredStatus, true);
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            previouslyUnloadedChunks.forEach(chunk -> serverLevel.method_18764(serverLevel.method_8497(chunk.field_9181, chunk.field_9180)));
        }
    }

    public static Optional<class_2338> findBlockPos(class_2338 initialPos, Predicate<class_2338> predicate, Consumer<class_2338.class_2339> step, int maxSteps) {
        class_2338.class_2339 currentPos = initialPos.method_25503();
        while (maxSteps-- >= 0) {
            step.accept(currentPos);
            if (!predicate.test((class_2338)currentPos)) continue;
            return Optional.of(currentPos.method_10062());
        }
        return Optional.empty();
    }

    private static class WorldOreVeinCache {
        private final List<GTOreDefinition> worldVeins;
        private final List<Map.Entry<Integer, GTOreDefinition>> veins = new LinkedList<Map.Entry<Integer, GTOreDefinition>>();

        public WorldOreVeinCache(class_3218 level) {
            this.worldVeins = GTRegistries.ORE_VEINS.values().stream().filter(entry -> entry.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((class_5321<class_1937>)dim, (class_5321<class_1937>)level.method_27983()))).collect(Collectors.toList());
        }

        private List<Map.Entry<Integer, GTOreDefinition>> getEntry(class_6880<class_1959> biome) {
            if (!this.veins.isEmpty()) {
                return this.veins;
            }
            List<Map.Entry<Integer, GTOreDefinition>> result = this.worldVeins.stream().filter(entry -> entry.biomes() == null || entry.biomes().get().method_40241(biome)).map(vein -> new AbstractMap.SimpleEntry<Integer, GTOreDefinition>(vein.weight() + (vein.biomeWeightModifier() == null ? 0 : vein.biomeWeightModifier().apply(biome)), (GTOreDefinition)vein)).filter(entry -> (Integer)entry.getKey() > 0).collect(Collectors.toList());
            this.veins.addAll(result);
            return result;
        }
    }
}

