/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.data.recipe.misc.alloyblast.AlloyBlastRecipeProducer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_3611;

public class AlloyBlastProperty
implements IMaterialProperty<AlloyBlastProperty> {
    private Supplier<? extends class_3611> fluidSupplier;
    private int temperature;
    @Nonnull
    private AlloyBlastRecipeProducer recipeProducer = AlloyBlastRecipeProducer.DEFAULT_PRODUCER;

    public AlloyBlastProperty(int temperature) {
        this.temperature = temperature;
    }

    @Override
    public void verifyProperty(MaterialProperties materialProperties) {
        materialProperties.ensureSet(PropertyKey.BLAST);
        materialProperties.ensureSet(PropertyKey.FLUID);
        this.temperature = materialProperties.getProperty(PropertyKey.BLAST).getBlastTemperature();
    }

    public void setFluid(@Nonnull Supplier<? extends class_3611> materialFluid) {
        Preconditions.checkNotNull(materialFluid);
        this.fluidSupplier = materialFluid;
    }

    public class_3611 getFluid() {
        return this.fluidSupplier.get();
    }

    public void setTemperature(int fluidTemperature) {
        Preconditions.checkArgument((fluidTemperature > 0 ? 1 : 0) != 0, (Object)"Invalid temperature");
        this.temperature = fluidTemperature;
    }

    public int getTemperature() {
        return this.temperature;
    }

    @Nonnull
    public AlloyBlastRecipeProducer getRecipeProducer() {
        return this.recipeProducer;
    }

    public void setRecipeProducer(@Nonnull AlloyBlastRecipeProducer recipeProducer) {
        if (recipeProducer == null) {
            throw new NullPointerException("recipeProducer is marked non-null but is null");
        }
        this.recipeProducer = recipeProducer;
    }
}

