/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.data.tags.TagsHandler;
import com.lowdragmc.lowdraglib.Platform;
import com.tterrag.registrate.util.entry.BlockEntry;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ChemicalHelper {
    public static final Map<class_1935, ItemMaterialInfo> ITEM_MATERIAL_INFO = new Object2ObjectLinkedOpenHashMap();
    public static final Map<class_1935, UnificationEntry> ITEM_UNIFICATION_ENTRY = new Object2ObjectLinkedOpenHashMap();
    public static final Map<class_6862<class_1792>, UnificationEntry> TAG_UNIFICATION_ENTRY = new Object2ObjectLinkedOpenHashMap();
    public static final Map<class_3611, Material> FLUID_MATERIAL = new Object2ObjectLinkedOpenHashMap();
    public static final Map<UnificationEntry, ArrayList<class_1935>> UNIFICATION_ENTRY_ITEM = new Object2ObjectLinkedOpenHashMap();
    public static final Map<UnificationEntry, ArrayList<class_2248>> UNIFICATION_ENTRY_BLOCK = new Object2ObjectLinkedOpenHashMap();
    public static final Map<Supplier<class_2680>, TagPrefix> ORES_INVERSE = new Object2ObjectLinkedOpenHashMap();

    public static void registerMaterialInfo(class_1935 item, ItemMaterialInfo materialInfo) {
        ITEM_MATERIAL_INFO.put(item, materialInfo);
    }

    public static ItemMaterialInfo getMaterialInfo(class_1935 item) {
        return ITEM_MATERIAL_INFO.get(item);
    }

    public static void registerUnificationItems(UnificationEntry unificationEntry, class_1935 ... items) {
        UNIFICATION_ENTRY_ITEM.computeIfAbsent(unificationEntry, entry -> new ArrayList()).addAll(Arrays.stream(items).toList());
        for (class_1935 item : items) {
            ITEM_UNIFICATION_ENTRY.put(item, unificationEntry);
            if (item instanceof class_2248) {
                class_2248 block = (class_2248)item;
                UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> new ArrayList()).add(block);
                continue;
            }
            if (!(item instanceof BlockEntry)) continue;
            BlockEntry blockEntry = (BlockEntry)item;
            UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> new ArrayList()).add((class_2248)blockEntry.get());
        }
        if (TagPrefix.ORES.containsKey(unificationEntry.tagPrefix) && !ORES_INVERSE.containsValue(unificationEntry.tagPrefix)) {
            ORES_INVERSE.put(TagPrefix.ORES.get(unificationEntry.tagPrefix).stoneType(), unificationEntry.tagPrefix);
        }
    }

    public static void registerUnificationItems(TagPrefix tagPrefix, @Nullable Material material, class_1935 ... items) {
        ChemicalHelper.registerUnificationItems(new UnificationEntry(tagPrefix, material), items);
    }

    @Nullable
    public static MaterialStack getMaterial(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return null;
        }
        return ChemicalHelper.getMaterial((class_1935)itemStack.method_7909());
    }

    @Nullable
    public static MaterialStack getMaterial(UnificationEntry entry) {
        Material entryMaterial;
        if (entry != null && (entryMaterial = entry.material) != null) {
            return new MaterialStack(entryMaterial, entry.tagPrefix.getMaterialAmount(entryMaterial));
        }
        return null;
    }

    @Nullable
    public static MaterialStack getMaterial(class_1935 itemLike) {
        Material entryMaterial;
        UnificationEntry entry = ITEM_UNIFICATION_ENTRY.get(itemLike);
        if (entry != null && (entryMaterial = entry.material) != null) {
            return new MaterialStack(entryMaterial, entry.tagPrefix.getMaterialAmount(entryMaterial));
        }
        ItemMaterialInfo info = ITEM_MATERIAL_INFO.get(itemLike);
        return info == null ? null : info.getMaterial().copy();
    }

    @Nullable
    public static Material getMaterial(class_3611 fluid) {
        return FLUID_MATERIAL.computeIfAbsent(fluid, f -> {
            for (Material material : GTRegistries.MATERIALS) {
                if (!material.hasProperty(PropertyKey.FLUID)) continue;
                FluidProperty property = material.getProperty(PropertyKey.FLUID);
                for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                    class_3611 stored = property.getStorage().get(key);
                    class_6862<class_3611> tag = TagUtil.createFluidTag(class_7923.field_41173.method_10221((Object)stored).method_12832());
                    if (!Platform.isForge() && tag.comp_327().equals((Object)new class_2960("water")) && !stored.method_15780((class_3611)class_3612.field_15910) || !Platform.isForge() && tag.comp_327().equals((Object)new class_2960("lava")) && !stored.method_15780((class_3611)class_3612.field_15908) || f != stored && !f.method_15791(tag)) continue;
                    return material;
                }
            }
            return null;
        });
    }

    @Nullable
    public static TagPrefix getPrefix(class_1935 itemLike) {
        if (itemLike == null) {
            return null;
        }
        UnificationEntry entry = ITEM_UNIFICATION_ENTRY.get(itemLike);
        if (entry != null) {
            return entry.tagPrefix;
        }
        return null;
    }

    public static class_1799 getDust(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.DUST) || materialAmount <= 0L) {
            return class_1799.field_8037;
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return ChemicalHelper.get(TagPrefix.dust, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 4L % 3628800L == 0L || materialAmount >= 29030400L) {
            return ChemicalHelper.get(TagPrefix.dustSmall, material, (int)(materialAmount * 4L / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return ChemicalHelper.get(TagPrefix.dustTiny, material, (int)(materialAmount * 9L / 3628800L));
        }
        return class_1799.field_8037;
    }

    public static class_1799 getDust(MaterialStack materialStack) {
        return ChemicalHelper.getDust(materialStack.material(), materialStack.amount());
    }

    public static class_1799 getIngot(Material material, long materialAmount) {
        if (!material.hasProperty(PropertyKey.INGOT) || materialAmount <= 0L) {
            return class_1799.field_8037;
        }
        if (materialAmount % 32659200L == 0L) {
            return ChemicalHelper.get(TagPrefix.block, material, (int)(materialAmount / 32659200L));
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return ChemicalHelper.get(TagPrefix.ingot, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return ChemicalHelper.get(TagPrefix.nugget, material, (int)(materialAmount * 9L / 3628800L));
        }
        return class_1799.field_8037;
    }

    public static class_1799 getIngotOrDust(Material material, long materialAmount) {
        class_1799 ingotStack = ChemicalHelper.getIngot(material, materialAmount);
        if (ingotStack != class_1799.field_8037) {
            return ingotStack;
        }
        return ChemicalHelper.getDust(material, materialAmount);
    }

    public static class_1799 getIngotOrDust(MaterialStack materialStack) {
        return ChemicalHelper.getIngotOrDust(materialStack.material(), materialStack.amount());
    }

    public static class_1799 getGem(MaterialStack materialStack) {
        if (materialStack.material().hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(materialStack.material()) && materialStack.amount() == TagPrefix.gem.getMaterialAmount(materialStack.material())) {
            return ChemicalHelper.get(TagPrefix.gem, materialStack.material(), (int)(materialStack.amount() / 3628800L));
        }
        return ChemicalHelper.getDust(materialStack);
    }

    @Nullable
    public static UnificationEntry getUnificationEntry(class_1935 item) {
        return ITEM_UNIFICATION_ENTRY.get(item);
    }

    public static UnificationEntry getUnificationEntry(class_6862<class_1792> tag) {
        return TAG_UNIFICATION_ENTRY.computeIfAbsent(tag, tagKey -> {
            for (TagPrefix prefix : TagPrefix.values()) {
                for (Material material : GTRegistries.MATERIALS) {
                    if (!Arrays.stream(prefix.getItemTags(material)).anyMatch(tagKey1 -> tagKey1.comp_327().equals((Object)tagKey.comp_327()))) continue;
                    return new UnificationEntry(prefix, material);
                }
            }
            return new UnificationEntry.EmptyMapMarkerEntry();
        });
    }

    @Nullable
    public static UnificationEntry getOrComputeUnificationEntry(class_1935 item) {
        return ITEM_UNIFICATION_ENTRY.computeIfAbsent(item, itemLike -> {
            class_6880 holder = class_7923.field_41178.method_47983((Object)itemLike.method_8389());
            return holder.method_40228().map(ChemicalHelper::getUnificationEntry).filter(Objects::nonNull).filter(entry -> !(entry instanceof UnificationEntry.EmptyMapMarkerEntry)).findFirst().orElse(null);
        });
    }

    public static List<class_1935> getItems(UnificationEntry unificationEntry) {
        return UNIFICATION_ENTRY_ITEM.computeIfAbsent(unificationEntry, entry -> {
            ArrayList<class_1935> items = new ArrayList<class_1935>();
            for (class_6862<class_1792> tag : ChemicalHelper.getTags(entry.tagPrefix, entry.material)) {
                for (class_6880 itemHolder : class_7923.field_41178.method_40286(tag)) {
                    items.add((class_1935)itemHolder.comp_349());
                }
            }
            TagPrefix prefix = entry.tagPrefix;
            if (items.isEmpty() && prefix.hasItemTable() && prefix.doGenerateItem(entry.material)) {
                return new ArrayList<class_1935>(List.of(prefix.getItemFromTable(entry.material).get()));
            }
            return items;
        });
    }

    public static class_1799 get(UnificationEntry unificationEntry, int size) {
        List<class_1935> list = ChemicalHelper.getItems(unificationEntry);
        if (list.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 stack = list.get(0).method_8389().method_7854();
        stack.method_7939(size);
        return stack;
    }

    public static class_1799 get(TagPrefix orePrefix, Material material, int stackSize) {
        return ChemicalHelper.get(new UnificationEntry(orePrefix, material), stackSize);
    }

    public static class_1799 get(TagPrefix orePrefix, Material material) {
        return ChemicalHelper.get(orePrefix, material, 1);
    }

    public static List<class_2248> getBlocks(UnificationEntry unificationEntry) {
        return UNIFICATION_ENTRY_BLOCK.computeIfAbsent(unificationEntry, entry -> {
            ArrayList<class_2248> blocks = new ArrayList<class_2248>();
            for (class_6862 tag : Arrays.stream(ChemicalHelper.getTags(unificationEntry.tagPrefix, unificationEntry.material)).map(itemTagKey -> class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)itemTagKey.comp_327())).toList()) {
                for (class_6880 itemHolder : class_7923.field_41175.method_40286(tag)) {
                    blocks.add((class_2248)itemHolder.comp_349());
                }
            }
            return blocks;
        });
    }

    public static class_2248 getBlock(UnificationEntry unificationEntry) {
        List<class_2248> list = ChemicalHelper.getBlocks(unificationEntry);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static class_2248 getBlock(TagPrefix orePrefix, Material material) {
        return ChemicalHelper.getBlock(new UnificationEntry(orePrefix, material));
    }

    @Nullable
    public static class_6862<class_2248> getBlockTag(TagPrefix orePrefix, @Nonnull Material material) {
        class_6862<class_2248>[] tags = orePrefix.getBlockTags(material);
        if (tags.length > 0) {
            return tags[0];
        }
        return null;
    }

    @Nullable
    public static class_6862<class_1792> getTag(TagPrefix orePrefix, @Nonnull Material material) {
        class_6862<class_1792>[] tags = orePrefix.getItemTags(material);
        if (tags.length > 0) {
            return tags[0];
        }
        return null;
    }

    public static class_6862<class_1792>[] getTags(TagPrefix orePrefix, @Nonnull Material material) {
        return orePrefix.getItemTags(material);
    }

    public static List<Map.Entry<class_1799, ItemMaterialInfo>> getAllItemInfos() {
        return ITEM_MATERIAL_INFO.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<class_1799, ItemMaterialInfo>(new class_1799((class_1935)((class_1935)entry.getKey()).method_8389()), (ItemMaterialInfo)entry.getValue())).collect(Collectors.toList());
    }

    public static Optional<TagPrefix> getOrePrefix(class_2680 state) {
        return ORES_INVERSE.entrySet().stream().filter(entry -> ((class_2680)((Supplier)entry.getKey()).get()).equals(state)).map(Map.Entry::getValue).findFirst();
    }

    public static void reinitializeUnification() {
        UNIFICATION_ENTRY_ITEM.clear();
        UNIFICATION_ENTRY_BLOCK.clear();
        ITEM_UNIFICATION_ENTRY.clear();
        FLUID_MATERIAL.clear();
        TagsHandler.initExtraUnificationEntries();
        for (TagPrefix prefix2 : TagPrefix.values()) {
            prefix2.getIgnored().forEach((mat, items) -> {
                if (((class_1935[])items).length > 0) {
                    ChemicalHelper.registerUnificationItems(prefix2, mat, items);
                }
            });
        }
        GTItems.toUnify.forEach((x$0, xva$1) -> ChemicalHelper.registerUnificationItems(x$0, xva$1));
        GTBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> map.forEach((material, block) -> ChemicalHelper.registerUnificationItems(prefix, material, (class_1935)block.get())));
        GTBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> map.forEach((material, block) -> ChemicalHelper.registerUnificationItems(prefix, material, (class_1935)block.get())));
        GTBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> map.forEach((material, block) -> ChemicalHelper.registerUnificationItems(prefix, material, (class_1935)block.get())));
    }
}

