/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.fabric.compat;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IPlatformEnergyStorage;
import com.gregtechceu.gtceu.api.capability.PlatformEnergyCompat;
import com.gregtechceu.gtceu.api.capability.fabric.GTEnergyHelperImpl;
import com.gregtechceu.gtceu.api.capability.fabric.compat.CompatApiProvider;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class EUToREProvider
extends CompatApiProvider<IEnergyContainer, EnergyStorage, class_2350> {
    private long feBuffer;

    public EUToREProvider(BlockApiLookup.BlockApiProvider<EnergyStorage, class_2350> upvalue) {
        super(upvalue);
    }

    @Nullable
    public IEnergyContainer find(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_2350 context) {
        if (!ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative) {
            return null;
        }
        EnergyStorage energyStorage = (EnergyStorage)this.findUpvalue(world, pos, state, blockEntity, context);
        return energyStorage != null ? new GTEnergyWrapper(energyStorage) : null;
    }

    public class GTEnergyWrapper
    implements IEnergyContainer {
        private final IPlatformEnergyStorage energyStorage;

        public GTEnergyWrapper(EnergyStorage energyStorage) {
            this.energyStorage = GTEnergyHelperImpl.toPlatformEnergyStorage(energyStorage);
        }

        @Override
        public long acceptEnergyFromNetwork(class_2350 facing, long voltage, long amperage) {
            long receive = 0L;
            if (EUToREProvider.this.feBuffer > 0L) {
                receive = this.energyStorage.insert(EUToREProvider.this.feBuffer, true);
                if (receive == 0L) {
                    return 0L;
                }
                if (EUToREProvider.this.feBuffer > receive) {
                    EUToREProvider.this.feBuffer -= receive;
                    this.energyStorage.insert(receive, false);
                    return 0L;
                }
                receive = EUToREProvider.this.feBuffer;
                EUToREProvider.this.feBuffer = 0L;
            }
            long maxPacket = PlatformEnergyCompat.toNativeLong(voltage, PlatformEnergyCompat.ratio(false));
            long maximalValue = maxPacket * amperage;
            if (receive != 0L) {
                long consumable = this.energyStorage.insert(maximalValue + receive, true);
                if (consumable == 0L) {
                    return 0L;
                }
                if (consumable == receive) {
                    this.energyStorage.insert(consumable, false);
                    return 0L;
                }
                if (consumable == maximalValue + receive) {
                    this.energyStorage.insert(consumable, false);
                    return amperage;
                }
                long newPower = consumable - receive;
                if (newPower % maxPacket == 0L) {
                    return this.energyStorage.insert(consumable, false) / maxPacket;
                }
                long ampsToConsume = newPower / maxPacket + 1L;
                EUToREProvider.this.feBuffer = maxPacket * ampsToConsume - consumable;
                this.energyStorage.insert(consumable, false);
                return ampsToConsume;
            }
            long consumable = this.energyStorage.insert(maximalValue, true);
            if (consumable == 0L) {
                return 0L;
            }
            if (consumable == maximalValue) {
                this.energyStorage.insert(consumable, false);
                return amperage;
            }
            if (consumable % maxPacket == 0L) {
                return this.energyStorage.insert(consumable, false) / maxPacket;
            }
            long ampsToConsume = consumable / maxPacket + 1L;
            EUToREProvider.this.feBuffer = maxPacket * ampsToConsume - consumable;
            this.energyStorage.insert(consumable, false);
            return ampsToConsume;
        }

        @Override
        public long changeEnergy(long delta) {
            if (delta == 0L) {
                return 0L;
            }
            if (delta < 0L) {
                return PlatformEnergyCompat.extractEu(this.energyStorage, -delta);
            }
            return PlatformEnergyCompat.insertEu(this.energyStorage, delta);
        }

        @Override
        public long getEnergyCapacity() {
            return PlatformEnergyCompat.toEu(this.energyStorage.getCapacity(), PlatformEnergyCompat.ratio(false));
        }

        @Override
        public long getEnergyStored() {
            return PlatformEnergyCompat.toEu(this.energyStorage.getAmount(), PlatformEnergyCompat.ratio(false));
        }

        @Override
        public long getEnergyCanBeInserted() {
            return Math.max(1L, this.getEnergyCapacity() - this.getEnergyStored());
        }

        @Override
        public long getInputAmperage() {
            return this.getInputVoltage() == 0L ? 0L : 2L;
        }

        @Override
        public long getInputVoltage() {
            long maxInput = this.energyStorage.insert(Integer.MAX_VALUE, true);
            if (maxInput == 0L) {
                return 0L;
            }
            return GTValues.V[GTUtil.getTierByVoltage(PlatformEnergyCompat.toEu(maxInput, PlatformEnergyCompat.ratio(false)))];
        }

        @Override
        public boolean inputsEnergy(class_2350 facing) {
            return this.energyStorage.supportsInsertion();
        }

        @Override
        public boolean outputsEnergy(class_2350 facing) {
            return false;
        }

        @Override
        public boolean isOneProbeHidden() {
            return true;
        }
    }
}

