/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.client.renderer.block.MaterialBlockRenderer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.Platform;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1540;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_322;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class MaterialBlock
extends AppearanceBlock {
    public final TagPrefix tagPrefix;
    public final Material material;

    public MaterialBlock(class_4970.class_2251 properties, TagPrefix tagPrefix, Material material, boolean registerModel) {
        super(properties);
        this.material = material;
        this.tagPrefix = tagPrefix;
        if (registerModel && Platform.isClient()) {
            MaterialBlockRenderer.create(this, tagPrefix.materialIconType(), material.getMaterialIconSet());
        }
    }

    public MaterialBlock(class_4970.class_2251 properties, TagPrefix tagPrefix, Material material) {
        this(properties, tagPrefix, material, true);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_322 tintedColor() {
        return (state, reader, pos, tintIndex) -> {
            class_2248 patt2101$temp = state.method_26204();
            if (patt2101$temp instanceof MaterialBlock) {
                MaterialBlock block = (MaterialBlock)patt2101$temp;
                return block.material.getLayerARGB(tintIndex);
            }
            return -1;
        };
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.method_39279(pos, (class_2248)this, this.getDelayAfterPlace());
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.method_39279(currentPos, (class_2248)this, this.getDelayAfterPlace());
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (!class_2346.method_10128((class_2680)level.method_8320(pos.method_10074())) || pos.method_10264() < level.method_31607()) {
            return;
        }
        class_1540.method_40005((class_1937)level, (class_2338)pos, (class_2680)state);
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (!(TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall)) {
            return;
        }
        if (random.method_43048(16) == 0 && class_2346.method_10128((class_2680)level.method_8320(pos.method_10074()))) {
            double d = (double)pos.method_10263() + random.method_43058();
            double e = (double)pos.method_10264() - 0.05;
            double f = (double)pos.method_10260() + random.method_43058();
            level.method_8406((class_2394)new class_2388(class_2398.field_11206, state), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public String method_9539() {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public class_5250 method_9518() {
        return this.tagPrefix.getLocalizedName(this.material);
    }
}

