/*
 * Decompiled with CFR 0.152.
 */
package giselle.gmut.common.content.gear.mekasuit;

import giselle.gmut.common.GMUTLang;
import giselle.gmut.common.content.gear.mekasuit.VerticalSpeed;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.CommonPlayerTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
public class ModuleGravitationalModulatingAdditionalUnit
implements ICustomModule<ModuleGravitationalModulatingAdditionalUnit> {
    private IModuleConfigItem<Boolean> flyAlways;
    private IModuleConfigItem<Boolean> stopImmediately;
    private IModuleConfigItem<Boolean> fixFOV;
    private IModuleConfigItem<VerticalSpeed> verticalSpeed;

    public void init(IModule<ModuleGravitationalModulatingAdditionalUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.flyAlways = configItemCreator.createConfigItem("fly_always", (ILangEntry)GMUTLang.MODULE_FLY_ALWAYS, (ModuleConfigData)new ModuleBooleanData(false));
        this.stopImmediately = configItemCreator.createConfigItem("stop_immediately", (ILangEntry)GMUTLang.MODULE_STOP_IMMEDIATELY, (ModuleConfigData)new ModuleBooleanData(true));
        this.fixFOV = configItemCreator.createConfigItem("fix_fov", (ILangEntry)GMUTLang.MODULE_FIX_FOV, (ModuleConfigData)new ModuleBooleanData(false));
        this.verticalSpeed = configItemCreator.createConfigItem("vertical_speed", (ILangEntry)GMUTLang.MODULE_VERTICAL_SPEED, (ModuleConfigData)new ModuleEnumData(VerticalSpeed.class, (Enum)VerticalSpeed.OFF));
    }

    public void tickServer(IModule<ModuleGravitationalModulatingAdditionalUnit> module, PlayerEntity player) {
        boolean hasGravitationalModulator = CommonPlayerTickHandler.isGravitationalModulationReady((PlayerEntity)player);
        if (hasGravitationalModulator && ((Boolean)this.flyAlways.get()).booleanValue() && !player.func_225608_bj_() && !player.field_71075_bZ.field_75100_b) {
            player.field_71075_bZ.field_75100_b = true;
            player.func_71016_p();
        }
    }

    public void tickClient(IModule<ModuleGravitationalModulatingAdditionalUnit> module, PlayerEntity player) {
        this.tickServer(module, player);
        boolean hasGravitationalModulator = CommonPlayerTickHandler.isGravitationalModulationReady((PlayerEntity)player);
        if (hasGravitationalModulator) {
            if (((Boolean)this.stopImmediately.get()).booleanValue() && player.field_71075_bZ.field_75100_b && player.field_191988_bg == 0.0f && player.field_70702_br == 0.0f) {
                Vector3d deltaMovement = player.func_213322_ci();
                player.func_213317_d(deltaMovement.func_216372_d(0.0, 1.0, 0.0));
            }
            if (player instanceof ClientPlayerEntity) {
                ClientPlayerEntity clientPlayer = (ClientPlayerEntity)player;
                if (clientPlayer.field_71075_bZ.field_75100_b && Minecraft.func_71410_x().func_175606_aa() == clientPlayer) {
                    float j = 0.0f;
                    if (clientPlayer.field_71158_b.field_228350_h_) {
                        j -= 1.0f;
                    }
                    if (clientPlayer.field_71158_b.field_78901_c) {
                        j += 1.0f;
                    }
                    if (j != 0.0f) {
                        Vector3d deltaMovement = clientPlayer.func_213322_ci();
                        clientPlayer.func_213317_d(deltaMovement.func_72441_c(0.0, (double)((j *= ((VerticalSpeed)((Object)this.getVerticalSpeed().get())).getSpeed() - 1.0f) * clientPlayer.field_71075_bZ.func_75093_a() * 3.0f), 0.0));
                    }
                }
            }
        }
    }

    public void changeMode(IModule<ModuleGravitationalModulatingAdditionalUnit> module, PlayerEntity player, ItemStack stack, int shift, boolean displayChangeMessage) {
        VerticalSpeed nextSpeed;
        VerticalSpeed prevSpeed;
        if (module.isEnabled() && (prevSpeed = (VerticalSpeed)((Object)this.getVerticalSpeed().get())) != (nextSpeed = (VerticalSpeed)prevSpeed.adjust(shift))) {
            this.getVerticalSpeed().set((Object)nextSpeed);
            if (displayChangeMessage) {
                module.displayModeChange(player, (ITextComponent)GMUTLang.MODULE_VERTICAL_SPEED.translate(new Object[0]), (IHasTextComponent)nextSpeed);
            }
        }
    }

    public IModuleConfigItem<Boolean> getFlyAlways() {
        return this.flyAlways;
    }

    public IModuleConfigItem<Boolean> getStopImmediately() {
        return this.stopImmediately;
    }

    public IModuleConfigItem<Boolean> getFixFOV() {
        return this.fixFOV;
    }

    public IModuleConfigItem<VerticalSpeed> getVerticalSpeed() {
        return this.verticalSpeed;
    }
}

