/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.api.ModSupport;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.content.TechnicalGravestoneBlock;
import net.pneumono.gravestones.content.entity.GravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.GravestoneData;
import net.pneumono.gravestones.gravestones.GravestonePosition;
import net.pneumono.gravestones.gravestones.GravestoneTime;
import net.pneumono.gravestones.gravestones.PlayerGravestoneData;

public class GravestoneCreation {
    public static void logger(String string) {
        GravestoneCreation.logger(string, LoggerInfoType.INFO, null);
    }

    public static void logger(String string, LoggerInfoType type) {
        GravestoneCreation.logger(string, type, null);
    }

    public static void logger(String string, LoggerInfoType type, Throwable t) {
        if (((Boolean)Gravestones.CONSOLE_INFO.getValue()).booleanValue()) {
            switch (type) {
                case INFO: {
                    Gravestones.LOGGER.info(string);
                    break;
                }
                case WARN: {
                    Gravestones.LOGGER.warn(string);
                    break;
                }
                case ERROR: {
                    if (t != null) {
                        Gravestones.LOGGER.error(string, t);
                        break;
                    }
                    Gravestones.LOGGER.error(string);
                }
            }
        }
    }

    public static String posToString(class_2338 pos) {
        return "(" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + ")";
    }

    public static void handleGravestones(class_1657 player) {
        GravestoneCreation.logger("----- ----- Beginning Gravestone Work ----- -----");
        GravestoneCreation.logger("This mostly exists for debugging purposes, but might be useful for server owners. If you don't want to see all this every time someone dies, disable 'gravestoneInfoInConsole' in the config!");
        class_1937 world = player.method_37908();
        class_2338 playerPos = player.method_24515();
        String playerName = player.method_5477().getString();
        GameProfile playerProfile = player.method_7334();
        if (world.method_8450().method_8355(class_1928.field_19389)) {
            GravestoneCreation.logger("Nevermind, keepInventory is on!");
            return;
        }
        class_2338 gravestonePos = GravestoneCreation.placeGravestone(world, playerPos);
        if (gravestonePos == null) {
            GravestoneCreation.logger("Gravestone was not placed successfully! The items have been dropped on the floor", LoggerInfoType.ERROR);
        } else {
            Object object;
            GravestoneCreation.logger("Placed " + playerName + "'s (" + playerProfile.getId() + ") Gravestone at " + GravestoneCreation.posToString(gravestonePos));
            MinecraftServer server = world.method_8503();
            if (server != null && ((Boolean)Gravestones.BROADCAST_COORDINATES_IN_CHAT.getValue()).booleanValue()) {
                server.method_3760().method_43514((class_2561)class_2561.method_43469((String)"gravestones.grave_spawned", (Object[])new Object[]{playerName, GravestoneCreation.posToString(gravestonePos)}).method_27692(class_124.field_1075), false);
            }
            if ((object = world.method_8321(gravestonePos)) instanceof GravestoneBlockEntity) {
                GravestoneBlockEntity gravestone = (GravestoneBlockEntity)object;
                gravestone.setGraveOwner(playerProfile);
                gravestone.setSpawnDate(GravestoneTime.getCurrentTimeAsString(), world.method_8510());
                GravestoneCreation.insertPlayerItemsAndExperience(gravestone, player);
                GravestoneCreation.insertModData(player, gravestone);
                world.method_8413(gravestonePos, world.method_8320(gravestonePos), world.method_8320(gravestonePos), 2);
                GravestoneCreation.logger("Gave Gravestone it's data (graveOwner, spawnDate, and inventory)");
            } else {
                GravestoneCreation.logger("Gravestone position does not have a block entity!", LoggerInfoType.ERROR);
            }
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            List<GravestonePosition> oldGravePositions = GravestoneCreation.readAndWriteData(serverWorld, playerProfile, playerName, gravestonePos);
            if (!((Boolean)Gravestones.DECAY_WITH_DEATHS.getValue()).booleanValue()) {
                GravestoneCreation.logger("Gravestone death damage has been disabled in the config, so no graves were damaged");
            } else if (oldGravePositions == null) {
                GravestoneCreation.logger("No graves to damage!");
            } else {
                for (GravestonePosition oldPos : oldGravePositions) {
                    String damageType;
                    class_3218 graveWorld = serverWorld.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)oldPos.dimension));
                    if (graveWorld == null) {
                        GravestoneCreation.logger("GravePosition's dimension (" + oldPos.dimension.toString() + ") does not exist!", LoggerInfoType.ERROR);
                        continue;
                    }
                    if (!graveWorld.method_8320(oldPos.asBlockPos()).method_27852(GravestonesRegistry.GRAVESTONE_TECHNICAL)) {
                        GravestoneCreation.logger("No gravestone was found at the position " + GravestoneCreation.posToString(oldPos.asBlockPos()) + " in dimension " + oldPos.dimension.toString() + ". Most likely this is because the grave has already been collected, or was decayed");
                        continue;
                    }
                    int deathDamage = (Integer)graveWorld.method_8320(oldPos.asBlockPos()).method_11654((class_2769)TechnicalGravestoneBlock.DEATH_DAMAGE);
                    int ageDamage = (Integer)graveWorld.method_8320(oldPos.asBlockPos()).method_11654((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE);
                    String graveData = "Age: " + ageDamage + ", Death: " + deathDamage;
                    if (ageDamage + deathDamage >= 2) {
                        damageType = "broken";
                        graveWorld.method_22352(oldPos.asBlockPos(), true);
                    } else {
                        damageType = "damaged";
                        graveWorld.method_8501(oldPos.asBlockPos(), (class_2680)graveWorld.method_8320(oldPos.asBlockPos()).method_11657((class_2769)TechnicalGravestoneBlock.DEATH_DAMAGE, (Comparable)Integer.valueOf(deathDamage + 1)));
                    }
                    GravestoneCreation.logger("Gravestone (" + graveData + ") " + damageType + " at the position " + GravestoneCreation.posToString(oldPos.asBlockPos()) + " in dimension " + oldPos.dimension.toString());
                }
            }
        }
        GravestoneCreation.logger("----- ----- Ending Gravestone Work ----- -----");
    }

    public static void insertPlayerItemsAndExperience(GravestoneBlockEntity gravestone, class_1657 player) {
        GravestoneCreation.logger("Inserting Inventory items and experience into grave...");
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (class_1890.method_8225((class_1887)class_1893.field_9109, (class_1799)inventory.method_5438(i)) == 0) {
                gravestone.method_5447(i, inventory.method_5441(i));
                continue;
            }
            inventory.method_5441(i);
        }
        GravestoneCreation.logger("Items inserted!");
        if (((Boolean)Gravestones.STORE_EXPERIENCE.getValue()).booleanValue()) {
            gravestone.setExperience(player.method_6110());
            player.field_7510 = 0.0f;
            player.field_7520 = 0;
            player.field_7495 = 0;
            GravestoneCreation.logger("Experience inserted!");
        } else {
            GravestoneCreation.logger("Experience storing is disabled!");
        }
    }

    public static void insertModData(class_1657 entity, GravestoneBlockEntity gravestone) {
        GravestoneCreation.logger("Inserting additional mod data into grave...");
        for (ModSupport support : GravestonesApi.getModSupports()) {
            support.insertData(entity, gravestone);
        }
        GravestoneCreation.logger("Data inserted!");
    }

    private static List<GravestonePosition> readAndWriteData(class_3218 serverWorld, GameProfile playerProfile, String playerName, class_2338 gravestonePos) {
        UUID uuid = playerProfile.getId();
        File gravestoneFile = new File(serverWorld.method_8503().method_27050(class_5218.field_24188).toString(), "gravestone_data.json");
        List<GravestonePosition> posList = null;
        if (!gravestoneFile.exists()) {
            GravestoneCreation.logger("No gravestone data file exists! Creating one", LoggerInfoType.WARN);
            try {
                BufferedWriter writer = Files.newBufferedWriter(gravestoneFile.toPath(), new OpenOption[0]);
                new GsonBuilder().serializeNulls().setPrettyPrinting().create().toJson((Object)new GravestoneData(), (Appendable)writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                GravestoneCreation.logger("Could not create gravestone data file.", LoggerInfoType.ERROR, e);
            }
        }
        try {
            class_2960 dimension = serverWorld.method_27983().method_29177();
            GravestoneCreation.logger("Reading gravestone data file");
            BufferedReader reader = Files.newBufferedReader(gravestoneFile.toPath());
            GravestoneData data = (GravestoneData)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, GravestoneData.class);
            ((Reader)reader).close();
            if (!data.hasData()) {
                GravestoneCreation.logger("Gravestone data file has no data!");
            }
            GravestoneCreation.logger("Updating data/creating new data");
            posList = data.getPlayerGravePositions(uuid);
            PlayerGravestoneData playerData = data.getPlayerData(uuid);
            if (playerData != null) {
                playerData.shiftGraves(new GravestonePosition(dimension, gravestonePos));
            } else {
                playerData = new PlayerGravestoneData(uuid, new GravestonePosition(dimension, gravestonePos));
                GravestoneCreation.logger("Player does not have existing gravestone data, and so new data was created");
            }
            data.setPlayerData(playerData, uuid, new GravestonePosition(dimension, gravestonePos));
            GravestoneCreation.logger("Data added, " + playerName + " (" + uuid + ") has a new gravestone at " + GravestoneCreation.posToString(playerData.firstGrave.asBlockPos()) + " in dimension " + playerData.firstGrave.dimension.toString());
            GravestoneCreation.logger("Writing updated data back to file");
            BufferedWriter writer = Files.newBufferedWriter(gravestoneFile.toPath(), new OpenOption[0]);
            new GsonBuilder().serializeNulls().setPrettyPrinting().create().toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
            GravestoneCreation.logger("Attempting to damage previous graves");
        }
        catch (IOException e) {
            GravestoneCreation.logger("Could not update gravestone data file!", LoggerInfoType.ERROR, e);
        }
        return posList;
    }

    private static boolean hasNoIrreplaceableBlocks(class_1937 world, class_2338 blockPos) {
        return !world.method_8320(blockPos).method_26164(GravestonesRegistry.TAG_GRAVESTONE_IRREPLACEABLE);
    }

    private static void placeGravestoneAtPos(class_1937 world, class_2338 blockPos) {
        class_2680 gravestoneBlock = GravestonesRegistry.GRAVESTONE_TECHNICAL.method_9564();
        world.method_22352(blockPos, true);
        world.method_8501(blockPos, gravestoneBlock);
    }

    private static class_2338 placeGravestone(class_1937 world, class_2338 blockPos) {
        if (blockPos.method_10264() > 0 || blockPos.method_10264() > -64 && world.method_44013() == class_7134.field_37666) {
            return GravestoneCreation.placeGravestoneAtValidPos(world, blockPos);
        }
        if (world.method_44013() == class_7134.field_37668) {
            class_2338 islandCenter = GravestoneCreation.placeGravestoneAtValidPos(world, blockPos.method_33096(70));
            if (islandCenter != null) {
                GravestoneCreation.createGravestoneIsland(world, islandCenter, class_2246.field_10471.method_9564());
                return islandCenter;
            }
            return null;
        }
        if (world.method_44013() == class_7134.field_37667) {
            class_2338 islandCenter = GravestoneCreation.placeGravestoneAtValidPos(world, blockPos.method_33096(2));
            if (islandCenter != null) {
                GravestoneCreation.createGravestoneIsland(world, islandCenter, class_2246.field_10515.method_9564());
                return islandCenter;
            }
            return null;
        }
        if (world.method_44013() == class_7134.field_37666) {
            class_2338 islandCenter = GravestoneCreation.placeGravestoneAtValidPos(world, blockPos.method_33096(-62));
            if (islandCenter != null) {
                GravestoneCreation.createGravestoneIsland(world, islandCenter, class_2246.field_28888.method_9564());
                return islandCenter;
            }
            return null;
        }
        return null;
    }

    private static void createGravestoneIsland(class_1937 world, class_2338 gravestonePos, class_2680 state) {
        int j;
        int i;
        class_2338 islandCorner = gravestonePos.method_10074().method_10072().method_10067();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                GravestoneCreation.createIslandBlock(world, state, islandCorner.method_10076(i).method_10089(j));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    GravestoneCreation.removeIslandBlock(world, islandCorner.method_10076(i).method_10089(j).method_10086(k + 1));
                }
            }
        }
    }

    private static void createIslandBlock(class_1937 world, class_2680 state, class_2338 blockPos) {
        if (world.method_8320(blockPos).method_26215()) {
            world.method_8501(blockPos, state);
        }
    }

    private static void removeIslandBlock(class_1937 world, class_2338 blockPos) {
        if (!world.method_8320(blockPos).method_26164(GravestonesRegistry.TAG_GRAVESTONE_IRREPLACEABLE)) {
            world.method_22352(blockPos, true);
        }
    }

    private static class_2338 placeGravestoneAtValidPos(class_1937 world, class_2338 blockPos) {
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos)) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos);
            return blockPos;
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10084())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10084());
            return blockPos.method_10084();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10086(2))) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10086(2));
            return blockPos.method_10086(2);
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10095())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10095());
            return blockPos.method_10095();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10095().method_10084())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10095().method_10084());
            return blockPos.method_10095().method_10084();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10078())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10078());
            return blockPos.method_10078();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10078().method_10084())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10078().method_10084());
            return blockPos.method_10078().method_10084();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10072())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10072());
            return blockPos.method_10072();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10072().method_10084())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10072().method_10084());
            return blockPos.method_10072().method_10084();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10067())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10067());
            return blockPos.method_10067();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10067().method_10084())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10067().method_10084());
            return blockPos.method_10067().method_10084();
        }
        if (GravestoneCreation.hasNoIrreplaceableBlocks(world, blockPos.method_10074())) {
            GravestoneCreation.placeGravestoneAtPos(world, blockPos.method_10074());
            return blockPos.method_10074();
        }
        return null;
    }

    private static enum LoggerInfoType {
        INFO,
        WARN,
        ERROR;

    }
}

