/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.network.BaseMessageServer;
import com.yyon.grapplinghook.utils.Vec;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerMovementMessage
extends BaseMessageServer {
    public int entityId;
    public double x;
    public double y;
    public double z;
    public double mx;
    public double my;
    public double mz;

    public PlayerMovementMessage(PacketBuffer buf) {
        super(buf);
    }

    public PlayerMovementMessage(int entityId, double x, double y, double z, double mx, double my, double mz) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mx = mx;
        this.my = my;
        this.mz = mz;
    }

    @Override
    public void decode(PacketBuffer buf) {
        try {
            this.entityId = buf.readInt();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.mx = buf.readDouble();
            this.my = buf.readDouble();
            this.mz = buf.readDouble();
        }
        catch (Exception e) {
            System.out.print("Playermovement error: ");
            System.out.println(buf);
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.mx);
        buf.writeDouble(this.my);
        buf.writeDouble(this.mz);
    }

    @Override
    public void processMessage(NetworkEvent.Context ctx) {
        ServerPlayerEntity referencedPlayer = ctx.getSender();
        if (referencedPlayer.func_145782_y() == this.entityId) {
            new Vec(this.x, this.y, this.z).setPos((Entity)referencedPlayer);
            new Vec(this.mx, this.my, this.mz).setMotion((Entity)referencedPlayer);
            referencedPlayer.field_71135_a.func_184342_d();
            if (!referencedPlayer.func_233570_aj_()) {
                if (this.my >= 0.0) {
                    referencedPlayer.field_70143_R = 0.0f;
                } else {
                    double gravity = 0.1;
                    referencedPlayer.field_70143_R = (float)(Math.pow(this.my, 2.0) / (2.0 * gravity));
                }
            }
        }
    }
}

